/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class ScalableHeightTextField
extends TextField {
    private final SimpleDoubleProperty scale = new SimpleDoubleProperty(1.0);

    public ScalableHeightTextField(String text) {
        this(text, false);
    }

    public ScalableHeightTextField(String text, boolean startHidden) {
        super(text);
        this.setMinHeight(0.0);
        if (startHidden) {
            this.setPrefHeight(0.0);
            this.scale.set(0.0);
        }
        this.scale.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number newVal) {
                ScalableHeightTextField.this.setPrefHeight(newVal.doubleValue() * ScalableHeightTextField.this.computePrefHeight(9999.0));
            }
        });
        JavaFXUtil.workAroundFunctionKeyBug(this);
    }

    public void setToFullHeight() {
        this.scale.set(1.0);
    }

    public void setToNothing() {
        this.scale.set(0.0);
    }

    public Timeline getGrowToFullHeightTimeline(Duration dur) {
        return new Timeline(new KeyFrame[]{new KeyFrame(dur, new KeyValue[]{new KeyValue((WritableValue)this.scale, (Object)1.0)})});
    }

    public Timeline getShrinkToNothingTimeline(Duration dur) {
        return new Timeline(new KeyFrame[]{new KeyFrame(dur, new KeyValue[]{new KeyValue((WritableValue)this.scale, (Object)0.0)})});
    }

    public void animateToFromMonospace(boolean toMonospace, boolean zeroWidthWhenEmpty, SharedTransition animate) {
        if (toMonospace) {
            Font monospace = Font.font((String)"monospace", (double)this.getFont().getSize());
            double origWidth = this.getWidth();
            double targetWidth = zeroWidthWhenEmpty ? 0.0 : JavaFXUtil.measureString((TextInputControl)this, this.getText(), monospace, true, true);
            this.minWidthProperty().bind((ObservableValue)animate.getProgress().multiply(targetWidth - origWidth).add(origWidth));
        } else {
            double origWidth = this.getWidth();
            this.applyCss();
            double targetWidth = JavaFXUtil.measureString((TextInputControl)this, this.getText(), this.getFont(), true, true);
            this.minWidthProperty().unbind();
            this.minWidthProperty().bind((ObservableValue)animate.getProgress().multiply(targetWidth - origWidth).add(origWidth));
            animate.addOnStopped(() -> {
                this.minWidthProperty().unbind();
                this.setMinWidth(0.0);
            });
        }
    }
}

