/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class JavaNames {
    private static Set<String> javaKeywords = new HashSet<String>();

    public static boolean isIdentifier(String str) {
        if (str.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return !JavaNames.isJavaKeyword(str);
    }

    public static boolean isQualifiedIdentifier(String str) {
        if (str.length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(str, ".");
        while (st.hasMoreTokens()) {
            if (JavaNames.isIdentifier(st.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static String stripPrefix(String fullClassName) {
        int index;
        if (fullClassName != null && (index = fullClassName.lastIndexOf(".")) >= 0) {
            return fullClassName.substring(++index);
        }
        return fullClassName;
    }

    public static String stripSuffix(String name, String suffix) {
        int s = name.lastIndexOf(suffix);
        if (s > 0 && s == name.length() - suffix.length()) {
            return name.substring(0, s);
        }
        return name;
    }

    public static String getBase(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(".");
        if (index >= 0) {
            return qualifiedName.substring(++index);
        }
        return qualifiedName;
    }

    public static String getPrefix(String qualifiedName) {
        if (qualifiedName == null) {
            throw new NullPointerException();
        }
        int index = qualifiedName.lastIndexOf(".");
        if (index > 0) {
            return qualifiedName.substring(0, index);
        }
        return "";
    }

    public static String convertFileToQualifiedName(File baseDir, File f) {
        File pathFile = f;
        if (!pathFile.isAbsolute()) {
            pathFile = new File(baseDir, pathFile.getPath());
        }
        File parent = null;
        Object name = "";
        while ((parent = pathFile.getParentFile()) != null) {
            if (pathFile.equals(baseDir)) {
                return name;
            }
            if (name == "") {
                name = pathFile.getName();
                int firstDot = ((String)name).indexOf(46);
                if (firstDot >= 0) {
                    name = ((String)name).substring(0, firstDot);
                }
            } else {
                name = pathFile.getName() + "." + (String)name;
            }
            pathFile = parent;
        }
        return null;
    }

    public static File convertQualifiedNameToFile(String name, File root) {
        int n = 0;
        File f = root;
        int i = name.indexOf(46, n);
        while (i != -1) {
            String namePart = name.substring(n, i);
            f = new File(f, namePart);
            n = i + 1;
            i = name.indexOf(46, n);
        }
        return new File(f, name.substring(n));
    }

    public static String typeName(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        Object name = "";
        while (className.startsWith("[")) {
            className = className.substring(1);
            name = (String)name + "[]";
        }
        switch (className.charAt(0)) {
            case 'L': {
                name = className.substring(1, className.length() - 1) + (String)name;
                break;
            }
            case 'B': {
                name = "byte" + (String)name;
                break;
            }
            case 'C': {
                name = "char" + (String)name;
                break;
            }
            case 'D': {
                name = "double" + (String)name;
                break;
            }
            case 'F': {
                name = "float" + (String)name;
                break;
            }
            case 'I': {
                name = "int" + (String)name;
                break;
            }
            case 'J': {
                name = "long" + (String)name;
                break;
            }
            case 'S': {
                name = "short" + (String)name;
                break;
            }
            case 'Z': {
                name = "boolean" + (String)name;
            }
        }
        return name;
    }

    public static String combineNames(String firstPart, String secondPart) {
        if (firstPart == null || firstPart.length() == 0) {
            return secondPart;
        }
        if (secondPart == null || secondPart.length() == 0) {
            return firstPart;
        }
        return firstPart + "." + secondPart;
    }

    public static String getArrayElementType(String arrayType) {
        return JavaNames.stripSuffix(arrayType, "[]");
    }

    public static boolean isJavaKeyword(String word) {
        return javaKeywords.contains(word);
    }

    static {
        String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "false", "null", "true"};
        Collections.addAll(javaKeywords, keywords);
    }
}

