/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Boot;
import bluej.Config;
import bluej.parser.AssistContentThreadSafe;
import bluej.parser.ImportedTypeCompletion;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.Utility;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javafx.application.Platform;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ImportScanner {
    private final Object monitor = new Object();
    private CompletableFuture<RootPackageInfo> root;
    private final Project project;

    public ImportScanner(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    private CompletableFuture<? extends PackageInfo> getRoot() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.root != null) {
                return this.root;
            }
            this.root = new CompletableFuture();
            new Thread("Import scanner"){

                @Override
                public void run() {
                    RootPackageInfo rootPkg = ImportScanner.this.findAllTypes();
                    try {
                        ImportScanner.this.loadCachedImports(rootPkg);
                    }
                    finally {
                        ImportScanner.this.root.complete(rootPkg);
                    }
                }
            }.start();
            return this.root;
        }
    }

    @OnThread(value=Tag.Worker)
    public List<AssistContentThreadSafe> getImportedTypes(String importSrc) {
        try {
            return this.getRoot().get().getImportedTypes("", Arrays.asList(importSrc.split("\\.", -1)).iterator(), this.project.getJavadocResolver());
        }
        catch (InterruptedException | ExecutionException e) {
            Debug.reportError("Exception in getImportedTypes", e);
            return Collections.emptyList();
        }
    }

    @OnThread(value=Tag.Worker)
    private List<ClassGraph> getClassloaderConfig() {
        ArrayList<ClassLoader> cl = new ArrayList<ClassLoader>();
        try {
            CompletableFuture projectClassLoader = new CompletableFuture();
            Platform.runLater(() -> projectClassLoader.complete(this.project.getClassLoader()));
            cl.add((ClassLoader)projectClassLoader.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Debug.reportError(e);
        }
        cl.add(new URLClassLoader(Boot.getInstance().getRuntimeUserClassPath()));
        ClassGraph userClassGraph = new ClassGraph().overrideClassLoaders(cl.toArray(new ClassLoader[0])).rejectPackages(new String[]{"bluej.*"});
        ClassGraph systemClassGraph = new ClassGraph().enableSystemJarsAndModules().acceptPackages(new String[]{"java.*", "javax.*", "javafx.*"});
        return List.of(userClassGraph.enableClassInfo(), systemClassGraph.enableClassInfo());
    }

    @OnThread(value=Tag.Worker)
    private RootPackageInfo findAllTypes() {
        List<ClassGraph> classGraphs = this.getClassloaderConfig();
        RootPackageInfo r = new RootPackageInfo();
        if (classGraphs != null) {
            r.addClass("java.lang.Object");
            int threads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
            for (ClassGraph classGraph : classGraphs) {
                try (ScanResult result = classGraph.scan(threads);){
                    for (ClassInfo c : result.getAllClasses()) {
                        r.addClass(c.getName());
                    }
                }
                catch (Throwable t) {
                    Debug.reportError(t);
                }
            }
        }
        return r;
    }

    public void startScanning() {
        this.getRoot();
    }

    public void saveCachedImports() {
        if (this.getRoot().isDone()) {
            Element cache = new Element("packages");
            cache.addAttribute(new Attribute("javaHome", ImportScanner.getJavaHome()));
            cache.addAttribute(new Attribute("version", ImportScanner.getVersion()));
            try {
                PackageInfo javaPkg = this.getRoot().get().subPackages.get("java");
                if (javaPkg != null) {
                    cache.appendChild((Node)ImportScanner.toXML(javaPkg, "java"));
                    FileOutputStream os = new FileOutputStream(ImportScanner.getImportCachePath());
                    Utility.serialiseCodeTo(cache, os);
                    os.close();
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                Debug.reportError(e);
            }
        }
    }

    private static String getVersion() {
        return Config.isGreenfoot() ? "3.8.0" : "5.2.0";
    }

    private static String getJavaHome() {
        return Boot.getInstance().getJavaHome().getAbsolutePath();
    }

    private static File getImportCachePath() {
        return new File(Config.getUserConfigDir(), "import-cache.xml");
    }

    public void loadCachedImports(PackageInfo rootPkg) {
        try {
            Document xml = new Builder().build(ImportScanner.getImportCachePath());
            Element packagesEl = xml.getRootElement();
            if (!packagesEl.getLocalName().equals("packages")) {
                return;
            }
            if (!ImportScanner.getJavaHome().equals(packagesEl.getAttributeValue("javaHome")) || !ImportScanner.getVersion().equals(packagesEl.getAttributeValue("version"))) {
                return;
            }
            for (int i = 0; i < packagesEl.getChildElements().size(); ++i) {
                this.fromXML(packagesEl.getChildElements().get(i), rootPkg);
            }
        }
        catch (IOException | ParsingException e) {
            Debug.message(e.getClass().getName() + " while reading import cache: " + e.getMessage());
        }
    }

    private void fromXML(Element pkgEl, PackageInfo addToParent) {
        String name = pkgEl.getAttributeValue("name");
        if (name == null) {
            return;
        }
        PackageInfo loadPkg = new PackageInfo();
        for (int i = 0; i < pkgEl.getChildElements().size(); ++i) {
            Element el = pkgEl.getChildElements().get(i);
            if (el.getLocalName().equals("package")) {
                this.fromXML(el, loadPkg);
                continue;
            }
            AssistContentThreadSafe acts = new AssistContentThreadSafe(el);
            String nameWithoutPackage = (String)(acts.getDeclaringClass() == null ? "" : acts.getDeclaringClass() + "$") + acts.getName();
            loadPkg.types.put(nameWithoutPackage, acts);
        }
        addToParent.subPackages.putIfAbsent(name, new PackageInfo());
        addToParent.subPackages.get(name).addTypes(loadPkg);
    }

    private static Element toXML(PackageInfo pkg, String name) {
        Element el = new Element("package");
        el.addAttribute(new Attribute("name", name));
        pkg.types.values().forEach(acts -> {
            if (acts != null) {
                el.appendChild((Node)acts.toXML());
            }
        });
        pkg.subPackages.forEach((subName, subPkg) -> el.appendChild((Node)ImportScanner.toXML(subPkg, subName)));
        return el;
    }

    private class PackageInfo {
        public final HashMap<String, AssistContentThreadSafe> types = new HashMap();
        public final HashMap<String, PackageInfo> subPackages = new HashMap();

        private PackageInfo() {
        }

        protected void addClass(Iterator<String> packageIdents, String name) {
            if (packageIdents.hasNext()) {
                String ident = packageIdents.next();
                PackageInfo subPkg = this.subPackages.get(ident);
                if (subPkg == null) {
                    subPkg = new PackageInfo();
                    this.subPackages.put(ident, subPkg);
                }
                subPkg.addClass(packageIdents, name);
            } else {
                this.types.put(name, null);
            }
        }

        @OnThread(value=Tag.Worker)
        private AssistContentThreadSafe getType(String prefix, String name, JavadocResolver javadocResolver) {
            return this.types.computeIfAbsent(name, s -> {
                try {
                    CompletableFuture f = new CompletableFuture();
                    Platform.runLater(() -> {
                        Class<?> c = ImportScanner.this.project.loadClass(prefix + s);
                        if (c == null) {
                            f.complete(null);
                        } else {
                            f.complete(new AssistContentThreadSafe(new ImportedTypeCompletion(c, javadocResolver)));
                        }
                    });
                    return (AssistContentThreadSafe)f.get();
                }
                catch (Exception e) {
                    Debug.reportError(e);
                    return null;
                }
            });
        }

        @OnThread(value=Tag.Worker)
        public List<AssistContentThreadSafe> getImportedTypes(String prefix, Iterator<String> idents, JavadocResolver javadocResolver) {
            if (!idents.hasNext()) {
                return Collections.emptyList();
            }
            Object s = idents.next();
            if (((String)s).equals("*")) {
                ArrayList<String> typeNames = new ArrayList<String>(this.types.keySet());
                return typeNames.stream().map(t -> this.getType(prefix, (String)t, javadocResolver)).filter(ac -> ac != null).collect(Collectors.toList());
            }
            if (idents.hasNext()) {
                if (this.subPackages.containsKey(s)) {
                    return this.subPackages.get(s).getImportedTypes(prefix + (String)s + ".", idents, javadocResolver);
                }
                String currentClassIdentifier = s;
                AssistContentThreadSafe ac2 = null;
                do {
                    if (currentClassIdentifier.equals("*")) {
                        ArrayList<String> typeNames = new ArrayList<String>(this.types.keySet());
                        String outerClassName = currentClassIdentifier.replace(".*", "");
                        return typeNames.stream().map(t -> this.getType(prefix, (String)t, javadocResolver)).filter(acts -> acts != null && acts.getDeclaringClass() != null && acts.getDeclaringClass().equals(outerClassName)).collect(Collectors.toList());
                    }
                    ac2 = this.getType(prefix, (String)s, javadocResolver);
                    if (ac2 == null) continue;
                    if (idents.hasNext()) {
                        currentClassIdentifier = idents.next();
                        s = (String)s + "$" + currentClassIdentifier;
                        continue;
                    }
                    return Collections.singletonList(ac2);
                } while (ac2 != null);
                return Collections.emptyList();
            }
            AssistContentThreadSafe ac3 = this.getType(prefix, (String)s, javadocResolver);
            if (ac3 != null) {
                return Collections.singletonList(ac3);
            }
            return Collections.emptyList();
        }

        public void addTypes(PackageInfo from) {
            this.types.putAll(from.types);
            from.subPackages.forEach((name, pkg) -> {
                this.subPackages.putIfAbsent((String)name, new PackageInfo());
                this.subPackages.get(name).addTypes((PackageInfo)pkg);
            });
        }
    }

    private class RootPackageInfo
    extends PackageInfo {
        private RootPackageInfo() {
        }

        public void addClass(String name) {
            String[] splitParts = name.split("\\.", -1);
            this.addClass(Arrays.asList(Arrays.copyOf(splitParts, splitParts.length - 1)).iterator(), splitParts[splitParts.length - 1]);
        }
    }
}

