/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr.record;

import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.InvokerRecord;

public class ArrayElementGetRecord
extends InvokerRecord {
    private InvokerRecord parentIr;
    private int elementIndex;
    private String elementType;
    private String objName;
    private String objType;

    public ArrayElementGetRecord(String elementType, int elementIndex, InvokerRecord parentIr) {
        this.parentIr = parentIr;
        this.elementType = elementType;
        this.elementIndex = elementIndex;
        parentIr.incUsageCount();
    }

    @Override
    public boolean hasVoidResult() {
        return false;
    }

    @Override
    public void setBenchName(String name, String type) {
        this.objName = name;
        this.objType = type;
    }

    @Override
    public String toFixtureDeclaration(String firstIndent) {
        return firstIndent + "private " + this.objType + " " + this.objName + ";\n";
    }

    @Override
    public String toFixtureSetup(String secondIndent) {
        return secondIndent + this.objName + " = " + this.toExpression() + ";\n";
    }

    @Override
    public String toTestMethod(PkgMgrFrame pmf, String secondIndent) {
        return secondIndent + this.objType + " " + this.objName + " = " + this.toExpression() + ";\n";
    }

    @Override
    public String toExpression() {
        if (!this.objType.equals(this.elementType)) {
            return "((" + this.objType + ") " + this.parentIr.toExpression() + "[" + this.elementIndex + "])";
        }
        return this.parentIr.toExpression() + "[" + this.elementIndex + "]";
    }
}

