/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.CopyableHeaderItem;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.HeaderItem;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;

public class WrappableSlotLabel
implements HeaderItem,
CopyableHeaderItem {
    private final ObservableList<String> styleClasses = FXCollections.observableArrayList((Object[])new String[]{"wrappable-slot-label"});
    private final ObservableList<Label> words = FXCollections.observableArrayList();
    private final List<FXRunnable> unbinds = new ArrayList<FXRunnable>();
    private HangingFlowPane.FlowAlignment alignment;

    public WrappableSlotLabel(String fullText) {
        this.setText(fullText);
    }

    public void setText(String fullText) {
        this.words.clear();
        this.unbinds.forEach(FXRunnable::run);
        this.unbinds.clear();
        boolean first = true;
        for (String word : fullText.split(" ")) {
            if (word.equals("")) continue;
            Label l = new Label(word);
            l.setMinWidth(0.0);
            this.unbinds.add(JavaFXUtil.bindList(l.getStyleClass(), this.styleClasses));
            JavaFXUtil.setPseudoclass("bj-first", first, new Node[]{l});
            first = false;
            this.words.add((Object)l);
        }
        this.setAlignment(this.alignment);
    }

    public void addStyleClass(String styleClass) {
        if (!this.styleClasses.contains((Object)styleClass)) {
            this.styleClasses.add((Object)styleClass);
        }
    }

    @Override
    public EditableSlot asEditable() {
        return null;
    }

    @Override
    public ObservableList<? extends Node> getComponents() {
        return this.words;
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
    }

    public void fadeOut(SharedTransition animate, boolean setInvisible) {
        for (Label l : this.words) {
            l.opacityProperty().bind((ObservableValue)animate.getOppositeProgress());
        }
        animate.addOnStopped(() -> {
            for (Label l : this.words) {
                l.opacityProperty().unbind();
                if (!setInvisible) continue;
                l.setVisible(false);
            }
        });
    }

    public void fadeIn(SharedTransition animate) {
        for (Label l : this.words) {
            l.setVisible(true);
            l.opacityProperty().bind((ObservableValue)animate.getProgress());
        }
        animate.addOnStopped(() -> {
            for (Label l : this.words) {
                l.opacityProperty().unbind();
            }
        });
    }

    public void setAlignment(HangingFlowPane.FlowAlignment alignment) {
        this.alignment = alignment;
        this.words.forEach(l -> HangingFlowPane.setAlignment((Node)l, alignment));
    }

    public Stream<Node> makeDisplayClone(InteractionManager editor) {
        List<Node> copies = Utility.mapList(this.words, l -> JavaFXUtil.cloneLabel(l, (ObservableValue<String>)editor.getFontCSS()));
        copies.forEach(n -> HangingFlowPane.setAlignment(n, this.alignment));
        return copies.stream();
    }

    @Override
    public String getXPathForElementAt(double sceneX, double sceneY, LocatableElement.LocationMap locationMap, String xpathParent, boolean includePseudoElements, boolean includeSubstringIndex) {
        if (!this.words.isEmpty() && JavaFXUtil.containsScenePoint((Node)this.words.get(0), sceneX, sceneY)) {
            return xpathParent + (String)(includePseudoElements ? "/_" + ((Label)this.words.get(0)).getText().toLowerCase() : "");
        }
        return null;
    }
}

