/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.generic.Frame;
import bluej.utility.javafx.BetterVBox;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

class CanvasVBox
extends BetterVBox {
    private final SimpleStyleableDoubleProperty leftMarginProperty = new SimpleStyleableDoubleProperty(LEFT_MARGIN_META_DATA);
    private final SimpleStyleableDoubleProperty bottomMarginProperty = new SimpleStyleableDoubleProperty(BOTTOM_MARGIN_META_DATA);
    private final SimpleStyleableDoubleProperty topMarginProperty = new SimpleStyleableDoubleProperty(TOP_MARGIN_META_DATA);
    private final SimpleStyleableDoubleProperty rightMarginProperty = new SimpleStyleableDoubleProperty(RIGHT_MARGIN_META_DATA);
    private final SimpleStyleableDoubleProperty cssMinHeightProperty = new SimpleStyleableDoubleProperty(MIN_HEIGHT_META_DATA);
    private final SimpleStyleableDoubleProperty frameMarginTopProperty = new SimpleStyleableDoubleProperty(TOP_FRAME_MARGIN_META_DATA);
    private final SimpleStyleableDoubleProperty frameMarginBottomProperty = new SimpleStyleableDoubleProperty(BOTTOM_FRAME_MARGIN_META_DATA);
    private final SimpleStyleableDoubleProperty curlyBracketHeight = new SimpleStyleableDoubleProperty(CURLY_BRACKET_HEIGHT_META_DATA);
    private final SimpleStyleableObjectProperty<Color> borderColorProperty = new SimpleStyleableObjectProperty(BORDER_COLOR_META_DATA);
    private final SimpleStyleableObjectProperty<Insets> borderInsetsProperty = new SimpleStyleableObjectProperty(BORDER_INSETS_META_DATA);
    private final SimpleStyleableObjectProperty<Color> backgroundColorProperty = new SimpleStyleableObjectProperty(BACKGROUND_COLOR_META_DATA);
    private final SimpleStyleableObjectProperty<Insets> backgroundInsetsProperty = new SimpleStyleableObjectProperty(BACKGROUND_INSETS_META_DATA);
    private final SimpleStyleableObjectProperty<Insets> borderWidthProperty = new SimpleStyleableObjectProperty(BORDER_WIDTH_META_DATA);
    private final SimpleStyleableObjectProperty<Insets> borderRadiusProperty = new SimpleStyleableObjectProperty(BORDER_RADIUS_META_DATA);
    private final SimpleStyleableObjectProperty<Insets> backgroundRadiusProperty = new SimpleStyleableObjectProperty(BACKGROUND_RADIUS_META_DATA);
    private static final CssMetaData<CanvasVBox, Number> LEFT_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-left-margin", v -> v.leftMarginProperty);
    private static final CssMetaData<CanvasVBox, Number> BOTTOM_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-bottom-margin", v -> v.bottomMarginProperty);
    private static final CssMetaData<CanvasVBox, Number> TOP_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-top-margin", v -> v.topMarginProperty);
    private static final CssMetaData<CanvasVBox, Number> RIGHT_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-right-margin", v -> v.rightMarginProperty);
    private static final CssMetaData<CanvasVBox, Number> MIN_HEIGHT_META_DATA = JavaFXUtil.cssSize("-bj-min-height", v -> v.cssMinHeightProperty);
    private static final CssMetaData<CanvasVBox, Number> CURLY_BRACKET_HEIGHT_META_DATA = JavaFXUtil.cssSize("-bj-curly-bracket-height", v -> v.curlyBracketHeight);
    private static final CssMetaData<CanvasVBox, Number> TOP_FRAME_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-frame-margin-top", v -> v.frameMarginTopProperty);
    private static final CssMetaData<CanvasVBox, Number> BOTTOM_FRAME_MARGIN_META_DATA = JavaFXUtil.cssSize("-bj-frame-margin-bottom", v -> v.frameMarginBottomProperty);
    private static final CssMetaData<CanvasVBox, Color> BORDER_COLOR_META_DATA = JavaFXUtil.cssColor("-bj-border-color", v -> v.borderColorProperty);
    private static final CssMetaData<CanvasVBox, Color> BACKGROUND_COLOR_META_DATA = JavaFXUtil.cssColor("-bj-background-color", v -> v.backgroundColorProperty);
    private static final CssMetaData<CanvasVBox, Insets> BORDER_INSETS_META_DATA = JavaFXUtil.cssInsets("-bj-border-insets", v -> v.borderInsetsProperty);
    private static final CssMetaData<CanvasVBox, Insets> BACKGROUND_INSETS_META_DATA = JavaFXUtil.cssInsets("-bj-background-insets", v -> v.backgroundInsetsProperty);
    private static final CssMetaData<CanvasVBox, Insets> BORDER_RADIUS_META_DATA = JavaFXUtil.cssInsets("-bj-border-radius", v -> v.borderRadiusProperty);
    private static final CssMetaData<CanvasVBox, Insets> BORDER_WIDTH_META_DATA = JavaFXUtil.cssInsets("-bj-border-width", v -> v.borderWidthProperty);
    private static final CssMetaData<CanvasVBox, Insets> BACKGROUND_RADIUS_META_DATA = JavaFXUtil.cssInsets("-bj-background-radius", v -> v.backgroundRadiusProperty);
    private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList = JavaFXUtil.extendCss(Pane.getClassCssMetaData()).add(LEFT_MARGIN_META_DATA).add(BOTTOM_MARGIN_META_DATA).add(TOP_MARGIN_META_DATA).add(RIGHT_MARGIN_META_DATA).add(MIN_HEIGHT_META_DATA).add(TOP_FRAME_MARGIN_META_DATA).add(BOTTOM_FRAME_MARGIN_META_DATA).add(CURLY_BRACKET_HEIGHT_META_DATA).add(BORDER_COLOR_META_DATA).add(BACKGROUND_COLOR_META_DATA).add(BORDER_INSETS_META_DATA).add(BORDER_RADIUS_META_DATA).add(BORDER_WIDTH_META_DATA).add(BACKGROUND_RADIUS_META_DATA).build();
    private DoubleProperty animateExtraSpace = new SimpleDoubleProperty(0.0);
    private final DoubleProperty leftMarginScale = new SimpleDoubleProperty(1.0);
    private final HashSet<Node> frameNodes = new HashSet();

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CanvasVBox.getClassCssMetaData();
    }

    public CanvasVBox(double minWidth, ObservableList<Frame> frames) {
        super(minWidth);
        frames.addListener(change -> {
            this.frameNodes.clear();
            for (Frame f : frames) {
                this.frameNodes.add(f.getNode());
            }
        });
        this.minHeightProperty().bind((ObservableValue)this.cssMinHeightProperty);
        ChangeListener l = (a, b, c) -> {
            Insets insets = this.calculateMargins(Insets.EMPTY);
            this.setPadding(insets);
            this.updateBackground();
            this.updateBorder();
        };
        this.leftMarginProperty.addListener(l);
        this.leftMarginScale.addListener(l);
        this.rightMarginProperty.addListener(l);
        this.topMarginProperty.addListener(l);
        this.bottomMarginProperty.addListener(l);
        this.animateExtraSpace.addListener(l);
        ChangeListener border = (a, b, c) -> this.updateBorder();
        this.borderWidthProperty.addListener(border);
        this.borderColorProperty.addListener(border);
        this.borderRadiusProperty.addListener(border);
        this.borderInsetsProperty.addListener(border);
        ChangeListener bk = (a, b, c) -> this.updateBackground();
        this.backgroundColorProperty.addListener(bk);
        this.backgroundRadiusProperty.addListener(bk);
    }

    public SimpleStyleableDoubleProperty cssMinHeightProperty() {
        return this.cssMinHeightProperty;
    }

    private void updateBackground() {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.backgroundColorProperty.get(), CanvasVBox.makeCornerRadii((Insets)this.backgroundRadiusProperty.get()), this.calculateMargins((Insets)this.backgroundInsetsProperty.get()))}));
    }

    private static CornerRadii makeCornerRadii(Insets xs) {
        if (xs == null) {
            return CornerRadii.EMPTY;
        }
        return new CornerRadii(xs.getTop(), xs.getRight(), xs.getBottom(), xs.getLeft(), false);
    }

    private static BorderWidths makeBorderWidths(Insets xs) {
        if (xs == null) {
            return BorderWidths.EMPTY;
        }
        return new BorderWidths(xs.getTop(), xs.getRight(), xs.getBottom(), xs.getLeft());
    }

    private void updateBorder() {
        BorderStrokeStyle style = new BorderStrokeStyle(StrokeType.OUTSIDE, StrokeLineJoin.ROUND, StrokeLineCap.SQUARE, 10.0, 0.0, Collections.emptyList());
        this.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.borderColorProperty.get(), style, CanvasVBox.makeCornerRadii((Insets)this.borderRadiusProperty.get()), CanvasVBox.makeBorderWidths((Insets)this.borderWidthProperty.get()), this.calculateMargins((Insets)this.borderInsetsProperty.get()))}));
    }

    private Insets calculateMargins(Insets including) {
        if (including == null) {
            including = Insets.EMPTY;
        }
        int top = (int)this.topMarginProperty.add((ObservableNumberValue)this.animateExtraSpace.multiply((ObservableNumberValue)this.curlyBracketHeight)).get() + (int)including.getTop();
        int right = (int)this.rightMarginProperty.get() + (int)including.getRight();
        int bottom = (int)this.bottomMarginProperty.add((ObservableNumberValue)this.animateExtraSpace.multiply((ObservableNumberValue)this.curlyBracketHeight)).get() + (int)including.getBottom();
        int left = (int)this.leftMarginProperty.multiply((ObservableNumberValue)this.leftMarginScale).get() + (int)including.getLeft();
        return new Insets((double)top, (double)right, (double)bottom, (double)left);
    }

    public void addSpace(SharedTransition animate) {
        this.animateExtraSpace.bind((ObservableValue)animate.getProgress());
        animate.addOnStopped(() -> ((DoubleProperty)this.animateExtraSpace).unbind());
    }

    public void removeSpace(SharedTransition animate) {
        this.animateExtraSpace.bind((ObservableValue)animate.getProgress().negate().add(1.0));
        animate.addOnStopped(() -> ((DoubleProperty)this.animateExtraSpace).unbind());
    }

    public double getBottomMargin() {
        return (int)this.bottomMarginProperty.get();
    }

    public DoubleBinding leftMarginProperty() {
        return new DoubleBinding(){
            {
                super.bind(new Observable[]{CanvasVBox.this.leftMarginScale});
            }

            protected double computeValue() {
                return (int)(CanvasVBox.this.leftMarginProperty.get() * CanvasVBox.this.leftMarginScale.get());
            }
        };
    }

    public DoubleBinding rightMarginProperty() {
        return new DoubleBinding(){

            protected double computeValue() {
                return (int)CanvasVBox.this.rightMarginProperty.get();
            }
        };
    }

    @Override
    public double getTopMarginFor(Node n) {
        if (this.frameNodes.contains(n)) {
            return this.frameMarginTopProperty.get();
        }
        return super.getTopMarginFor(n);
    }

    @Override
    public double getBottomMarginFor(Node n) {
        if (this.frameNodes.contains(n)) {
            return this.frameMarginBottomProperty.get();
        }
        return super.getBottomMarginFor(n);
    }

    public Bounds getContentSceneBounds() {
        Bounds b = this.localToScene(this.getBoundsInLocal());
        return new BoundingBox(b.getMinX() + this.leftMarginProperty.get(), b.getMinY() + this.topMarginProperty.get(), b.getWidth() - this.leftMarginProperty.get() - this.rightMarginProperty.get(), b.getHeight() - this.topMarginProperty.get() - this.bottomMarginProperty.get());
    }

    public void animateColorsToPseudoClass(String pseudo, boolean on, SharedTransition animation) {
        Color startBackground = (Color)this.backgroundColorProperty.get();
        Color startBorder = (Color)this.borderColorProperty.get();
        JavaFXUtil.setPseudoclass(pseudo, on, new Node[]{this});
        this.applyCss();
        Color endBackground = (Color)this.backgroundColorProperty.get();
        Color endBorder = (Color)this.borderColorProperty.get();
        if (!startBackground.equals((Object)endBackground) || !startBorder.equals((Object)endBorder)) {
            JavaFXUtil.addChangeListener(animation.getProgress(), t -> {
                Color background = startBackground.interpolate(endBackground, t.doubleValue());
                Color border = startBorder.interpolate(endBorder, t.doubleValue());
                this.backgroundColorProperty.set((Object)background);
                this.borderColorProperty.set((Object)border);
                this.updateBackground();
                this.updateBorder();
            });
        }
    }

    public DoubleProperty leftMarginScaleProperty() {
        return this.leftMarginScale;
    }

    public double getCurlyBracketHeight() {
        return this.curlyBracketHeight.get();
    }
}

