/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.InfixStructured;
import bluej.stride.framedjava.slots.PosAndDist;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.framedjava.slots.StructuredSlotComponent;
import bluej.stride.framedjava.slots.StructuredSlotField;
import bluej.stride.framedjava.slots.TextOverlayPosition;
import bluej.stride.generic.Frame;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.ScreenreaderDictionary;
import bluej.utility.Utility;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.ConcatListBinding;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import threadchecker.OnThread;
import threadchecker.Tag;

class BracketedStructured<INFIX extends InfixStructured<SLOT, INFIX>, SLOT extends StructuredSlot<?, INFIX, ?>>
implements StructuredSlotComponent {
    private final INFIX parent;
    private final INFIX content;
    private final ObservableList<Node> components = FXCollections.observableArrayList();
    private final char opening;
    private final char closing;
    private final Label openingLabel;
    private final Label closingLabel;

    public BracketedStructured(InteractionManager editor, INFIX parent, SLOT slot, char opening, String initialContent, StructuredSlot.ModificationToken token) {
        this.parent = parent;
        this.opening = opening;
        switch (opening) {
            case '(': {
                this.closing = (char)41;
                break;
            }
            case '[': {
                this.closing = (char)93;
                break;
            }
            case '{': {
                this.closing = (char)125;
                break;
            }
            case '<': {
                this.closing = (char)62;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised bracket: " + opening);
            }
        }
        this.content = ((InfixStructured)parent).newInfix(editor, slot, initialContent, this, token, Character.valueOf(this.closing));
        this.openingLabel = StructuredSlot.makeBracket("" + opening, true, this.content);
        this.closingLabel = StructuredSlot.makeBracket("" + this.closing, false, this.content);
        HangingFlowPane.setBreakBefore((Node)this.closingLabel, false);
        ConcatListBinding.bind(this.components, FXCollections.observableArrayList((Object[])new ObservableList[]{FXCollections.observableArrayList((Object[])new Label[]{this.openingLabel}), ((InfixStructured)this.content).getComponents(), FXCollections.observableArrayList((Object[])new Label[]{this.closingLabel})}));
    }

    @Override
    public String getText() {
        return this.opening + ((InfixStructured)this.content).getCopyText(null, null) + this.closing;
    }

    @Override
    public void focusAtStart() {
        ((InfixStructured)this.content).focusAtStart();
    }

    @Override
    public void focusAtEnd() {
        ((InfixStructured)this.content).focusAtEnd();
    }

    @Override
    public Node focusAtPos(CaretPos caretPos) {
        return ((InfixStructured)this.content).positionCaret(caretPos);
    }

    @Override
    public TextOverlayPosition calculateOverlayPos(CaretPos subPos) {
        return ((InfixStructured)this.content).calculateOverlayPos(subPos);
    }

    @Override
    public PosAndDist getNearest(double sceneX, double sceneY, boolean allowDescend, boolean anchorInItem) {
        if (allowDescend) {
            return ((InfixStructured)this.content).getNearest(sceneX, sceneY, true, OptionalInt.empty());
        }
        return new PosAndDist();
    }

    @Override
    public CaretPos getSelectIntoPos(boolean atEnd) {
        return null;
    }

    @Override
    public CaretPos getStartPos() {
        return ((InfixStructured)this.content).getStartPos();
    }

    @Override
    public CaretPos getEndPos() {
        return ((InfixStructured)this.content).getEndPos();
    }

    @Override
    public String getCopyText(CaretPos from, CaretPos to) {
        StringBuilder b = new StringBuilder();
        if (from == null) {
            b.append(this.opening);
        }
        b.append(((InfixStructured)this.content).getCopyText(from, to));
        if (to == null) {
            b.append(this.closing);
        }
        return b.toString();
    }

    @Override
    public String getScreenreaderText() {
        return ScreenreaderDictionary.transcribeForScreenreader(String.valueOf(this.opening)) + ((InfixStructured)this.content).getScreenreaderText() + ScreenreaderDictionary.transcribeForScreenreader(String.valueOf(this.closing));
    }

    @Override
    public String getJavaCode() {
        StringBuilder b = new StringBuilder();
        b.append(this.opening);
        b.append(((InfixStructured)this.content).getJavaCode());
        b.append(this.closing);
        return b.toString();
    }

    @Override
    public CaretPos getCurrentPos() {
        return ((InfixStructured)this.content).getCurrentPos();
    }

    public ObservableList<Node> getComponents() {
        return this.components;
    }

    @Override
    public List<InfixStructured.CaretPosMap> mapCaretPosStringPos(InfixStructured.IntCounter len, boolean javaString) {
        ++len.counter;
        List<InfixStructured.CaretPosMap> r = ((InfixStructured)this.content).mapCaretPosStringPos(len, javaString);
        ++len.counter;
        return r;
    }

    @Override
    public Region getNodeForPos(CaretPos pos) {
        return ((InfixStructured)this.content).getNodeForPos(pos);
    }

    INFIX getContent() {
        return this.content;
    }

    @OnThread(value=Tag.FXPlatform)
    public void insertAfter(String text) {
        ((InfixStructured)this.parent).insertNext(this, text);
    }

    @Override
    public String testingGetState(CaretPos pos) {
        return this.opening + ((InfixStructured)this.content).testingGetState(pos) + this.closing;
    }

    public INFIX testingContent() {
        return this.content;
    }

    @OnThread(value=Tag.FXPlatform)
    public CaretPos flatten(boolean atEnd, StructuredSlot.ModificationToken token) {
        return ((InfixStructured)this.parent).flattenCompound(this, atEnd, token);
    }

    @Override
    public boolean isFocused() {
        return ((InfixStructured)this.content).isFocused();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void insertSuggestion(CaretPos p, String name, char opening, List<String> params, StructuredSlot.ModificationToken token) {
        ((InfixStructured)this.content).insertSuggestion(p, name, opening, params, token);
    }

    CaretPos absolutePos(CaretPos p) {
        return ((InfixStructured)this.parent).absolutePos(this, p);
    }

    char getOpening() {
        return this.opening;
    }

    public void focusBefore() {
        ((InfixStructured)this.parent).backwardAtStart(this);
    }

    public void focusAfter() {
        ((InfixStructured)this.parent).forwardAtEnd(this);
    }

    @Override
    public Stream<TextOverlayPosition> getAllStartEndPositionsBetween(CaretPos start, CaretPos end) {
        return ((InfixStructured)this.content).getAllStartEndPositionsBetween(start, end);
    }

    @Override
    public Stream<InfixStructured<?, ?>> getAllExpressions() {
        return ((InfixStructured)this.content).getAllExpressions();
    }

    void highlightBrackets(boolean on) {
        JavaFXUtil.setPseudoclass("bj-bracket-highlight", on, new Node[]{this.openingLabel, this.closingLabel});
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animate) {
        ((InfixStructured)this.content).setView(oldView, newView, animate, Optional.empty());
        JavaFXUtil.setPseudoclass("bj-java-preview", newView == Frame.View.JAVA_PREVIEW, new Node[]{this.openingLabel, this.closingLabel});
    }

    @Override
    public boolean isAlmostBlank() {
        return ((InfixStructured)this.content).isAlmostBlank();
    }

    @Override
    public void notifyLostFocus(StructuredSlotField except) {
        ((InfixStructured)this.content).notifyLostFocus(except);
    }

    Node positionParentPos(CaretPos pos) {
        return ((InfixStructured)this.parent).positionCaret(pos);
    }

    boolean isInSelection() {
        return this.parent != null && ((InfixStructured)this.parent).isInSelection();
    }

    @Override
    public void setEditable(boolean editable) {
        ((InfixStructured)this.content).setEditable(editable);
    }

    @Override
    public boolean isNumericLiteral() {
        return ((InfixStructured)this.content).isNumericLiteral();
    }

    void notifyIsMethodParams(boolean isMethodParams) {
        HangingFlowPane.setBreakBefore((Node)this.openingLabel, !isMethodParams);
    }

    @Override
    public int calculateEffort() {
        return ((InfixStructured)this.content).calculateEffort();
    }

    INFIX getParent() {
        return this.parent;
    }

    @Override
    public Stream<Node> makeDisplayClone(InteractionManager editor) {
        return Utility.concat(Stream.of(JavaFXUtil.cloneLabel(this.openingLabel, (ObservableValue<String>)editor.getFontCSS())), ((InfixStructured)this.content).makeDisplayClone(editor), Stream.of(JavaFXUtil.cloneLabel(this.closingLabel, (ObservableValue<String>)editor.getFontCSS())));
    }
}

