/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.canvases;

import bluej.stride.framedjava.ast.HighlightedBreakpoint;
import bluej.stride.framedjava.frames.BreakpointFrame;
import bluej.stride.framedjava.frames.DebugInfo;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleCanvasFrame;
import bluej.utility.javafx.JavaFXUtil;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class JavaCanvas
extends FrameCanvas {
    private boolean methodCanvas;

    public JavaCanvas(InteractionManager editor, CanvasParent parent, String stylePrefix, boolean methodCanvas) {
        super(editor, parent, stylePrefix);
        this.methodCanvas = methodCanvas;
    }

    @OnThread(value=Tag.FXPlatform)
    public HighlightedBreakpoint showDebugBefore(Frame f, DebugInfo info) {
        VBox special;
        DebugInfo.Display disp;
        if (f != null) {
            JavaFXUtil.setPseudoclass("bj-debug-before", true, f.getNode());
            disp = info.getInfoDisplay(f.getCursorBefore(), f.getNode(), f.getStylePrefix(), f instanceof BreakpointFrame);
            special = this.getSpecialBefore(f.getCursorBefore());
        } else {
            disp = info.getInfoDisplay(this.getLastCursor(), null, null, false);
            special = this.getSpecialAfter(null);
        }
        if (!special.getChildren().contains((Object)disp)) {
            special.getChildren().add((Object)disp);
        }
        this.editorFrm.ensureNodeVisible((Node)special);
        return disp;
    }

    private void removeSpecialsAfter(DebugInfo info, FrameCursor fc) {
        while (fc != null) {
            VBox special = this.getSpecialAfter(fc);
            info.removeAllDisplays((List<Node>)special.getChildren());
            special.getChildren().clear();
            Frame f = this.getFrameAfter(fc);
            if (f instanceof SingleCanvasFrame) {
                SingleCanvasFrame scf = (SingleCanvasFrame)f;
                ((JavaCanvas)scf.getCanvas()).removeSpecialsAfter(info, scf.getFirstInternalCursor());
            }
            fc = this.getNextCursor(fc, false);
        }
    }
}

