/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.parser.CompletionParser;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ReparseableDocument;
import java.io.Reader;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExpressionNode
extends JavaParentNode {
    public ExpressionNode(JavaParentNode parent) {
        super(parent);
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    protected boolean marksOwnEnd() {
        return false;
    }

    @Override
    protected ExpressionTypeInfo getExpressionType(int pos, int nodePos, JavaEntity defaultType, ReparseableDocument document, ExpressionNode largestPlainExpressionNode) {
        NodeTree.NodeAndPosition<ParsedNode> nap;
        this.valueEntityCache.clear();
        this.pocEntityCache.clear();
        if (largestPlainExpressionNode == null) {
            largestPlainExpressionNode = this;
        }
        if ((nap = this.findNodeAt(pos, nodePos)) != null && nap.getNode().getNodeType() != 7) {
            return nap.getNode().getExpressionType(pos, nap.getPosition(), defaultType, document, largestPlainExpressionNode);
        }
        return ExpressionNode.suggestAsExpression(pos, nodePos, largestPlainExpressionNode, defaultType, document);
    }

    @OnThread(value=Tag.FXPlatform)
    public static ExpressionTypeInfo suggestAsExpression(int pos, int nodePos, EntityResolver resolver, JavaEntity defaultType, ReparseableDocument document) {
        GenTypeClass atype;
        Reader r = document.makeReader(nodePos, pos);
        ReparseableDocument.Element map = document.getDefaultRootElement();
        int line = map.getElementIndex(nodePos) + 1;
        int col = nodePos - map.getElement(line - 1).getStartOffset() + 1;
        CompletionParser parser = new CompletionParser(resolver, r, defaultType, line, col, nodePos);
        parser.parseExpression();
        GenTypeSolid stype = parser.getSuggestionType();
        GenTypeClass genTypeClass = atype = defaultType != null ? defaultType.getType().asClass() : null;
        if (stype != null) {
            return new ExpressionTypeInfo(stype, atype, parser.getSuggestionToken(), parser.isSuggestionStatic(), parser.isPlain());
        }
        return null;
    }
}

