/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.lexer;

import bluej.parser.lexer.LineColPos;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class LocatableToken {
    private final LineColPos begin;
    private final LineColPos end;
    private LocatableToken hiddenBefore;
    private final int type;
    private final String text;

    public LocatableToken(int t, String txt, LineColPos begin, LineColPos end) {
        this.type = t;
        this.text = txt;
        this.begin = begin;
        this.end = end;
    }

    public int getEndColumn() {
        return this.end.column();
    }

    public int getEndLine() {
        return this.end.line();
    }

    public int getLine() {
        return this.begin.line();
    }

    public LocatableToken adjustStart(int offset) {
        return new LocatableToken(this.type, this.text, this.begin.offsetSameLineBy(offset), this.end.offsetSameLineBy(offset));
    }

    public int getColumn() {
        return this.begin.column();
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public int getLength() {
        return this.end.position() - this.begin.position();
    }

    public int getPosition() {
        return this.begin.position();
    }

    public int getEndPosition() {
        return this.end.position();
    }

    public void setHiddenBefore(LocatableToken t) {
        this.hiddenBefore = t;
    }

    public LocatableToken getHiddenBefore() {
        return this.hiddenBefore;
    }

    public String toString() {
        return "LocatableToken{begin=" + this.begin + ", end=" + this.end + ", hiddenBefore=" + this.hiddenBefore + ", type=" + this.type + ", text='" + this.text + "'}";
    }
}

