/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.GenTypeSolid;
import bluej.parser.TextParser;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.lexer.LocatableToken;
import java.io.Reader;

public class CompletionParser
extends TextParser {
    private JavaEntity suggestionEntity;
    private LocatableToken suggestionToken;
    private boolean staticRestricted = false;
    private boolean plain = true;

    public CompletionParser(EntityResolver resolver, Reader reader, JavaEntity defaultEnt) {
        super(resolver, reader, defaultEnt, false);
        this.suggestionEntity = defaultEnt;
    }

    public CompletionParser(EntityResolver resolver, Reader reader, JavaEntity defaultEnt, int line, int col, int pos) {
        super(resolver, reader, defaultEnt, false, line, col, pos);
        this.suggestionEntity = defaultEnt;
    }

    @Override
    protected void error(String msg, int beginLine, int beginCol, int endLine, int endCol) {
    }

    public GenTypeSolid getSuggestionType() {
        if (this.suggestionEntity != null) {
            JavaEntity valEnt = this.suggestionEntity.resolveAsValue();
            if (valEnt != null) {
                return valEnt.getType().asSolid();
            }
            valEnt = this.suggestionEntity.resolveAsType();
            if (valEnt != null) {
                this.setStatic(true);
                return valEnt.getType().asSolid();
            }
        }
        return null;
    }

    public LocatableToken getSuggestionToken() {
        return this.suggestionToken;
    }

    @Override
    protected void gotDotEOF(LocatableToken token) {
        this.suggestionEntity = this.popValueStack();
        this.plain = false;
    }

    @Override
    protected void gotIdentifierEOF(LocatableToken token) {
        this.suggestionToken = token;
    }

    @Override
    protected void gotMemberAccessEOF(LocatableToken token) {
        this.suggestionToken = token;
        this.suggestionEntity = this.popValueStack();
        this.plain = false;
    }

    @Override
    protected void completeCompoundValueEOF(LocatableToken token) {
        this.suggestionToken = token;
        this.suggestionEntity = this.popValueStack();
        this.plain = false;
    }

    public boolean isSuggestionStatic() {
        return this.staticRestricted;
    }

    protected void setStatic(boolean restricted) {
        this.staticRestricted = restricted;
    }

    public boolean isPlain() {
        return this.plain;
    }
}

