/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.CommitAction;
import bluej.groupwork.actions.PushAction;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.TeamStatusInfoCell;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.Utility;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.NoMultipleSelectionModel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CommitAndPushFrame
extends FXCustomizedDialog<Void> {
    private final Project project;
    private Repository repository;
    private Set<TeamStatusInfo> changedLayoutFiles = new HashSet<TeamStatusInfo>();
    private ObservableList<TeamStatusInfo> commitListModel = FXCollections.observableArrayList();
    private ObservableList<TeamStatusInfo> pushListModel = FXCollections.observableArrayList();
    private final CheckBox includeLayout = new CheckBox(Config.getString("team.commit.includelayout"));
    private final TextArea commitText = new TextArea();
    private final ActivityIndicator progressBar = new ActivityIndicator();
    private final ListView<TeamStatusInfo> pushFiles = new ListView(this.pushListModel);
    private CommitAction commitAction;
    private PushAction pushAction;
    private CommitAndPushWorker commitAndPushWorker;
    private boolean pushNeeded = false;
    private boolean updateNeeded = false;

    public CommitAndPushFrame(Project proj) {
        super(null, "team.commit.dcvs.title", "team-commit-push");
        this.project = proj;
        this.repository = this.project.getTeamSettingsController().trytoEstablishRepository(false);
        this.getDialogPane().setContent((Node)this.makeMainPane());
        this.prepareButtonPane();
    }

    private Pane makeMainPane() {
        ListView commitFiles = new ListView(this.commitListModel);
        commitFiles.setPlaceholder((Node)new Label(Config.getString("team.nocommitfiles")));
        commitFiles.setCellFactory(param -> new TeamStatusInfoCell(this.project));
        commitFiles.setSelectionModel(new NoMultipleSelectionModel());
        commitFiles.disableProperty().bind((ObservableValue)Bindings.isEmpty(this.commitListModel));
        ScrollPane commitFileScrollPane = new ScrollPane((Node)commitFiles);
        commitFileScrollPane.setFitToWidth(true);
        commitFileScrollPane.setFitToHeight(true);
        VBox.setMargin((Node)commitFileScrollPane, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
        this.commitText.setPrefRowCount(20);
        this.commitText.setPrefColumnCount(35);
        this.commitText.setPromptText(Config.getString("team.commit.message"));
        VBox.setMargin((Node)this.commitText, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        this.commitAction = new CommitAction(this);
        Button commitButton = new Button();
        this.commitAction.useButton(this.project, (ButtonBase)commitButton);
        commitButton.requestFocus();
        this.commitText.disableProperty().bind((ObservableValue)Bindings.isEmpty(this.commitListModel));
        this.commitAction.disabledProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)this.commitText.disabledProperty(), (ObservableBooleanValue)this.commitText.textProperty().isEmpty()));
        this.includeLayout.setOnAction(event -> {
            CheckBox layoutCheck = (CheckBox)event.getSource();
            if (layoutCheck.isSelected()) {
                this.addModifiedLayouts();
            } else {
                this.removeModifiedLayouts();
            }
        });
        this.includeLayout.setDisable(true);
        HBox commitButtonPane = new HBox();
        JavaFXUtil.addStyleClass((Styleable)commitButtonPane, "button-hbox");
        commitButtonPane.setAlignment(Pos.CENTER_RIGHT);
        commitButtonPane.getChildren().addAll((Object[])new Node[]{this.includeLayout, commitButton});
        this.pushAction = new PushAction(this);
        Button pushButton = new Button();
        this.pushAction.useButton(this.project, (ButtonBase)pushButton);
        Label pushFilesLabel = new Label(Config.getString("team.commitPush.push.files"));
        this.pushFiles.setCellFactory(param -> new TeamStatusInfoCell(this.project));
        this.pushFiles.setSelectionModel(new NoMultipleSelectionModel());
        this.pushFiles.disableProperty().bind((ObservableValue)Bindings.isEmpty(this.pushListModel));
        ScrollPane pushFileScrollPane = new ScrollPane(this.pushFiles);
        pushFileScrollPane.setFitToWidth(true);
        pushFileScrollPane.setFitToHeight(true);
        HBox pushButtonPane = new HBox();
        this.progressBar.setRunning(false);
        JavaFXUtil.addStyleClass((Styleable)pushButtonPane, "button-hbox");
        pushButtonPane.setAlignment(Pos.CENTER_RIGHT);
        pushButtonPane.getChildren().addAll((Object[])new Node[]{this.progressBar, pushButton});
        VBox mainPane = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPane, "main-pane");
        mainPane.getChildren().addAll((Object[])new Node[]{new Label(Config.getString("team.commitPush.commit.files")), commitFileScrollPane, new Label(Config.getString("team.commit.comment")), this.commitText, commitButtonPane, new Separator(Orientation.HORIZONTAL), pushFilesLabel, pushFileScrollPane, pushButtonPane});
        return mainPane;
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.setOnCloseRequest(event -> {
            if (this.commitAndPushWorker != null) {
                this.commitAndPushWorker.abort();
            }
            if (this.commitAction != null) {
                this.commitAction.cancel();
            }
            this.close();
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public void setVisible() {
        this.commitText.setText("");
        this.includeLayout.setSelected(false);
        this.includeLayout.setDisable(true);
        this.changedLayoutFiles.clear();
        this.commitListModel.clear();
        this.pushAction.setEnabled(false);
        this.pushListModel.clear();
        this.repository = this.project.getTeamSettingsController().trytoEstablishRepository(false);
        if (this.repository != null) {
            block5: {
                try {
                    this.project.saveAllEditors();
                    this.project.saveAll();
                }
                catch (IOException ioe) {
                    String msg = DialogManager.getMessage("team-error-saving-project", new String[0]);
                    if (msg == null) break block5;
                    String msgFinal = msg = Utility.mergeStrings(msg, ioe.getLocalizedMessage());
                    DialogManager.showErrorTextFX(this.asWindow(), msgFinal);
                }
            }
            this.startProgress();
            this.commitAndPushWorker = new CommitAndPushWorker();
            this.commitAndPushWorker.start();
            if (!this.isShowing()) {
                this.show();
            }
        } else {
            this.hide();
        }
    }

    public void setComment(String newComment) {
        this.commitText.setText(newComment);
    }

    public void reset() {
        this.commitListModel.clear();
        this.pushListModel.clear();
        this.setComment("");
        this.progressBar.setMessage("");
    }

    private void removeModifiedLayouts() {
        this.commitListModel.removeAll(this.changedLayoutFiles);
    }

    public String getComment() {
        return this.commitText.getText();
    }

    public Set<File> getChangedLayoutFiles() {
        return this.changedLayoutFiles.stream().map(info -> info.getFile()).collect(Collectors.toSet());
    }

    public Set<TeamStatusInfo> getChangedLayoutInfo() {
        return this.changedLayoutFiles;
    }

    public boolean includeLayout() {
        return this.includeLayout != null && this.includeLayout.isSelected();
    }

    private void addModifiedLayouts() {
        HashSet<File> displayedLayouts = new HashSet<File>();
        for (TeamStatusInfo info : this.changedLayoutFiles) {
            File parentFile = info.getFile().getParentFile();
            if (displayedLayouts.contains(parentFile)) continue;
            this.commitListModel.add((Object)info);
            displayedLayouts.add(info.getFile().getParentFile());
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void startProgress() {
        this.progressBar.setRunning(true);
    }

    @OnThread(value=Tag.Any)
    public void stopProgress() {
        JavaFXUtil.runNowOrLater(() -> this.progressBar.setRunning(false));
    }

    @OnThread(value=Tag.FXPlatform)
    public Project getProject() {
        return this.project;
    }

    @OnThread(value=Tag.FXPlatform)
    public void displayMessage(String msg) {
        this.progressBar.setMessage(msg);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public Window asWindow() {
        Scene scene = this.getDialogPane().getScene();
        if (scene == null) {
            return null;
        }
        return scene.getWindow();
    }

    public List<File> getFilesToPush() {
        return Utility.mapList(this.pushListModel, s -> s.getFile());
    }

    class CommitAndPushWorker
    extends FXWorker
    implements StatusListener {
        List<TeamStatusInfo> response = new ArrayList<TeamStatusInfo>();
        TeamworkCommand command;
        TeamworkCommandResult result;
        private boolean aborted;
        private boolean isPushAvailable;

        public CommitAndPushWorker() {
            FileFilter filter = CommitAndPushFrame.this.project.getTeamSettingsController().getFileFilter(false);
            this.command = CommitAndPushFrame.this.repository.getStatus(this, filter, false);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.response.add(info);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public void statusComplete(StatusHandle statusHandle) {
            CommitAndPushFrame.this.commitAction.setStatusHandle(statusHandle);
            CommitAndPushFrame.this.pushNeeded = statusHandle.pushNeeded();
            CommitAndPushFrame.this.updateNeeded = statusHandle.pullNeeded();
            CommitAndPushFrame.this.pushAction.setStatusHandle(statusHandle);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.result = this.command.getResult();
            return this.response;
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            CommitAndPushFrame.this.stopProgress();
            if (!this.aborted) {
                if (this.result.isError()) {
                    TeamUtils.handleServerResponseFX(this.result, CommitAndPushFrame.this.asWindow());
                    CommitAndPushFrame.this.hide();
                } else if (this.response != null) {
                    HashSet<File> filesToCommit = new HashSet<File>();
                    LinkedHashSet<File> filesToAdd = new LinkedHashSet<File>();
                    HashSet<File> filesToDelete = new HashSet<File>();
                    List<TeamStatusInfo> info = this.response;
                    this.getCommitFileSets(info, filesToCommit, filesToAdd, filesToDelete, CommitAndPushFrame.this.changedLayoutFiles);
                    CommitAndPushFrame.this.includeLayout.setDisable(CommitAndPushFrame.this.changedLayoutFiles.isEmpty());
                    CommitAndPushFrame.this.commitAction.setFiles(filesToCommit);
                    CommitAndPushFrame.this.commitAction.setNewFiles(filesToAdd);
                    CommitAndPushFrame.this.commitAction.setDeletedFiles(filesToDelete);
                    this.updateListModel(CommitAndPushFrame.this.commitListModel, filesToCommit, info);
                    this.updateListModel(CommitAndPushFrame.this.commitListModel, filesToAdd, info);
                    this.updateListModel(CommitAndPushFrame.this.commitListModel, filesToDelete, info);
                    if (CommitAndPushFrame.this.updateNeeded) {
                        CommitAndPushFrame.this.pushListModel.clear();
                        this.isPushAvailable = false;
                    } else {
                        HashSet<File> filesToPush = new HashSet<File>();
                        this.getPushFileSets(info, filesToPush);
                        this.updateListModel(CommitAndPushFrame.this.pushListModel, filesToPush, info);
                        this.isPushAvailable = CommitAndPushFrame.this.pushNeeded;
                    }
                    CommitAndPushFrame.this.pushAction.setEnabled(this.isPushAvailable);
                }
                if (!CommitAndPushFrame.this.commitListModel.isEmpty()) {
                    CommitAndPushFrame.this.commitText.requestFocus();
                }
                if (CommitAndPushFrame.this.pushListModel.isEmpty()) {
                    if (this.isPushAvailable) {
                        CommitAndPushFrame.this.pushFiles.setPlaceholder((Node)new Label(Config.getString("team.pushNeeded")));
                    } else if (CommitAndPushFrame.this.updateNeeded) {
                        CommitAndPushFrame.this.pushFiles.setPlaceholder((Node)new Label(Config.getString("team.pullNeeded")));
                    } else {
                        CommitAndPushFrame.this.pushFiles.setPlaceholder((Node)new Label(Config.getString("team.nopushfiles")));
                    }
                }
            }
        }

        private void getCommitFileSets(List<TeamStatusInfo> info, Set<File> filesToCommit, Set<File> filesToAdd, Set<File> filesToRemove, Set<TeamStatusInfo> modifiedLayoutFiles) {
            for (TeamStatusInfo statusInfo : info) {
                File file = statusInfo.getFile();
                boolean isPkgFile = BlueJPackageFile.isPackageFileName(file.getName());
                TeamStatusInfo.Status status = statusInfo.getStatus(true);
                if (status == TeamStatusInfo.Status.NEEDS_ADD || status == TeamStatusInfo.Status.CONFLICT_ADD) {
                    filesToAdd.add(file);
                    filesToCommit.add(file);
                    statusInfo.setStatus(TeamStatusInfo.Status.NEEDS_ADD);
                    continue;
                }
                if (status == TeamStatusInfo.Status.DELETED) {
                    filesToRemove.add(file);
                    filesToCommit.add(file);
                    continue;
                }
                if (status == TeamStatusInfo.Status.CONFLICT_LDRM) {
                    filesToCommit.add(file);
                    continue;
                }
                if (status == TeamStatusInfo.Status.CONFLICT_LMRD) {
                    if (file.exists()) {
                        statusInfo.setStatus(TeamStatusInfo.Status.NEEDS_MERGE);
                        filesToCommit.add(file);
                        continue;
                    }
                    statusInfo.setStatus(TeamStatusInfo.Status.DELETED);
                    filesToRemove.add(file);
                    filesToCommit.add(file);
                    continue;
                }
                if (status == TeamStatusInfo.Status.HAS_CONFLICTS) continue;
                if (status == TeamStatusInfo.Status.NEEDS_MERGE) {
                    filesToAdd.add(file);
                    filesToCommit.add(file);
                    continue;
                }
                if (status == TeamStatusInfo.Status.NEEDS_COMMIT) {
                    if (isPkgFile) {
                        modifiedLayoutFiles.add(statusInfo);
                        continue;
                    }
                    filesToCommit.add(file);
                    continue;
                }
                if (status == TeamStatusInfo.Status.UP_TO_DATE) continue;
                Debug.message("Commit and push: unhandled file status: " + status + " (for " + file + ")");
            }
            CommitAndPushFrame.this.includeLayout.setDisable(CommitAndPushFrame.this.changedLayoutFiles.isEmpty());
        }

        private void getPushFileSets(List<TeamStatusInfo> info, Set<File> filesToPush) {
            for (TeamStatusInfo statusInfo : info) {
                File file = statusInfo.getFile();
                TeamStatusInfo.Status status = statusInfo.getStatus(false);
                if (status == TeamStatusInfo.Status.UP_TO_DATE || status == TeamStatusInfo.Status.NEEDS_CHECKOUT || status == TeamStatusInfo.Status.NEEDS_UPDATE) continue;
                filesToPush.add(file);
            }
        }

        private void updateListModel(ObservableList<TeamStatusInfo> listModel, Set<File> fileSet, List<TeamStatusInfo> info) {
            listModel.addAll((Collection)fileSet.stream().map(file -> this.getTeamStatusInfoFromFile((File)file, info)).filter(Objects::nonNull).filter(statusInfo -> !listModel.contains(statusInfo)).collect(Collectors.toList()));
        }

        private TeamStatusInfo getTeamStatusInfoFromFile(File file, List<TeamStatusInfo> infoList) {
            Optional<TeamStatusInfo> statusInfo = infoList.stream().filter(info -> info.getFile().equals(file)).findFirst();
            return statusInfo.isPresent() ? statusInfo.get() : null;
        }
    }
}

