/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.Config;
import bluej.extmgr.ExtensionWrapper;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import java.util.Arrays;
import java.util.List;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExtensionPrefManager
implements PrefPanelListener {
    private List<ExtensionWrapper> extensionsList;
    private final int DO_panelUpdate = 1;
    private final int DO_loadValues = 2;
    private final int DO_saveValues = 3;
    private VBox drawVBox;
    private ScrollPane drawScrollPane;

    public ExtensionPrefManager(List<ExtensionWrapper> i_extensionsList) {
        this.extensionsList = i_extensionsList;
        this.drawVBox = new VBox();
        JavaFXUtil.addStyleClass((Styleable)this.drawVBox, "prefmgr-ext-innerpanel");
        this.drawScrollPane = new ScrollPane((Node)this.drawVBox);
        JavaFXUtil.addStyleClass((Styleable)this.drawScrollPane, "prefmgr-pref-panel");
    }

    public Node getExtensionContent() {
        if (this.drawVBox.getChildren().size() == 0) {
            this.drawVBox.getChildren().add((Object)new Text(Config.getString("prefmgr.extensions.noContent")));
        }
        return this.drawScrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWorkLoop(int doAction) {
        if (doAction == 1) {
            this.drawVBox.getChildren().clear();
        }
        List<ExtensionWrapper> list = this.extensionsList;
        synchronized (list) {
            for (ExtensionWrapper wrapper : this.extensionsList) {
                this.doWorkItem(wrapper, doAction);
            }
        }
    }

    private void doWorkItem(ExtensionWrapper aWrapper, int doAction) {
        if (!aWrapper.isValid()) {
            return;
        }
        String extensionName = aWrapper.safeGetExtensionName();
        switch (doAction) {
            case 2: {
                aWrapper.safePrefGenLoadValues();
                return;
            }
            case 3: {
                aWrapper.safePrefGenSaveValues();
                return;
            }
            case 1: {
                this.addUserPane(aWrapper, extensionName);
                return;
            }
        }
    }

    private void addUserPane(ExtensionWrapper aWrapper, String extensionName) {
        Pane userPane = aWrapper.safePrefGenGetWindow();
        if (userPane == null) {
            return;
        }
        this.drawVBox.getChildren().add((Object)PrefMgrDialog.headedVBox(extensionName, Arrays.asList(userPane)));
    }

    @OnThread(value=Tag.FXPlatform)
    public void panelRevalidate() {
        this.doWorkLoop(1);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void beginEditing(Project project) {
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void revertEditing(Project project) {
        this.doWorkLoop(2);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void commitEditing(Project project) {
        this.doWorkLoop(3);
    }
}

