/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2.event;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions2.BPackage;
import bluej.extensions2.ExtensionBridge;
import bluej.extensions2.event.ExtensionEvent;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class InvocationFinishedEvent
implements ExtensionEvent {
    private String className;
    private String objectName;
    private String methodName;
    private JavaType[] signature;
    private String[] parameters;
    private EventType terminationType = EventType.UNKNOWN_EXIT;
    private Package bluej_pkg;
    private DebuggerObject resultObj;

    public InvocationFinishedEvent(ExecutionEvent exevent) {
        String resultType;
        switch (resultType = exevent.getResult()) {
            case "Normal exit": {
                this.terminationType = EventType.NORMAL_EXIT;
                break;
            }
            case "An exception occurred": {
                this.terminationType = EventType.EXCEPTION_EXIT;
                break;
            }
            case "User terminated": {
                this.terminationType = EventType.TERMINATED_EXIT;
            }
        }
        this.bluej_pkg = exevent.getPackage();
        this.className = exevent.getClassName();
        this.objectName = exevent.getObjectName();
        this.methodName = exevent.getMethodName();
        this.signature = exevent.getSignature();
        this.parameters = exevent.getParameters();
        this.resultObj = exevent.getResultObject();
    }

    public EventType getEventType() {
        return this.terminationType;
    }

    public BPackage getPackage() {
        return this.bluej_pkg.getBPackage();
    }

    public String getClassName() {
        return this.className;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @OnThread(value=Tag.FXPlatform)
    public Class<?>[] getSignature() {
        if (this.signature == null) {
            return new Class[0];
        }
        Class[] risul = new Class[this.signature.length];
        for (int index = 0; index < this.signature.length; ++index) {
            JavaType sig = this.signature[index];
            if (sig.isPrimitive()) {
                if (sig == JavaPrimitiveType.getBoolean()) {
                    risul[index] = Boolean.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getByte()) {
                    risul[index] = Byte.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getChar()) {
                    risul[index] = Character.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getDouble()) {
                    risul[index] = Double.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getFloat()) {
                    risul[index] = Float.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getInt()) {
                    risul[index] = Integer.TYPE;
                    continue;
                }
                if (sig == JavaPrimitiveType.getLong()) {
                    risul[index] = Long.TYPE;
                    continue;
                }
                if (sig != JavaPrimitiveType.getShort()) continue;
                risul[index] = Short.TYPE;
                continue;
            }
            String className = sig.asClass().classloaderName();
            risul[index] = this.bluej_pkg.getProject().loadClass(className);
        }
        return risul;
    }

    public String[] getParameters() {
        if (this.parameters == null) {
            return new String[0];
        }
        return this.parameters;
    }

    @OnThread(value=Tag.FXPlatform)
    public Object getResult() {
        if (this.resultObj == null) {
            return null;
        }
        if (this.methodName != null) {
            return this.getMethodResult();
        }
        PkgMgrFrame pmf = PkgMgrFrame.findFrame(this.bluej_pkg);
        ObjectWrapper wrapper = ObjectWrapper.getWrapper(pmf, pmf.getObjectBench(), this.resultObj, this.resultObj.getGenType(), this.objectName);
        return ExtensionBridge.newBObject(wrapper);
    }

    @OnThread(value=Tag.FXPlatform)
    private Object getMethodResult() {
        ObjectReference objRef = this.resultObj.getObjectReference();
        ReferenceType type = objRef.referenceType();
        Field thisField = type.fieldByName("result");
        if (thisField == null) {
            return null;
        }
        PkgMgrFrame aFrame = PkgMgrFrame.findFrame(this.bluej_pkg);
        return ExtensionBridge.getVal(aFrame, "", objRef.getValue(thisField));
    }

    public String toString() {
        StringBuffer aRisul = new StringBuffer(500);
        aRisul.append("ResultEvent: ");
        aRisul.append(this.terminationType.toString());
        if (this.className != null) {
            aRisul.append(" BClass=" + this.className);
        }
        if (this.objectName != null) {
            aRisul.append(" objectName=" + this.objectName);
        }
        if (this.methodName != null) {
            aRisul.append(" methodName=" + this.methodName);
        }
        if (this.resultObj != null) {
            Platform.runLater(() -> aRisul.append(" resultObj=" + this.getResult()));
        }
        return aRisul.toString();
    }

    public static enum EventType {
        UNKNOWN_EXIT,
        NORMAL_EXIT,
        EXCEPTION_EXIT,
        TERMINATED_EXIT;

    }
}

