/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2.editor;

import bluej.editor.Editor;
import bluej.editor.stride.FrameEditor;
import bluej.extensions2.BClass;
import bluej.extensions2.SourceType;
import bluej.extensions2.editor.JavaEditor;
import bluej.extensions2.editor.StrideEditor;
import bluej.pkgmgr.target.ClassTarget;

public class EditorBridge {
    public static JavaEditor newJavaEditor(BClass bClass, ClassTarget aTarget) {
        if (aTarget == null || aTarget.getSourceType() != SourceType.Java) {
            return null;
        }
        Editor bjEditor = aTarget.getEditor();
        if (bjEditor == null) {
            return null;
        }
        return new JavaEditor(bClass, bjEditor.assumeText());
    }

    public static JavaEditor newJavaEditorIfOpen(BClass bClass, ClassTarget aTarget) {
        if (aTarget == null || aTarget.getSourceType() != SourceType.Java) {
            return null;
        }
        Editor bjEditor = aTarget.getEditorIfOpen();
        if (bjEditor == null) {
            return null;
        }
        return new JavaEditor(bClass, bjEditor.assumeText());
    }

    public static StrideEditor newStrideEditor(BClass bClass, ClassTarget aTarget) {
        if (aTarget == null || aTarget.getSourceType() != SourceType.Stride) {
            return null;
        }
        Editor bjEditor = aTarget.getEditor();
        if (bjEditor == null || !(bjEditor instanceof FrameEditor)) {
            return null;
        }
        return new StrideEditor(bClass, (FrameEditor)bjEditor);
    }

    public static StrideEditor newStrideEditorIfOpen(BClass bClass, ClassTarget aTarget) {
        if (aTarget == null || aTarget.getSourceType() != SourceType.Stride) {
            return null;
        }
        Editor bjEditor = aTarget.getEditorIfOpen();
        if (bjEditor == null || !(bjEditor instanceof FrameEditor)) {
            return null;
        }
        return new StrideEditor(bClass, (FrameEditor)bjEditor);
    }

    public static Editor getJavaEditor(JavaEditor editor) {
        return editor.getEditor();
    }
}

