/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.media.AudioClip;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
class SoundCompletion
implements InteractionManager.FileCompletion {
    private final File file;

    public SoundCompletion(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getType() {
        return "Sound";
    }

    @Override
    public Node getPreview(double maxWidth, double maxHeight) {
        Button b = new Button("Play (F8)");
        b.setOnAction(e -> this.play());
        return b;
    }

    private void play() {
        try {
            AudioClip clip = new AudioClip(this.file.toURI().toURL().toString());
            clip.play();
        }
        catch (MalformedURLException ex) {
            Debug.reportError(ex);
        }
    }

    @Override
    public Map<KeyCode, Runnable> getShortcuts() {
        return Collections.singletonMap(KeyCode.F8, this::play);
    }
}

