/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.Main;
import bluej.collect.DataCollector;
import bluej.editor.stride.FXTab;
import bluej.editor.stride.FrameCatalogue;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.FrameSelection;
import bluej.editor.stride.FrameShelf;
import bluej.editor.stride.WebTab;
import bluej.editor.stride.WindowOverlayPane;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXSupplier;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.UnfocusableScrollPane;
import bluej.utility.javafx.UntitledCollapsiblePane;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.MenuBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class FXTabbedEditor {
    private final SimpleBooleanProperty showingCatalogue = new SimpleBooleanProperty(true);
    private final Project project;
    private final ArrayList<Frame> dragSourceFrames = new ArrayList();
    private final SimpleDoubleProperty mouseDragXProperty = new SimpleDoubleProperty();
    private final SimpleDoubleProperty mouseDragYProperty = new SimpleDoubleProperty();
    private Rectangle startSize;
    private Stage stage;
    private Scene scene;
    private TabPane tabPane;
    private Pane dragPane;
    private Pane dragCursorPane;
    private WindowOverlayPane overlayPane;
    private FrameCatalogue cataloguePane;
    private MenuBar menuBar;
    private Tab hoverTab;
    private FXPlatformRunnable hoverTabTask;
    private ImageView dragIcon = null;
    private @OnThread(value=Tag.Any) String projectTitle;
    private StringProperty titleStatus = new SimpleStringProperty("");
    private UntitledCollapsiblePane collapsibleCatalogueScrollPane;
    private FrameShelf shelf;
    private boolean dragFromShelf;

    @OnThread(value=Tag.Any)
    public FXTabbedEditor(Project project, Rectangle startSize) {
        this.project = project;
        this.startSize = startSize;
    }

    static boolean isUselessDrag(FrameCursor dragTarget, List<Frame> dragging, boolean copying) {
        return !copying && (dragging.contains(dragTarget.getFrameAfter()) || dragging.contains(dragTarget.getFrameBefore()));
    }

    @OnThread(value=Tag.FXPlatform)
    public void initialise() {
        this.projectTitle = this.project.getProjectName();
        this.stage = new Stage();
        BlueJTheme.setWindowIconFX(this.stage);
        this.initialiseFX();
    }

    @OnThread(value=Tag.FXPlatform)
    private void initialiseFX() {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(Main.getStoredContextClassLoader());
        }
        Config.loadFXFonts();
        this.tabPane = new TabPane();
        this.tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.menuBar = new MenuBar();
        JavaFXUtil.addStyleClass((Styleable)this.menuBar, "editor-menubar");
        this.menuBar.setUseSystemMenuBar(true);
        this.dragPane = new Pane();
        this.dragPane.setMouseTransparent(true);
        this.dragCursorPane = new Pane();
        this.dragCursorPane.setMouseTransparent(true);
        this.cataloguePane = new FrameCatalogue();
        BorderPane menuAndTabPane = new BorderPane();
        menuAndTabPane.setTop((Node)this.menuBar);
        this.overlayPane = new WindowOverlayPane();
        menuAndTabPane.setCenter((Node)new StackPane(new Node[]{this.tabPane}));
        this.shelf = new FrameShelf(this, this.project.getShelfStorage());
        UnfocusableScrollPane catalogueScrollPane = new UnfocusableScrollPane((Node)this.cataloguePane);
        catalogueScrollPane.setMaxWidth(220.0);
        catalogueScrollPane.setMinWidth(0.0);
        catalogueScrollPane.setFitToWidth(true);
        catalogueScrollPane.setFocusTraversable(false);
        catalogueScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        catalogueScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        JavaFXUtil.addStyleClass((Styleable)catalogueScrollPane, "catalogue-scroll");
        BorderPane catalogueBackground = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)catalogueBackground, "catalogue-background");
        Label title = new Label(Config.getString("frame.catalogue.title"));
        BorderPane.setAlignment((Node)title, (Pos)Pos.BOTTOM_RIGHT);
        catalogueBackground.setBottom((Node)title);
        StackPane catalogueScrollPaneStacked = new StackPane(new Node[]{catalogueBackground, catalogueScrollPane});
        catalogueScrollPaneStacked.setMinWidth(0.0);
        FXPlatformConsumer<Boolean> frameCatalogueShownListener = show -> this.recordShowHideFrameCatalogue((boolean)show, FrameCatalogue.ShowReason.ARROW);
        this.collapsibleCatalogueScrollPane = new UntitledCollapsiblePane((Node)catalogueScrollPaneStacked, UntitledCollapsiblePane.ArrowLocation.LEFT, PrefMgr.getFlag("bluej.editor.stride.sidebarShowing"), frameCatalogueShownListener);
        this.collapsibleCatalogueScrollPane.addArrowWrapperStyleClass("catalogue-collapse");
        this.showingCatalogue.bindBidirectional((Property)this.collapsibleCatalogueScrollPane.expandedProperty());
        JavaFXUtil.addChangeListener(this.showingCatalogue, expanded -> PrefMgr.setFlag("bluej.editor.stride.sidebarShowing", expanded));
        JavaFXUtil.runAfterCurrent(() -> {
            boolean flag = PrefMgr.getFlag("bluej.editor.stride.sidebarShowing");
            this.showingCatalogue.set(flag);
            this.recordShowHideFrameCatalogue(flag, FrameCatalogue.ShowReason.PROPERTIES);
        });
        JavaFXUtil.addStyleClass((Styleable)this.collapsibleCatalogueScrollPane, "catalogue-scroll-collapsible");
        menuAndTabPane.setRight((Node)this.collapsibleCatalogueScrollPane);
        this.scene = new Scene((Parent)new StackPane(new Node[]{menuAndTabPane, this.dragPane, this.dragCursorPane, this.overlayPane.getNode()}), 800.0, 700.0);
        this.stage.setScene(this.scene);
        Config.addEditorStylesheets(this.scene);
        JavaFXUtil.addMacMinimiseShortcutHandler(this.stage);
        this.tabPane.getStyleClass().add((Object)"tabbed-editor");
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends Tab> a, Tab prevSel, Tab selTab) {
                if (selTab != null) {
                    FXTabbedEditor.this.updateMenusForTab((FXTab)selTab);
                }
                if (prevSel != null && prevSel != selTab) {
                    ((FXTab)prevSel).notifyUnselected();
                }
                if (selTab != null && FXTabbedEditor.this.stage.isFocused()) {
                    ((FXTab)selTab).notifySelected();
                }
                if (selTab != null && ((FXTab)selTab).shouldShowCatalogue()) {
                    FXTabbedEditor.this.collapsibleCatalogueScrollPane.setVisible(true);
                    FXTabbedEditor.this.collapsibleCatalogueScrollPane.setManaged(true);
                } else {
                    FXTabbedEditor.this.collapsibleCatalogueScrollPane.setVisible(false);
                    FXTabbedEditor.this.collapsibleCatalogueScrollPane.setManaged(false);
                }
                if (FXTabbedEditor.this.isWindowVisible() && !(selTab instanceof FrameEditorTab)) {
                    JavaFXUtil.runPlatformLater(() -> FXTabbedEditor.this.scheduleUpdateCatalogue(null, null, CodeCompletionState.NOT_POSSIBLE, false, Frame.View.NORMAL, Collections.emptyList(), Collections.emptyList()));
                }
            }
        });
        this.tabPane.getTabs().addListener(e -> {
            if (this.tabPane.getTabs().isEmpty()) {
                this.startSize = new Rectangle((double)((int)this.stage.getX()), (double)((int)this.stage.getY()), (double)((int)this.stage.getWidth()), (double)((int)this.stage.getHeight()));
                this.stage.close();
                this.project.removeFXTabbedEditor(this);
            }
        });
        this.stage.setOnHidden(e -> {
            ArrayList tabs = new ArrayList(this.tabPane.getTabs());
            tabs.forEach(t -> this.close((FXTab)((Object)((Object)t))));
        });
        JavaFXUtil.addChangeListenerPlatform(this.stage.focusedProperty(), focused -> {
            Tab selectedItem = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
            if (selectedItem != null && selectedItem instanceof FXTab) {
                if (focused.booleanValue()) {
                    ((FXTab)selectedItem).notifySelected();
                } else {
                    ((FXTab)selectedItem).notifyUnselected();
                }
            }
        });
        JavaFXUtil.addChangeListenerPlatform(this.stage.iconifiedProperty(), minimised -> {
            if (minimised.booleanValue()) {
                ((FXTab)((Object)((Object)this.tabPane.getSelectionModel().getSelectedItem()))).notifyUnselected();
            }
        });
        this.tabPane.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (Config.isWinOS() && (e.getCode() == KeyCode.ALT_GRAPH || e.getCode() == KeyCode.ALT && e.isControlDown())) {
                e.consume();
                return;
            }
            if (Config.isWinOS() && e.isAltDown() && e.isControlDown()) {
                e.consume();
                return;
            }
            if (!e.isShortcutDown() || e.isAltDown()) {
                return;
            }
            int tab = this.tabPane.getSelectionModel().getSelectedIndex();
            switch (e.getCode()) {
                case DIGIT1: {
                    tab = 0;
                    break;
                }
                case DIGIT2: {
                    tab = 1;
                    break;
                }
                case DIGIT3: {
                    tab = 2;
                    break;
                }
                case DIGIT4: {
                    tab = 3;
                    break;
                }
                case DIGIT5: {
                    tab = 4;
                    break;
                }
                case DIGIT6: {
                    tab = 5;
                    break;
                }
                case DIGIT7: {
                    tab = 6;
                    break;
                }
                case DIGIT8: {
                    tab = 7;
                    break;
                }
                case DIGIT9: {
                    tab = 8;
                    break;
                }
                case TAB: {
                    if (e.isShiftDown()) {
                        if (--tab >= 0) break;
                        tab = this.tabPane.getTabs().size() - 1;
                        break;
                    }
                    tab = (tab + 1) % this.tabPane.getTabs().size();
                    break;
                }
                default: {
                    return;
                }
            }
            if (tab < this.tabPane.getTabs().size()) {
                this.tabPane.getSelectionModel().select((Object)((Tab)this.tabPane.getTabs().get(tab)));
            }
            e.consume();
        });
        this.stage.titleProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{JavaFXUtil.applyPlatform(this.tabPane.getSelectionModel().selectedItemProperty(), t -> ((FXTab)((Object)t)).windowTitleProperty(), "Unknown"), " - ", this.projectTitle, this.titleStatus}));
    }

    @OnThread(value=Tag.FXPlatform)
    private void recordShowHideFrameCatalogue(boolean show, FrameCatalogue.ShowReason reason) {
        Tab selectedTab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        if (selectedTab instanceof InteractionManager) {
            ((InteractionManager)selectedTab).recordShowHideFrameCatalogue(show, reason);
        } else {
            DataCollector.showHideFrameCatalogue(this.getProject(), null, null, -1, show, reason);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void updateMenusForTab(FXTab selTab) {
        this.menuBar.getMenus().setAll(selTab.getMenus());
    }

    public BooleanProperty catalogueShowingProperty() {
        return this.showingCatalogue;
    }

    @OnThread(value=Tag.FXPlatform)
    public boolean addTab(FXTab panel, boolean visible, boolean toFront) {
        return this.addTab(panel, visible, toFront, false);
    }

    @OnThread(value=Tag.FXPlatform)
    private boolean addTab(FXTab panel, boolean visible, boolean toFront, boolean partOfMove) {
        panel.setParent(this, partOfMove);
        panel.initialiseFX();
        if (!this.tabPane.getTabs().contains((Object)panel)) {
            this.tabPane.getTabs().add((Object)panel);
            if (toFront) {
                this.setWindowVisible(visible, panel);
                this.bringToFront(panel);
                Platform.runLater(panel::focusWhenShown);
            }
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public void openJavaCoreDocTab(String qualifiedClassName) {
        this.openJavaCoreDocTab(qualifiedClassName, "");
    }

    @OnThread(value=Tag.FXPlatform)
    public void openJavaCoreDocTab(String qualifiedClassName, String suffix) {
        Class<?> theClass = this.project.loadClass(qualifiedClassName);
        String moduleName = theClass == null ? "java.base" : theClass.getModule().getName();
        String target = Utility.getDocURL(moduleName, qualifiedClassName, suffix);
        this.openWebViewTab(target);
    }

    @OnThread(value=Tag.FXPlatform)
    public void openGreenfootDocTab(String qualifiedClassName) {
        this.openGreenfootDocTab(qualifiedClassName, "");
    }

    @OnThread(value=Tag.FXPlatform)
    public void openGreenfootDocTab(String qualifiedClassName, String suffix) {
        try {
            String target = Utility.getGreenfootApiDocURL(qualifiedClassName.replace('.', '/') + ".html");
            this.openWebViewTab(target + suffix);
        }
        catch (IOException e) {
            Debug.reportError(e);
        }
    }

    public boolean setWindowVisible(boolean visible, Tab tab) {
        if (visible) {
            boolean wasAlreadyShowing = this.stage.isShowing();
            if (!wasAlreadyShowing) {
                if (this.startSize != null) {
                    Point2D topLeft = Config.ensureOnScreen((int)this.startSize.getX(), (int)this.startSize.getY());
                    this.stage.setX(topLeft.getX());
                    this.stage.setY(topLeft.getY());
                    this.stage.setWidth(this.startSize.getWidth());
                    this.stage.setHeight(this.startSize.getHeight());
                }
                this.stage.show();
                if (this.startSize == null) {
                    List otherWindowPositions = this.project.getAllFXTabbedEditorWindows().stream().filter(w -> w != this).map(w -> new Point2D((double)w.getX(), (double)w.getY())).collect(Collectors.toList());
                    Point2D us = new Point2D(this.stage.getX(), this.stage.getY());
                    int attempts = 0;
                    while (otherWindowPositions.contains(us) && attempts++ < 5) {
                        this.stage.setX(32.0 + this.stage.getX());
                        this.stage.setY(32.0 + this.stage.getY());
                        us = new Point2D(this.stage.getX(), this.stage.getY());
                    }
                }
            }
            if (!this.tabPane.getTabs().contains((Object)tab)) {
                this.tabPane.getTabs().add((Object)tab);
                return true;
            }
            return !wasAlreadyShowing;
        }
        return this.tabPane.getTabs().remove((Object)tab);
    }

    public boolean isWindowVisible() {
        return this.stage.isShowing();
    }

    @OnThread(value=Tag.FXPlatform)
    public void bringToFront(Tab tab) {
        this.stage.setIconified(false);
        Utility.bringToFrontFX((Window)this.stage);
        this.tabPane.getSelectionModel().select((Object)tab);
    }

    @OnThread(value=Tag.Any)
    public Project getProject() {
        return this.project;
    }

    @OnThread(value=Tag.FXPlatform)
    public void close(FXTab tab) {
        this.close(tab, false);
    }

    @OnThread(value=Tag.FXPlatform)
    private void close(FXTab tab, boolean partOfMove) {
        this.tabPane.getTabs().remove((Object)tab);
        tab.setParent(null, partOfMove);
    }

    @OnThread(value=Tag.FXPlatform)
    public void openWebViewTab(String url) {
        this.openWebViewTab(url, false);
    }

    @OnThread(value=Tag.FXPlatform)
    public void openWebViewTab(String url, boolean isTutorial) {
        try {
            URI target = new URI(url);
            for (FXTab tab : this.getFXTabs()) {
                URI tabURI;
                if (tab.getWebAddress() == null || !(tabURI = new URI(tab.getWebAddress())).equals(target)) continue;
                this.bringToFront(tab);
                return;
            }
        }
        catch (URISyntaxException e) {
            Debug.reportError("Error in URI when opening web view tab: \"" + url + "\"");
        }
        this.addTab(new WebTab(url, isTutorial), true, true);
    }

    public ObservableList<Tab> tabsProperty() {
        return this.tabPane.getTabs();
    }

    public Pane getDragPane() {
        return this.dragPane;
    }

    public Pane getDragCursorPane() {
        return this.dragCursorPane;
    }

    public void frameDragBegin(List<Frame> srcFrames, boolean fromShelf, double mouseSceneX, double mouseSceneY) {
        if (this.dragIcon != null || !this.dragSourceFrames.isEmpty()) {
            throw new IllegalStateException("Drag begun while drag in progress");
        }
        this.dragSourceFrames.clear();
        this.dragSourceFrames.addAll(srcFrames);
        Image img = Frame.takeShot(this.dragSourceFrames, null);
        if (this.dragSourceFrames.stream().allMatch(Frame::canDrag) && img != null) {
            ImageView icon = new ImageView(img);
            icon.setEffect((Effect)new DropShadow(7.0, 2.0, 2.0, Color.BLACK));
            for (Frame src : this.dragSourceFrames) {
                src.setDragSourceEffect(true);
            }
            double srcSceneX = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getX();
            double srcSceneY = this.dragSourceFrames.get(0).getNode().localToScene(0.0, 0.0).getY();
            icon.layoutXProperty().bind((ObservableValue)this.mouseDragXProperty.subtract(mouseSceneX - srcSceneX));
            icon.layoutYProperty().bind((ObservableValue)this.mouseDragYProperty.subtract(mouseSceneY - srcSceneY));
            this.getDragPane().getChildren().add((Object)icon);
            this.dragIcon = icon;
            this.dragFromShelf = fromShelf;
            this.scene.setCursor(Cursor.CLOSED_HAND);
        } else {
            this.dragSourceFrames.clear();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void draggedTo(double sceneX, double sceneY, JavaFXUtil.DragType dragType) {
        if (!this.dragSourceFrames.isEmpty()) {
            Point2D p = this.dragPane.sceneToLocal(sceneX, sceneY);
            this.mouseDragXProperty.set(p.getX());
            this.mouseDragYProperty.set(p.getY());
            this.checkHoverDuringDrag(sceneX, sceneY, dragType);
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)this.tabPane.getSelectionModel().getSelectedItem()).draggedToTab(this.dragSourceFrames, sceneX, sceneY, this.calcDragCopy(dragType, false));
            }
            this.shelf.draggedTo(this.dragSourceFrames, sceneX, sceneY, this.calcDragCopy(dragType, true));
        }
    }

    private boolean calcDragCopy(JavaFXUtil.DragType dragType, boolean toShelf) {
        switch (dragType) {
            case FORCE_MOVING: {
                return false;
            }
            case FORCE_COPYING: {
                return true;
            }
        }
        if (this.dragFromShelf && toShelf) {
            return false;
        }
        return this.dragFromShelf && !toShelf;
    }

    public boolean isDragging() {
        return !this.dragSourceFrames.isEmpty();
    }

    @OnThread(value=Tag.FXPlatform)
    private void checkHoverDuringDrag(double sceneX, double sceneY, JavaFXUtil.DragType dragType) {
        for (Tab t : this.tabPane.getTabs()) {
            Bounds b = t.getGraphic().localToScene(t.getGraphic().getBoundsInLocal());
            if (!b.contains(sceneX, sceneY) || this.hoverTab == t || !(t instanceof FrameEditorTab)) continue;
            this.hoverTab = t;
            if (this.hoverTabTask != null) {
                this.hoverTabTask.run();
            }
            this.hoverTabTask = JavaFXUtil.runAfter(Duration.millis((double)500.0), () -> {
                ((FrameEditorTab)this.tabPane.getSelectionModel().getSelectedItem()).draggedToAnotherTab();
                this.tabPane.getSelectionModel().select((Object)t);
                this.draggedTo(sceneX, sceneY, dragType);
            });
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void frameDragEnd(JavaFXUtil.DragType dragType) {
        if (this.hoverTabTask != null) {
            this.hoverTabTask.run();
        }
        this.hoverTab = null;
        if (!this.dragSourceFrames.isEmpty()) {
            this.getDragPane().getChildren().remove((Object)this.dragIcon);
            this.dragIcon = null;
            this.dragSourceFrames.forEach(f -> f.setDragSourceEffect(false));
            if (this.tabPane.getSelectionModel().getSelectedItem() instanceof FrameEditorTab) {
                ((FrameEditorTab)this.tabPane.getSelectionModel().getSelectedItem()).dragEndTab(this.dragSourceFrames, this.dragFromShelf, this.calcDragCopy(dragType, false));
            }
            this.shelf.dragEnd(this.dragSourceFrames, this.dragFromShelf, this.calcDragCopy(dragType, true));
            this.dragSourceFrames.clear();
            this.scene.setCursor(Cursor.DEFAULT);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void scheduleUpdateCatalogue(FrameEditorTab editor, FrameCursor c, CodeCompletionState codeCompletion, boolean selection, Frame.View viewMode, List<ExtensionDescription> altExtensions, List<FrameCatalogue.Hint> hints) {
        this.cataloguePane.scheduleUpdateCatalogue(editor, viewMode == Frame.View.NORMAL ? c : null, codeCompletion, selection, viewMode, altExtensions, hints);
    }

    public WindowOverlayPane getOverlayPane() {
        return this.overlayPane;
    }

    public boolean hasOneTab() {
        return this.tabPane.getTabs().size() == 1;
    }

    public boolean containsTab(Tab tab) {
        return this.tabPane.getTabs().contains((Object)tab);
    }

    public StringExpression titleProperty() {
        return this.stage.titleProperty();
    }

    private List<FXTab> getFXTabs() {
        return Utility.mapList(this.tabPane.getTabs(), t -> (FXTab)((Object)t));
    }

    public void setTitleStatus(String status) {
        this.titleStatus.set((Object)status);
    }

    public Stage getStage() {
        return this.stage;
    }

    public static void setupFrameDrag(Frame f, boolean isShelf, FXSupplier<FXTabbedEditor> parent, FXSupplier<Boolean> canDrag, FXSupplier<FrameSelection> selection) {
        f.getNode().setOnDragDetected(event -> {
            double mouseSceneX = event.getSceneX();
            double mouseSceneY = event.getSceneY();
            if (((Boolean)canDrag.get()).booleanValue()) {
                if (((FrameSelection)selection.get()).contains(f)) {
                    ((FXTabbedEditor)parent.get()).frameDragBegin(((FrameSelection)selection.get()).getSelected(), isShelf, mouseSceneX, mouseSceneY);
                } else {
                    ((FXTabbedEditor)parent.get()).frameDragBegin(Arrays.asList(f), isShelf, mouseSceneX, mouseSceneY);
                }
            }
            event.consume();
        });
        f.getNode().setOnMouseDragged(event -> {
            ((FXTabbedEditor)parent.get()).draggedTo(event.getSceneX(), event.getSceneY(), JavaFXUtil.getDragModifiers(event));
            event.consume();
        });
        f.getNode().setOnMouseReleased(event -> {
            if (!((FXTabbedEditor)parent.get()).isDragging()) {
                return;
            }
            ((FXTabbedEditor)parent.get()).draggedTo(event.getSceneX(), event.getSceneY(), JavaFXUtil.getDragModifiers(event));
            ((FXTabbedEditor)parent.get()).frameDragEnd(JavaFXUtil.getDragModifiers(event));
            event.consume();
        });
    }

    public void cleanup() {
        this.shelf.cleanup();
    }

    public boolean hasTutorial() {
        return this.tabPane.getTabs().stream().anyMatch(t -> t instanceof FXTab && ((FXTab)((Object)t)).isTutorial());
    }

    public double getRenderScaleX() {
        return this.stage.getRenderScaleX();
    }

    public double getRenderScaleY() {
        return this.stage.getRenderScaleY();
    }

    @OnThread(value=Tag.FXPlatform)
    public void moveToNewLater(FXTab tab) {
        FXTabbedEditor newWindow = this.project.createNewFXTabbedEditor();
        this.moveTabTo(tab, newWindow);
    }

    @OnThread(value=Tag.FXPlatform)
    public void moveTabTo(FXTab tab, FXTabbedEditor destination) {
        this.close(tab, true);
        destination.addTab(tab, true, true, true);
    }

    @OnThread(value=Tag.FXPlatform)
    public void updateMoveMenus() {
        this.tabPane.getTabs().forEach(t -> this.updateMenusForTab((FXTab)((Object)t)));
    }

    @OnThread(value=Tag.FX)
    public int getX() {
        return (int)this.stage.getX();
    }

    @OnThread(value=Tag.FX)
    public int getY() {
        return (int)this.stage.getY();
    }

    @OnThread(value=Tag.FX)
    public int getWidth() {
        return (int)this.stage.getWidth();
    }

    @OnThread(value=Tag.FX)
    public int getHeight() {
        return (int)this.stage.getHeight();
    }

    public static enum CodeCompletionState {
        NOT_POSSIBLE,
        SHOWING,
        POSSIBLE;

    }
}

