/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.ScopeColorsBorderPane;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableIntegerValue;
import javafx.scene.paint.Color;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public interface ScopeColors {
    public ObjectExpression<Color> scopeClassColorProperty();

    public ObjectExpression<Color> scopeClassInnerColorProperty();

    public ObjectExpression<Color> scopeClassOuterColorProperty();

    public ObjectExpression<Color> scopeMethodColorProperty();

    public ObjectExpression<Color> scopeMethodOuterColorProperty();

    public ObjectExpression<Color> scopeSelectionColorProperty();

    public ObjectExpression<Color> scopeSelectionOuterColorProperty();

    public ObjectExpression<Color> scopeIterationColorProperty();

    public ObjectExpression<Color> scopeIterationOuterColorProperty();

    public ObjectExpression<Color> scopeBackgroundColorProperty();

    public ObjectExpression<Color> breakpointOverlayColorProperty();

    public ObjectExpression<Color> stepMarkOverlayColorProperty();

    default public ObjectExpression<Color> getReducedColor(ObjectExpression<Color> original, ObservableIntegerValue colorStrength) {
        return Bindings.createObjectBinding(() -> {
            Color bg = (Color)this.scopeBackgroundColorProperty().getValue();
            return bg.interpolate((Color)original.getValue(), (double)colorStrength.get() / 20.0);
        }, (Observable[])new Observable[]{this.scopeBackgroundColorProperty(), colorStrength, original});
    }

    @OnThread(value=Tag.FXPlatform)
    public static ScopeColors dummy() {
        return new ScopeColorsBorderPane();
    }
}

