/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.editor.flow.Document;
import bluej.extensions2.editor.DocumentListener;
import bluej.utility.javafx.FXPlatformRunnable;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class MultilineStringTracker
implements DocumentListener {
    private final TreeSet<Position> positionsOfTripleQuotes = new TreeSet();
    private final Document document;
    private final FXPlatformRunnable changeListener;

    public MultilineStringTracker(Document document, FXPlatformRunnable changeListener) {
        this.document = document;
        this.changeListener = changeListener;
        document.addListener(false, this);
    }

    @Override
    public void textReplaced(int origStartIncl, String replaced, String replacement, int linesRemoved, int linesAdded) {
        int affectedEnd;
        int affectedStart;
        for (affectedStart = Math.max(0, origStartIncl - 1); affectedStart > 0 && this.document.getContent(affectedStart, affectedStart + 1).charAt(0) == '\"'; --affectedStart) {
        }
        for (affectedEnd = origStartIncl + replacement.length(); affectedEnd < this.document.getLength() && this.document.getContent(affectedEnd, affectedEnd + 1).charAt(0) == '\"'; ++affectedEnd) {
        }
        SortedSet<Position> toRemove = this.positionsOfTripleQuotes.subSet(new Position(affectedStart), new Position(affectedEnd - replacement.length() + replaced.length()));
        boolean anyChanged = !toRemove.isEmpty();
        toRemove.clear();
        this.positionsOfTripleQuotes.tailSet(new Position(affectedEnd - replacement.length() + replaced.length())).forEach(i -> i.value += replacement.length() - replaced.length());
        int quoteCount = 0;
        CharSequence subSequence = this.document.getContent(affectedStart, affectedEnd);
        for (int i2 = affectedStart; i2 < affectedEnd; ++i2) {
            if (subSequence.charAt(i2 - affectedStart) == '\"') {
                if (++quoteCount != 3) continue;
                this.positionsOfTripleQuotes.add(new Position(i2 - 2));
                anyChanged = true;
                quoteCount = 0;
                continue;
            }
            quoteCount = 0;
        }
        if (anyChanged) {
            this.changeListener.run();
        }
    }

    public SortedSet<Position> getTripleQuotesBetween(int startIndexIncl, int endIndexExcl) {
        return this.positionsOfTripleQuotes.subSet(new Position(startIndexIncl), new Position(endIndexExcl));
    }

    private boolean validOpeningMultiline(Position tripleQuote) {
        int lineStart = this.document.getLineStart(this.document.getLineFromPosition(tripleQuote.value));
        if (this.document.getContent(lineStart, tripleQuote.value).toString().contains("//")) {
            return false;
        }
        int lineEnd = this.document.getLineEnd(this.document.getLineFromPosition(tripleQuote.value));
        return this.document.getContent(tripleQuote.value + 3, lineEnd).chars().allMatch(Character::isWhitespace);
    }

    public TextBlockRelation getTextBlockRelation(int lineStart, int lineEnd, int startLatestScope) {
        SortedSet<Position> relevantTripleQuotes = this.getTripleQuotesBetween(startLatestScope, lineEnd);
        boolean entirelyInsideString = false;
        boolean foundClosingOnThisLine = false;
        for (Position relevantTripleQuote : relevantTripleQuotes) {
            if (!entirelyInsideString && this.validOpeningMultiline(relevantTripleQuote)) {
                if (relevantTripleQuote.getValue() >= lineStart && relevantTripleQuote.getValue() < lineEnd) {
                    return foundClosingOnThisLine ? TextBlockRelation.CLOSING_AND_OPENING_LINE : TextBlockRelation.OPENING_LINE_ONLY;
                }
                entirelyInsideString = true;
                continue;
            }
            if (!entirelyInsideString) continue;
            entirelyInsideString = false;
            if (relevantTripleQuote.getValue() < lineStart || relevantTripleQuote.getValue() >= lineEnd) continue;
            foundClosingOnThisLine = true;
        }
        if (entirelyInsideString) {
            return TextBlockRelation.ENTIRELY_INSIDE;
        }
        if (foundClosingOnThisLine) {
            return TextBlockRelation.CLOSING_LINE_ONLY;
        }
        return TextBlockRelation.NONE;
    }

    public static class Position
    implements Comparable<Position> {
        private int value;

        public Position(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Position o) {
            return Integer.compare(this.value, o.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position anPosition = (Position)o;
            return this.value == anPosition.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "I" + Integer.toString(this.value);
        }
    }

    public static enum TextBlockRelation {
        ENTIRELY_INSIDE,
        OPENING_LINE_ONLY,
        CLOSING_LINE_ONLY,
        CLOSING_AND_OPENING_LINE,
        NONE;

    }
}

