/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.fixes;

import bluej.editor.fixes.FixSuggestion;
import bluej.editor.fixes.ProjectImportInformation;
import bluej.editor.fixes.SuggestionList;
import bluej.parser.AssistContentThreadSafe;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.role.Kind;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import threadchecker.OnThread;
import threadchecker.Tag;

public class EditorFixesManager {
    private final @OnThread(value=Tag.Any) CompletableFuture<ProjectImportInformation> projectImportInformation;
    private final @OnThread(value=Tag.Any) ReadWriteLock importedTypesLock;
    private final @OnThread(value=Tag.Any) List<Future<List<AssistContentThreadSafe>>> importedTypes;
    private @OnThread(value=Tag.Any) Project project;

    @OnThread(value=Tag.Any)
    public EditorFixesManager(CompletableFuture<ProjectImportInformation> projectImportInformation) {
        this.projectImportInformation = projectImportInformation;
        this.importedTypesLock = new ReentrantReadWriteLock();
        this.importedTypes = new ArrayList<Future<List<AssistContentThreadSafe>>>();
    }

    @OnThread(value=Tag.Any)
    public Future<List<AssistContentThreadSafe>> scanImports(String importString) {
        CompletableFuture<List<AssistContentThreadSafe>> f = new CompletableFuture<List<AssistContentThreadSafe>>();
        Utility.runBackground(() -> {
            try {
                f.complete(this.projectImportInformation.get().scanImports(importString));
            }
            catch (Throwable t) {
                Debug.reportError("Exception while scanning for import " + importString, t);
                f.complete(Collections.emptyList());
            }
        });
        return f;
    }

    @OnThread(value=Tag.Worker)
    public Map<SuggestionList.SuggestionShown, Collection<AssistContentThreadSafe>> getImportSuggestions() {
        HashMap imports = new HashMap();
        try {
            List<AssistContentThreadSafe> popularImports = this.projectImportInformation.get().getPopularImports();
            List<AssistContentThreadSafe> rarerImports = this.projectImportInformation.get().getRarerImports();
            Stream.concat(popularImports.stream().map(ac -> new Pair((Object)SuggestionList.SuggestionShown.COMMON, ac)), rarerImports.stream().map(ac -> new Pair((Object)SuggestionList.SuggestionShown.RARE, ac))).filter(imp -> ((AssistContentThreadSafe)imp.getValue()).getPackage() != null).forEach(imp -> {
                String fullName = ((AssistContentThreadSafe)imp.getValue()).getPackage() + ".";
                if (((AssistContentThreadSafe)imp.getValue()).getDeclaringClass() != null) {
                    fullName = fullName + ((AssistContentThreadSafe)imp.getValue()).getDeclaringClass() + ".";
                }
                fullName = fullName + ((AssistContentThreadSafe)imp.getValue()).getName();
                imports.put(fullName, imp);
            });
            this.getAllImportedTypes().filter(imp -> imp.getPackage() != null).forEach(imp -> imports.remove(imp.getPackage() + "." + imp.getName()));
            imports.remove("java.awt.List");
        }
        catch (InterruptedException | ExecutionException ex) {
            Debug.reportError(ex);
        }
        HashMap<SuggestionList.SuggestionShown, Collection<AssistContentThreadSafe>> ret = new HashMap<SuggestionList.SuggestionShown, Collection<AssistContentThreadSafe>>();
        imports.values().forEach(p -> ret.merge((SuggestionList.SuggestionShown)((Object)((Object)p.getKey())), new ArrayList<AssistContentThreadSafe>(Arrays.asList((AssistContentThreadSafe)p.getValue())), (a, b) -> {
            a.addAll(b);
            return a;
        }));
        return ret;
    }

    @OnThread(value=Tag.FXPlatform)
    public List<AssistContentThreadSafe> getPrimitiveTypes() {
        return ProjectImportInformation.getPrims();
    }

    @OnThread(value=Tag.Any)
    public List<Future<List<AssistContentThreadSafe>>> getImportedTypesFutureList() {
        return this.importedTypes;
    }

    @OnThread(value=Tag.Worker)
    public Stream<AssistContentThreadSafe> getAllImportedTypes() {
        this.importedTypesLock.readLock().lock();
        ArrayList<Future<List<AssistContentThreadSafe>>> importedTypesCopy = new ArrayList<Future<List<AssistContentThreadSafe>>>(this.importedTypes);
        this.importedTypesLock.readLock().unlock();
        return Stream.concat(Stream.of(this.projectImportInformation.thenApply(i -> i.getJavaLangImports())), importedTypesCopy.stream()).map(Utility::getFutureList).flatMap(Collection::stream);
    }

    @OnThread(value=Tag.Worker)
    public List<AssistContentThreadSafe> getImportedTypes(Class<?> superType, boolean includeSelf, Set<Kind> kinds) {
        if (superType == null) {
            return this.getAllImportedTypes().filter(ac -> kinds.contains((Object)ac.getTypeKind())).collect(Collectors.toList());
        }
        return this.getAllImportedTypes().filter(ac -> kinds.contains((Object)ac.getTypeKind())).filter(ac -> ac.getSuperTypes().contains(superType.getName()) || includeSelf && ac.getPackage() != null && (ac.getPackage() + "." + ac.getName()).equals(superType.getName())).collect(Collectors.toList());
    }

    @OnThread(value=Tag.Any)
    public ReadWriteLock getImportedTypesLock() {
        return this.importedTypesLock;
    }

    @OnThread(value=Tag.Any)
    public List<AssistContentThreadSafe> getJavaLangImports() {
        try {
            return this.projectImportInformation.get().getJavaLangImports();
        }
        catch (InterruptedException | ExecutionException ex) {
            Debug.reportError(ex);
            return Collections.emptyList();
        }
    }

    public static class FixSuggestionBase
    extends FixSuggestion {
        private final String description;
        private final FXPlatformRunnable executeRunnable;

        @OnThread(value=Tag.Any)
        public FixSuggestionBase(String description, FXPlatformRunnable executeRunnable) {
            this.description = description;
            this.executeRunnable = executeRunnable;
        }

        @Override
        @OnThread(value=Tag.Any)
        public String getDescription() {
            return this.description;
        }

        @Override
        public void execute() {
            this.executeRunnable.run();
        }
    }
}

