/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.fixes;

import bluej.Config;
import bluej.editor.fixes.FixSuggestion;
import bluej.parser.AssistContentThreadSafe;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import threadchecker.OnThread;
import threadchecker.Tag;

public class Correction
extends FixSuggestion {
    private final CorrectionElements correctionElements;
    private final String display;
    private final FXPlatformConsumer<CorrectionElements> replacer;
    private static final int MAX_EDIT_DISTANCE = 2;

    @OnThread(value=Tag.Any)
    private Correction(CorrectionElements correctionElements, FXPlatformConsumer<CorrectionElements> replacer, String display) {
        this.correctionElements = correctionElements;
        this.display = display;
        this.replacer = replacer;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getDescription() {
        return Config.getString("editor.quickfix.correctToSugg.fixMsg") + this.display;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void execute() {
        this.replacer.accept(this.correctionElements);
    }

    public static List<Correction> winnowAndCreateCorrections(String cur, Stream<CorrectionInfo> possibleCorrections, FXPlatformConsumer<CorrectionElements> replacer) {
        return Correction.winnowAndCreateCorrections(cur, possibleCorrections, replacer, false);
    }

    public static List<Correction> winnowAndCreateCorrections(String cur, Stream<CorrectionInfo> possibleCorrections, FXPlatformConsumer<CorrectionElements> replacer, boolean caseSensitive) {
        return possibleCorrections.map(n -> new StringAndDist((CorrectionInfo)n, Utility.editDistance(cur.toLowerCase(), n.getCorrectionToCompareWith().toLowerCase()))).filter(sd -> sd.distance <= 2 && (!caseSensitive || caseSensitive && (!sd.value.getCorrectionToCompareWith().equals(cur) || sd.value.getCorrectionElements().getPrimaryElement().contains(".") && sd.value.getCorrectionToCompareWith().equals(cur)))).sorted(Comparator.comparingInt(a -> a.distance)).limit(3L).map(sd -> new Correction(sd.value.getCorrectionElements(), replacer, sd.value.getDisplay())).collect(Collectors.toList());
    }

    @OnThread(value=Tag.Any)
    public static boolean isClassInUsualPackagesForCorrections(AssistContentThreadSafe acts) {
        List<String> commonPackages = Arrays.asList("java.lang", "java.io", "java.util", "javafx", "java.awt", "javax.swing");
        return commonPackages.contains(acts.getPackage()) || commonPackages.stream().filter(s -> acts.getPackage().startsWith(s + ".")).collect(Collectors.toList()).size() > 0;
    }

    @OnThread(value=Tag.Any)
    public static class CorrectionElements {
        private String primaryElement;
        private String[] secondaryElements;

        public CorrectionElements(String primaryElement, String[] secondaryElements) {
            this.primaryElement = primaryElement;
            this.secondaryElements = secondaryElements != null ? secondaryElements : new String[]{};
        }

        public CorrectionElements(String primaryElement) {
            this(primaryElement, null);
        }

        public String getPrimaryElement() {
            return this.primaryElement;
        }

        public String[] getSecondaryElements() {
            return this.secondaryElements;
        }
    }

    @OnThread(value=Tag.Any)
    private static class StringAndDist {
        public final CorrectionInfo value;
        public final int distance;

        public StringAndDist(CorrectionInfo value, int distance) {
            this.value = value;
            this.distance = distance;
        }
    }

    @OnThread(value=Tag.Any)
    public static interface CorrectionInfo {
        public String getCorrectionToCompareWith();

        public CorrectionElements getCorrectionElements();

        public String getDisplay();
    }

    @OnThread(value=Tag.Any)
    public static class TypeCorrectionInfo
    implements CorrectionInfo {
        private AssistContentThreadSafe acts = null;

        public TypeCorrectionInfo(AssistContentThreadSafe acts) {
            this.acts = acts;
        }

        @Override
        public CorrectionElements getCorrectionElements() {
            String[] stringArray;
            String primaryCorrElement;
            String string = primaryCorrElement = this.acts.getDeclaringClass() != null ? this.acts.getDeclaringClass() + "." + this.acts.getName() : this.acts.getName();
            if (this.acts.getPackage() == null || this.acts.getPackage().length() == 0 || this.acts.getPackage().equals("java.lang")) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.acts.getPackage();
            }
            String[] secondaryCorrElements = stringArray;
            return new CorrectionElements(primaryCorrElement, secondaryCorrElements);
        }

        @Override
        public String getCorrectionToCompareWith() {
            return this.acts.getName();
        }

        @Override
        public String getDisplay() {
            String pkg = this.acts.getPackage();
            String name = this.acts.getDeclaringClass() != null ? this.acts.getDeclaringClass() + "." + this.acts.getName() : this.acts.getName();
            return pkg == null || pkg.length() == 0 ? name : name + " (" + pkg + " package)";
        }
    }

    @OnThread(value=Tag.Any)
    public static class SimpleCorrectionInfo
    implements CorrectionInfo {
        private String correction;

        public SimpleCorrectionInfo(String correction) {
            this.correction = correction;
        }

        @Override
        public CorrectionElements getCorrectionElements() {
            return new CorrectionElements(this.correction);
        }

        @Override
        public String getCorrectionToCompareWith() {
            return this.correction;
        }

        @Override
        public String getDisplay() {
            return this.correction;
        }
    }
}

