/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableCanvas;
import javafx.beans.value.ObservableDoubleValue;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ObjectBackground
extends ResizableCanvas {
    private final double cornerSize;
    private final ObservableDoubleValue lineWidth;

    public ObjectBackground(double cornerSize, ObservableDoubleValue lineWidth) {
        this.cornerSize = cornerSize;
        this.lineWidth = lineWidth;
        JavaFXUtil.addChangeListenerPlatform(this.widthProperty(), w -> this.redrawContent());
        JavaFXUtil.addChangeListenerPlatform(this.heightProperty(), h -> this.redrawContent());
        JavaFXUtil.addChangeListenerPlatform(lineWidth, d -> this.redrawContent());
    }

    private void redrawContent() {
        GraphicsContext gc = this.getGraphicsContext2D();
        double w = this.getWidth();
        double h = this.getHeight();
        gc.clearRect(0.0, 0.0, w, h);
        Color fill = new Color(0.8901960784313725, 0.2784313725490196, 0.2784313725490196, 1.0);
        gc.setFill((Paint)fill);
        double l = this.lineWidth.get();
        gc.fillRoundRect(l, l, w - 2.0 * l, h - 2.0 * l, this.cornerSize * 1.1, this.cornerSize * 1.1);
        gc.setStroke((Paint)Color.BLACK);
        gc.setLineWidth(l);
        gc.strokeRoundRect(l, l, w - 2.0 * l, h - 2.0 * l, this.cornerSize, this.cornerSize);
    }
}

