/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.ConstructorReflective;
import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.MethodReflective;
import java.util.List;
import java.util.Map;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class Reflective {
    public abstract String getName();

    public String getSimpleName() {
        return this.getName();
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract List<GenTypeDeclTpar> getTypeParams();

    @OnThread(value=Tag.FXPlatform)
    public abstract List<Reflective> getSuperTypesR();

    @OnThread(value=Tag.FXPlatform)
    public abstract List<GenTypeClass> getSuperTypes();

    @OnThread(value=Tag.FXPlatform)
    public abstract Reflective getArrayOf();

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isAssignableFrom(Reflective var1);

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isInterface();

    @OnThread(value=Tag.FXPlatform)
    public GenTypeClass superTypeByName(String rawName) {
        List<GenTypeClass> superTypes = this.getSuperTypes();
        for (GenTypeClass next : superTypes) {
            if (!next.classloaderName().equals(rawName)) continue;
            return next;
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract Reflective getRelativeClass(String var1);

    @OnThread(value=Tag.FXPlatform)
    public Reflective getOuterClass() {
        int dotIndex;
        int dollarIndex = this.getName().lastIndexOf(36);
        if (dollarIndex != -1 && (dotIndex = this.getName().indexOf(46, dollarIndex)) == -1) {
            String outerName = this.getName().substring(0, dollarIndex);
            return this.getRelativeClass(outerName);
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract Reflective getInnerClass(String var1);

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isStatic();

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isPublic();

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isFinal();

    @OnThread(value=Tag.FXPlatform)
    public abstract Map<String, Set<MethodReflective>> getDeclaredMethods();

    @OnThread(value=Tag.FXPlatform)
    public abstract List<ConstructorReflective> getDeclaredConstructors();

    @OnThread(value=Tag.FXPlatform)
    public abstract Map<String, FieldReflective> getDeclaredFields();

    public abstract String getModuleName();
}

