/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

public class IntersectionType
extends GenTypeSolid {
    private GenTypeSolid[] intersectTypes;

    private IntersectionType(GenTypeSolid[] types) {
        if (types.length == 0) {
            throw new IllegalArgumentException();
        }
        this.intersectTypes = types;
    }

    @OnThread(value=Tag.FXPlatform)
    public static GenTypeSolid getIntersection(GenTypeSolid[] types) {
        if (types.length == 1) {
            return types[0];
        }
        ArrayList<GenTypeSolid> allTypes = new ArrayList<GenTypeSolid>(types.length);
        for (GenTypeSolid type : types) {
            for (GenTypeSolid itype : type.getIntersectionTypes()) {
                allTypes.add(itype);
            }
        }
        ArrayList<GenTypeSolid> nonclasstypes = new ArrayList<GenTypeSolid>();
        GenTypeClass classtype = null;
        for (int i = 0; i < types.length; ++i) {
            GenTypeClass tclass = types[i].asClass();
            if (tclass != null && !tclass.isInterface()) {
                if (classtype == null) {
                    classtype = tclass;
                    continue;
                }
                classtype = IntersectionType.combineClasses(tclass, classtype);
                continue;
            }
            nonclasstypes.add(types[i]);
        }
        if (classtype != null) {
            nonclasstypes.listIterator().add(classtype);
        }
        if (nonclasstypes.size() == 1) {
            return (GenTypeSolid)nonclasstypes.get(0);
        }
        return new IntersectionType(nonclasstypes.toArray(new GenTypeSolid[nonclasstypes.size()]));
    }

    @OnThread(value=Tag.FXPlatform)
    public static GenTypeSolid getIntersection(GenTypeSolid a, GenTypeSolid b) {
        return IntersectionType.getIntersection(new GenTypeSolid[]{a, b});
    }

    @OnThread(value=Tag.FXPlatform)
    public static GenTypeClass combineClasses(GenTypeClass a, GenTypeClass b) {
        GenTypeClass bE;
        GenTypeClass aE = a.getErasedType();
        if (!aE.equals(bE = b.getErasedType())) {
            if (aE.isAssignableFrom(bE)) {
                a = a.mapToDerived(bE.reflective);
            } else {
                b = b.mapToDerived(aE.reflective);
            }
        }
        if (a.isRaw()) {
            return b;
        }
        if (b.isRaw()) {
            return a;
        }
        GenTypeClass outer = null;
        if (a.outer != null) {
            outer = IntersectionType.combineClasses(a.outer, b.outer);
        }
        ArrayList<GenTypeParameter> newParams = null;
        if (a.params != null) {
            newParams = new ArrayList<GenTypeParameter>();
            Iterator<? extends GenTypeParameter> ia = a.params.iterator();
            Iterator<? extends GenTypeParameter> ib = b.params.iterator();
            while (ia.hasNext()) {
                GenTypeParameter tpa = ia.next();
                GenTypeParameter tpb = ib.next();
                newParams.add(tpa.precisify(tpb));
            }
        }
        return new GenTypeClass(a.reflective, newParams, outer);
    }

    @Override
    public String toString(NameTransform nt) {
        String xx = this.intersectTypes[0].toString();
        if (this.intersectTypes.length > 1 && xx.equals("java.lang.Object")) {
            return this.intersectTypes[1].toString(nt);
        }
        return this.intersectTypes[0].toString(nt);
    }

    @Override
    public String toTypeArgString(NameTransform nt) {
        return "? extends " + this.toString(nt);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    public GenTypeSolid[] getLowerBounds() {
        return new GenTypeSolid[]{this};
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public GenTypeSolid mapTparsToTypes(Map<String, ? extends GenTypeParameter> tparams) {
        GenTypeSolid[] newIsect = new GenTypeSolid[this.intersectTypes.length];
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            newIsect[i] = (GenTypeSolid)this.intersectTypes[i].mapTparsToTypes(tparams);
        }
        return new IntersectionType(newIsect);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean equals(JavaType other) {
        if (other == null) {
            return false;
        }
        if (other instanceof JavaType) {
            JavaType otherJT = other;
            return this.isAssignableFrom(otherJT) && otherJT.isAssignableFrom(this);
        }
        return false;
    }

    @Override
    public void getParamsFromTemplate(Map<String, GenTypeParameter> map, GenTypeParameter template) {
    }

    @Override
    public GenTypeParameter precisify(GenTypeParameter other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public String arrayComponentName() {
        return this.getErasedType().arrayComponentName();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getErasedType() {
        return this.intersectTypes[0].getErasedType();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isAssignableFrom(JavaType t) {
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            if (!this.intersectTypes[i].isAssignableFrom(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isAssignableFromRaw(JavaType t) {
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            if (!this.intersectTypes[i].isAssignableFromRaw(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void erasedSuperTypes(Set<Reflective> s) {
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            this.intersectTypes[i].erasedSuperTypes(s);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public GenTypeClass[] getReferenceSupertypes() {
        ArrayList<GenTypeClass> rsupTypes = new ArrayList<GenTypeClass>();
        for (int i = 0; i < this.intersectTypes.length; ++i) {
            GenTypeClass[] isTypes = this.intersectTypes[i].getReferenceSupertypes();
            for (int j = 0; j < isTypes.length; ++j) {
                rsupTypes.add(isTypes[j]);
            }
        }
        return rsupTypes.toArray(new GenTypeClass[rsupTypes.size()]);
    }

    @Override
    public GenTypeArray getArray() {
        return new GenTypeArray(this);
    }

    @Override
    public GenTypeSolid[] getIntersectionTypes() {
        return this.intersectTypes;
    }
}

