/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import bluej.utility.Debug;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ClassPathEntry {
    private static final String statusGood = Config.getString("classmgr.statusgood");
    private static final String statusBad = Config.getString("classmgr.statusbad");
    private static final String statusNew = Config.getString("classmgr.statusnew");
    private final File file;
    private final String description;
    private final boolean justAdded;

    public ClassPathEntry(String location, String description) {
        this(location, description, false);
    }

    public ClassPathEntry(File file, String description) {
        this.file = file;
        this.description = description;
        this.justAdded = false;
    }

    public ClassPathEntry(String location, String description, boolean isNew) {
        this.file = new File(location).getAbsoluteFile();
        this.description = description;
        this.justAdded = isNew;
    }

    public String getDescription() {
        if (this.description == null) {
            return Config.getString("classmgr.error.nodescription") + " (" + this.file.getPath() + ")";
        }
        return this.description;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getCanonicalPathNoException() {
        Object path;
        try {
            path = this.file.getCanonicalPath();
        }
        catch (IOException ioe) {
            path = Config.getString("classmgr.error.unresolvable") + " (" + this.file.getPath() + ")";
        }
        return path;
    }

    public URL safeGetURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            Debug.reportError("Bad class path entry: " + this.file, e);
            return null;
        }
    }

    public boolean isNew() {
        return this.justAdded;
    }

    public boolean isValid() {
        if (this.file.isDirectory()) {
            return true;
        }
        if (this.isJar()) {
            return this.file.canRead();
        }
        return false;
    }

    public String getStatusString() {
        if (!this.isValid()) {
            return statusBad;
        }
        if (this.isNew()) {
            return statusNew;
        }
        return statusGood;
    }

    public boolean isJar() {
        String name = this.file.getName().toLowerCase();
        return this.file.isFile() && (name.endsWith(".zip") || name.endsWith(".jar"));
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.file.equals(((ClassPathEntry)o).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

