/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.legacy.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import javax.xml.stream.XMLStreamException;
import org.apiguardian.api.API;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.reporting.legacy.xml.XmlReportData;
import org.junit.platform.reporting.legacy.xml.XmlReportWriter;

@API(status=API.Status.EXPERIMENTAL, since="1.4")
public class LegacyXmlReportGeneratingListener
implements TestExecutionListener {
    private final Path reportsDir;
    private final PrintWriter out;
    private final Clock clock;
    private XmlReportData reportData;

    public LegacyXmlReportGeneratingListener(Path reportsDir, PrintWriter out) {
        this(reportsDir, out, Clock.systemDefaultZone());
    }

    LegacyXmlReportGeneratingListener(String reportsDir, PrintWriter out, Clock clock) {
        this(Paths.get(reportsDir, new String[0]), out, clock);
    }

    private LegacyXmlReportGeneratingListener(Path reportsDir, PrintWriter out, Clock clock) {
        this.reportsDir = reportsDir;
        this.out = out;
        this.clock = clock;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.reportData = new XmlReportData(testPlan, this.clock);
        try {
            Files.createDirectories(this.reportsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.printException("Could not create reports directory: " + this.reportsDir, e);
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.reportData = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.reportData.markSkipped(testIdentifier, reason);
        this.writeXmlReportInCaseOfRoot(testIdentifier);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.reportData.markStarted(testIdentifier);
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.reportData.addReportEntry(testIdentifier, entry);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult result) {
        this.reportData.markFinished(testIdentifier, result);
        this.writeXmlReportInCaseOfRoot(testIdentifier);
    }

    private void writeXmlReportInCaseOfRoot(TestIdentifier testIdentifier) {
        if (this.isRoot(testIdentifier)) {
            String rootName = ((UniqueId.Segment)UniqueId.parse((String)testIdentifier.getUniqueId()).getSegments().get(0)).getValue();
            this.writeXmlReportSafely(testIdentifier, rootName);
        }
    }

    private void writeXmlReportSafely(TestIdentifier testIdentifier, String rootName) {
        Path xmlFile = this.reportsDir.resolve("TEST-" + rootName + ".xml");
        try (BufferedWriter fileWriter = Files.newBufferedWriter(xmlFile, new OpenOption[0]);){
            new XmlReportWriter(this.reportData).writeXmlReport(testIdentifier, fileWriter);
        }
        catch (IOException | XMLStreamException e) {
            this.printException("Could not write XML report: " + xmlFile, e);
        }
    }

    private boolean isRoot(TestIdentifier testIdentifier) {
        return !testIdentifier.getParentId().isPresent();
    }

    private void printException(String message, Exception exception) {
        this.out.println(message);
        exception.printStackTrace(this.out);
    }
}

