/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.SharedTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.control.Label;
import javafx.util.Duration;

public class ScalableHeightLabel
extends Label {
    private final SimpleDoubleProperty scale = new SimpleDoubleProperty(1.0);

    public ScalableHeightLabel(String text, boolean startHidden) {
        super(text);
        this.setMinHeight(0.0);
        if (startHidden) {
            this.setPrefHeight(0.0);
            this.scale.set(0.0);
        }
        this.scale.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number newVal) {
                ScalableHeightLabel.this.setPrefHeight(newVal.doubleValue() * ScalableHeightLabel.this.computePrefHeight(9999.0));
            }
        });
    }

    public void setToFullHeight() {
        this.scale.set(1.0);
    }

    public void setToNothing() {
        this.scale.set(0.0);
    }

    public Timeline getGrowToFullHeightTimeline(Duration dur) {
        return new Timeline(new KeyFrame[]{new KeyFrame(dur, new KeyValue[]{new KeyValue((WritableValue)this.scale, (Object)1.0)})});
    }

    public Timeline getShrinkToNothingTimeline(Duration dur) {
        return new Timeline(new KeyFrame[]{new KeyFrame(dur, new KeyValue[]{new KeyValue((WritableValue)this.scale, (Object)0.0)})});
    }

    public void growToFullHeightWith(SharedTransition t, boolean fade) {
        this.scale.bind((ObservableValue)t.getProgress());
        t.addOnStopped(() -> ((SimpleDoubleProperty)this.scale).unbind());
        if (fade) {
            this.opacityProperty().bind((ObservableValue)t.getProgress());
            t.addOnStopped(() -> ((DoubleProperty)this.opacityProperty()).unbind());
        }
    }

    public void shrinkToNothingWith(SharedTransition t, boolean fade) {
        this.scale.bind((ObservableValue)t.getOppositeProgress());
        t.addOnStopped(() -> ((SimpleDoubleProperty)this.scale).unbind());
        if (fade) {
            this.opacityProperty().bind((ObservableValue)t.getOppositeProgress());
            t.addOnStopped(() -> ((DoubleProperty)this.opacityProperty()).unbind());
        }
    }

    public double getBaselineOffset() {
        return super.getBaselineOffset() * this.scale.get();
    }
}

