/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.Config;
import bluej.editor.stride.CodeOverlayPane;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.WindowOverlayPane;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXBiConsumer;
import bluej.utility.javafx.FXCache;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXFunction;
import bluej.utility.javafx.FXPlatformBiFunction;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformFunction;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.FXSupplier;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JavaFXUtil {
    private static final FXCache<Font, FXCache<String, Double>> measured = new FXCache<Font, FXCache>(f -> new FXCache<String, Double>(s -> {
        if (s == null || s.length() == 0) {
            return 0.0;
        }
        Text text = new Text(s);
        text.setFont(f);
        return text.getLayoutBounds().getWidth();
    }, 10000), 3);

    public static void setPseudoclass(String pseudoClassName, boolean enabled, Node ... nodes) {
        if (!pseudoClassName.startsWith("bj-") && !pseudoClassName.startsWith("gf-")) {
            throw new IllegalArgumentException("Our pseudoclasses should begin with bj- or gf- to avoid confusion with JavaFX's pseudo classes");
        }
        for (Node node : nodes) {
            node.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)pseudoClassName), enabled);
        }
    }

    public static boolean hasPseudoclass(Styleable node, String pseudoClassName) {
        return node.getPseudoClassStates().stream().filter(p -> p.getPseudoClassName().equals(pseudoClassName)).count() > 0L;
    }

    public static void selectPseudoClass(Node node, int index, String ... pseudoClasses) {
        for (int i = 0; i < pseudoClasses.length; ++i) {
            JavaFXUtil.setPseudoclass(pseudoClasses[i], i == index, node);
        }
    }

    public static void addStyleClass(Styleable node, String ... styleClasses) {
        JavaFXUtil.addStyleClass(node, (ObservableList<String>)FXCollections.observableArrayList((Object[])styleClasses));
    }

    public static void addStyleClass(Styleable node, ObservableList<String> styleClasses) {
        for (String styleClass : styleClasses) {
            if (node.getStyleClass().contains((Object)styleClass)) continue;
            node.getStyleClass().add((Object)styleClass);
        }
    }

    public static <T extends Styleable> T withStyleClass(T node, String ... styleClasses) {
        JavaFXUtil.addStyleClass(node, styleClasses);
        return node;
    }

    public static void removeStyleClass(Styleable node, String ... styleClasses) {
        node.getStyleClass().removeAll((Object[])styleClasses);
    }

    public static double measureString(TextInputControl node, String str) {
        return JavaFXUtil.measureString(node, str, true, true);
    }

    public static double measureString(TextInputControl node, String str, boolean includeLeftInset, boolean includeRightInset) {
        return JavaFXUtil.measureString(node, str, node.getFont(), includeLeftInset, includeRightInset);
    }

    public static double measureString(TextInputControl node, String str, Font overrideFont, boolean includeLeftInset, boolean includeRightInset) {
        return measured.get(overrideFont).get(str) + (includeLeftInset ? node.getInsets().getLeft() : 0.0) + (includeRightInset ? node.getInsets().getRight() : 0.0);
    }

    public static double measureString(Labeled node, String str) {
        return measured.get(node.getFont()).get(str) + node.getLabelPadding().getLeft() + node.getLabelPadding().getRight() + node.getPadding().getLeft() + node.getPadding().getRight();
    }

    public static <T extends Styleable> CssMetaData<T, Number> cssSize(String propertyName, final Function<T, SimpleStyleableDoubleProperty> propGetter) {
        return new CssMetaData<T, Number>(propertyName, StyleConverter.getSizeConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Number> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Color> cssColor(String propertyName, final Function<T, SimpleStyleableObjectProperty<Color>> propGetter) {
        return new CssMetaData<T, Color>(propertyName, StyleConverter.getColorConverter()){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Color> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static <T extends Styleable> CssMetaData<T, Insets> cssInsets(String propertyName, final Function<T, StyleableObjectProperty<Insets>> propGetter) {
        return new CssMetaData<T, Insets>(propertyName, StyleConverter.getInsetsConverter(), Insets.EMPTY){

            public boolean isSettable(T node) {
                return true;
            }

            public StyleableProperty<Insets> getStyleableProperty(T node) {
                return (StyleableProperty)propGetter.apply(node);
            }
        };
    }

    public static void writeImageTo(WritableImage image, String filename) {
        File file = new File(filename);
        BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)image, null);
        try {
            ImageIO.write((RenderedImage)renderedImage, "png", file);
        }
        catch (IOException e) {
            Debug.reportError(e);
        }
    }

    public static void workAroundFunctionKeyBug(TextField field) {
        field.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
            switch (e.getCode()) {
                case F1: 
                case F2: 
                case F3: 
                case F4: 
                case F5: 
                case F6: 
                case F7: 
                case F8: 
                case F9: 
                case F10: 
                case F11: 
                case F12: {
                    Runnable r = (Runnable)field.getScene().getAccelerators().get((Object)new KeyCodeCombination(e.getCode(), new KeyCombination.Modifier[0]));
                    if (r == null) break;
                    r.run();
                    e.consume();
                    break;
                }
            }
        });
    }

    public static Label cloneLabel(Label l, ObservableValue<String> fontSize) {
        Label copy = new Label();
        copy.textProperty().bind((ObservableValue)l.textProperty());
        JavaFXUtil.bindList(copy.getStyleClass(), l.getStyleClass());
        copy.styleProperty().bind((ObservableValue)l.styleProperty().concat(fontSize));
        JavaFXUtil.bindPseudoclasses((Node)copy, (ObservableSet<PseudoClass>)l.getPseudoClassStates());
        return copy;
    }

    public static void blitImage(WritableImage dest, int xOffset, int yOffset, Image src) {
        dest.getPixelWriter().setPixels(xOffset, yOffset, (int)Math.ceil(src.getWidth()), (int)Math.ceil(src.getHeight()), src.getPixelReader(), 0, 0);
    }

    @OnThread(value=Tag.FXPlatform)
    public static <S, T> ObservableValue<T> applyPlatform(ObservableValue<S> object, FXPlatformFunction<S, ObservableValue<T>> property, T def) {
        SimpleObjectProperty r = new SimpleObjectProperty(object.getValue() == null ? def : property.apply(object.getValue()).getValue());
        JavaFXUtil.addChangeListenerPlatform(object, arg_0 -> JavaFXUtil.lambda$applyPlatform$4((ObjectProperty)r, def, property, arg_0));
        return r;
    }

    public static ReadOnlyBooleanProperty delay(ObservableBooleanValue source, final Duration delayToTrue, final Duration delayToFalse) {
        final SimpleBooleanProperty delayed = new SimpleBooleanProperty(source.get());
        source.addListener((ChangeListener)new ChangeListener<Boolean>(){
            private FXPlatformRunnable cancel = null;

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (this.cancel != null) {
                    this.cancel.run();
                }
                this.cancel = newValue != false ? JavaFXUtil.runAfter(delayToTrue, () -> delayed.set(true)) : JavaFXUtil.runAfter(delayToFalse, () -> delayed.set(false));
            }
        });
        return delayed;
    }

    @OnThread(value=Tag.FX)
    public static void ifOnPlatform(FXPlatformRunnable action) {
        if (Platform.isFxApplicationThread()) {
            ((Runnable)action::run).run();
        }
    }

    public static void addFocusListener(Stage focusTarget, FXPlatformConsumer<Boolean> listener) {
        focusTarget.focusedProperty().addListener((obs, oldVal, newVal) -> ((FXConsumer<Boolean>)listener::accept).accept((Boolean)newVal));
    }

    public static void addFocusListener(Node focusTarget, FXPlatformConsumer<Boolean> listener) {
        focusTarget.focusedProperty().addListener((obs, oldVal, newVal) -> ((FXConsumer<Boolean>)listener::accept).accept((Boolean)newVal));
    }

    @OnThread(value=Tag.Any)
    public static void runNowOrLater(FXPlatformRunnable action) {
        if (Platform.isFxApplicationThread()) {
            action.run();
        } else {
            Platform.runLater(action::run);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static boolean confirmDialog(String titleLabel, String messageLabel, Window parent, boolean bringToFront) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, Config.getString(messageLabel), new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        alert.setTitle(Config.getString(titleLabel));
        alert.setHeaderText(alert.getTitle());
        alert.initOwner(parent);
        alert.initModality(Modality.WINDOW_MODAL);
        if (bringToFront) {
            JavaFXUtil.listenOnce(alert.showingProperty(), showing -> {
                if (showing.booleanValue()) {
                    Utility.bringToFrontFX(alert.getDialogPane().getScene().getWindow());
                }
            });
        }
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        Optional pressed = alert.showAndWait();
        return ButtonType.OK == pressed.orElse(ButtonType.CANCEL);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void errorDialog(String titleLabel, String messageLabel) {
        Alert alert = new Alert(Alert.AlertType.ERROR, Config.getString(messageLabel), new ButtonType[]{ButtonType.OK});
        alert.setTitle(Config.getString(titleLabel));
        alert.setHeaderText(alert.getTitle());
        alert.showAndWait();
    }

    public static void bindPseudoclass(Node node, String pseudoClass, BooleanExpression on) {
        JavaFXUtil.setPseudoclass(pseudoClass, on.get(), node);
        JavaFXUtil.addChangeListener(on, b -> JavaFXUtil.setPseudoclass(pseudoClass, b, node));
    }

    public static void scrollTo(ScrollPane scrollPane, Node target) {
        double scrollWidth = scrollPane.getContent().getBoundsInLocal().getWidth();
        double scrollHeight = scrollPane.getContent().getBoundsInLocal().getHeight();
        Bounds b = scrollPane.getContent().sceneToLocal(target.localToScene(target.getBoundsInLocal()));
        Bounds viewPortBounds = scrollPane.getViewportBounds();
        if (scrollPane.getHbarPolicy() != ScrollPane.ScrollBarPolicy.NEVER && scrollWidth != 0.0) {
            double hValue = (b.getMinX() - 0.5 * viewPortBounds.getWidth()) / (scrollWidth - viewPortBounds.getWidth());
            scrollPane.setHvalue(hValue < 0.0 ? 0.0 : (hValue > 1.0 ? 1.0 : hValue));
        }
        if (scrollPane.getVbarPolicy() != ScrollPane.ScrollBarPolicy.NEVER && scrollHeight != 0.0) {
            double vValue = (b.getMinY() - 0.5 * viewPortBounds.getHeight()) / (scrollHeight - viewPortBounds.getHeight());
            scrollPane.setVvalue(vValue < 0.0 ? 0.0 : (vValue > 1.0 ? 1.0 : vValue));
        }
    }

    @OnThread(value=Tag.Any)
    public static <T> T initFX(FXSupplier<T> initCode) {
        return (T)((Supplier<Object>)initCode::get).get();
    }

    public static void scalePolygonPoints(Polygon polygon, double scale, boolean rotate90) {
        for (int i = 0; i < polygon.getPoints().size(); i += 2) {
            if (rotate90) {
                double t = (Double)polygon.getPoints().get(i + 1) * scale;
                polygon.getPoints().set(i + 1, (Object)((Double)polygon.getPoints().get(i) * scale));
                polygon.getPoints().set(i, (Object)t);
                continue;
            }
            polygon.getPoints().set(i, (Object)((Double)polygon.getPoints().get(i) * scale));
            polygon.getPoints().set(i + 1, (Object)((Double)polygon.getPoints().get(i + 1) * scale));
        }
    }

    public static PrinterJob createPrinterJob() {
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job == null) {
            for (Printer printer : Printer.getAllPrinters()) {
                job = PrinterJob.createPrinterJob((Printer)printer);
                if (job == null) continue;
                return job;
            }
        }
        return job;
    }

    @OnThread(value=Tag.FX)
    public static void expandScrollPaneContent(ScrollPane scrollPane) {
        JavaFXUtil.addChangeListener(scrollPane.viewportBoundsProperty(), bounds -> {
            boolean oldFitToWidth = scrollPane.isFitToWidth();
            boolean oldFitToHeight = scrollPane.isFitToHeight();
            scrollPane.setFitToWidth(scrollPane.getContent().prefWidth(-1.0) < bounds.getWidth());
            scrollPane.setFitToHeight(scrollPane.getContent().prefHeight(-1.0) < bounds.getHeight());
            if (scrollPane.getContent() instanceof Region && (oldFitToWidth != scrollPane.isFitToWidth() || oldFitToHeight != scrollPane.isFitToHeight())) {
                ((Region)scrollPane.getContent()).requestLayout();
            }
        });
    }

    public static Image loadImage(File image) {
        if (image != null) {
            try {
                return new Image(image.toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                Debug.reportError(e);
            }
        }
        return null;
    }

    public static Image loadImage(String path) {
        return path == null ? null : JavaFXUtil.loadImage(new File(path));
    }

    public static MenuItem makeMenuItem(String nameKey, ImageView icon, KeyCombination accelerator, FXPlatformRunnable action, ObservableValue<Boolean> binding) {
        MenuItem item = JavaFXUtil.makeMenuItem(nameKey, accelerator, action, binding);
        item.setGraphic((Node)icon);
        return item;
    }

    public static MenuItem makeMenuItem(String nameKey, KeyCombination accelerator, FXPlatformRunnable action, ObservableValue<Boolean> binding) {
        MenuItem item = JavaFXUtil.makeMenuItem(Config.getString(nameKey), action, accelerator);
        if (binding != null) {
            item.disableProperty().bind(binding);
        }
        return item;
    }

    public static void runAfterNextLayout(final Scene scene, final FXPlatformRunnable runnable) {
        if (scene != null) {
            scene.addPostLayoutPulseListener(new Runnable(){

                @Override
                public void run() {
                    JavaFXUtil.runPlatformLater(runnable);
                    scene.removePostLayoutPulseListener((Runnable)this);
                }
            });
        }
    }

    public static void addMacMinimiseShortcutHandler(Stage window) {
        window.getScene().addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (Config.isMacOS() && e.getCode() == KeyCode.M && e.isMetaDown() && !e.isShiftDown()) {
                window.setIconified(true);
            }
        });
    }

    public static boolean containsScenePoint(Node node, double sceneX, double sceneY) {
        return node.localToScene(node.getBoundsInLocal()).contains(sceneX, sceneY);
    }

    public static ListBuilder<CssMetaData<? extends Styleable, ?>> extendCss(List<CssMetaData<? extends Styleable, ?>> superClassCssMetaData) {
        return new ListBuilder(superClassCssMetaData);
    }

    public static void listenForContextMenu(Node node, FXPlatformBiFunction<Double, Double, Boolean> showContextMenu, KeyCode ... otherKeys) {
        EventHandler popupHandler = e -> {
            if (e.isPopupTrigger() && ((Boolean)showContextMenu.apply(e.getScreenX(), e.getScreenY())).booleanValue()) {
                e.consume();
            }
        };
        node.addEventHandler(javafx.scene.input.MouseEvent.MOUSE_PRESSED, popupHandler);
        node.addEventHandler(javafx.scene.input.MouseEvent.MOUSE_RELEASED, popupHandler);
        node.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            Scene scene;
            Point2D scenePt;
            Point2D screenPt;
            if ((e.getCode() == KeyCode.CONTEXT_MENU || Arrays.asList(otherKeys).contains(e.getCode())) && ((Boolean)showContextMenu.apply((screenPt = (scenePt = node.localToScene(5.0, 5.0)).add((scene = node.getScene()).getWindow().getX() + scene.getX(), scene.getWindow().getY() + scene.getY())).getX(), screenPt.getY())).booleanValue()) {
                e.consume();
            }
        });
    }

    public static MenuItem makeMenuItem(String text, FXPlatformRunnable run, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        if (run != null) {
            item.setOnAction(e -> run.run());
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static MenuItem makeMenuItem(StringExpression text, FXPlatformRunnable run, KeyCombination shortcut) {
        MenuItem item = new MenuItem();
        item.textProperty().bind((ObservableValue)text);
        if (run != null) {
            item.setOnAction(e -> run.run());
        }
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static MenuItem makeDisabledMenuItem(String text, KeyCombination shortcut) {
        MenuItem item = new MenuItem(text);
        item.setDisable(true);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    public static CheckMenuItem makeCheckMenuItem(String text, Property<Boolean> state, KeyCombination shortcut) {
        CheckMenuItem item = new CheckMenuItem(text);
        item.selectedProperty().bindBidirectional(state);
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        return item;
    }

    @OnThread(value=Tag.FXPlatform)
    public static CheckMenuItem makeCheckMenuItem(String text, Property<Boolean> state, KeyCombination shortcut, FXPlatformConsumer<? super Boolean> listener) {
        CheckMenuItem item = new CheckMenuItem(text);
        item.setSelected(((Boolean)state.getValue()).booleanValue());
        if (shortcut != null) {
            item.setAccelerator(shortcut);
        }
        JavaFXUtil.addChangeListenerPlatform(item.selectedProperty(), selected -> {
            if (!selected.equals(state.getValue())) {
                state.setValue(selected);
                listener.accept((Boolean)selected);
            }
        });
        JavaFXUtil.addChangeListenerPlatform(state, newValue -> item.setSelected(newValue.booleanValue()));
        return item;
    }

    public static Menu makeMenu(String text, MenuItem ... items) {
        Menu menu = new Menu(text);
        menu.getItems().setAll((Object[])items);
        return menu;
    }

    public static void initializeCustomTooltipCatalogue(final FXTabbedEditor window, Node target, String tooltipText, final Duration delay) {
        final Label l = new Label(tooltipText);
        l.visibleProperty().bind((ObservableValue)l.textProperty().isNotEmpty());
        l.setMouseTransparent(true);
        l.setWrapText(true);
        JavaFXUtil.addStyleClass((Styleable)l, "frame-tooltip");
        JavaFXUtil.setPseudoclass("bj-tight-border", true, new Node[]{l});
        l.setMaxWidth(300.0);
        final FXRunnable show = () -> {
            WindowOverlayPane overlayPane = window.getOverlayPane();
            double x = overlayPane.sceneXToWindowOverlayX(target.localToScene(target.getBoundsInLocal()).getMinX());
            double y = overlayPane.sceneYToWindowOverlayY(target.localToScene(target.getBoundsInLocal()).getMaxY() + 10.0);
            overlayPane.addOverlay((Node)l, (ObservableDoubleValue)new ReadOnlyDoubleWrapper(x), (ObservableDoubleValue)new ReadOnlyDoubleWrapper(y), true);
            FadeTransition ft = new FadeTransition(Duration.millis((double)100.0), (Node)l);
            ft.setFromValue(0.0);
            ft.setToValue(1.0);
            ft.play();
        };
        target.addEventFilter(javafx.scene.input.MouseEvent.ANY, (EventHandler)new EventHandler<javafx.scene.input.MouseEvent>(){
            FXPlatformRunnable cancel;

            @OnThread(value=Tag.FXPlatform)
            public void handle(javafx.scene.input.MouseEvent event) {
                if (event.getEventType() == javafx.scene.input.MouseEvent.MOUSE_ENTERED) {
                    this.cancel = JavaFXUtil.runAfter(delay, show);
                } else if (event.getEventType() == javafx.scene.input.MouseEvent.MOUSE_EXITED) {
                    if (this.cancel != null) {
                        this.cancel.run();
                        this.cancel = null;
                    }
                    window.getOverlayPane().removeOverlay((Node)l);
                }
            }
        });
    }

    public static void initializeCustomHelp(InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip, boolean onHoverToo) {
        TooltipListener listener = new TooltipListener(editor, parent, requestTooltip);
        parent.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)listener);
        JavaFXUtil.addFocusListener(parent, (FXPlatformConsumer<Boolean>)listener);
        if (onHoverToo) {
            parent.addEventHandler(javafx.scene.input.MouseEvent.MOUSE_ENTERED, (EventHandler)listener);
            parent.addEventHandler(javafx.scene.input.MouseEvent.MOUSE_EXITED, (EventHandler)listener);
        }
    }

    public static void onceInScene(Node node, FXPlatformRunnable action) {
        JavaFXUtil.onceBecomesNotNull(node.sceneProperty(), s -> action.run());
    }

    @OnThread(value=Tag.FXPlatform)
    public static <T6> void onceNotNull(ObservableValue<T6> observable, FXPlatformConsumer<T6> callback) {
        Object t = observable.getValue();
        if (t != null) {
            callback.accept(t);
            return;
        }
        JavaFXUtil.onceBecomesNotNull(observable, callback);
    }

    @OnThread(value=Tag.FX)
    public static <T> void onceBecomesNotNull(ObservableValue<T> observable, final FXPlatformConsumer<T> callback) {
        ChangeListener listener = new ChangeListener<T>(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends T> observable, T oldValue, T newVal) {
                if (newVal != null) {
                    callback.accept(newVal);
                    observable.removeListener((ChangeListener)this);
                }
            }
        };
        observable.addListener(listener);
    }

    @OnThread(value=Tag.FXPlatform)
    public static void onceTrue(ObservableValue<Boolean> observable, final FXPlatformConsumer<Boolean> callback) {
        boolean value = (Boolean)observable.getValue();
        if (value) {
            callback.accept(value);
            return;
        }
        ChangeListener<Boolean> listener = new ChangeListener<Boolean>(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newVal) {
                if (newVal.booleanValue()) {
                    callback.accept(newVal);
                    observable.removeListener((ChangeListener)this);
                }
            }
        };
        observable.addListener((ChangeListener)listener);
    }

    public static <SRC2, DEST2> void bindMap(final List<DEST2> dest, final ObservableList<SRC2> src, final Function<SRC2, DEST2> func, final FXConsumer<FXRunnable> changeWrapper) {
        changeWrapper.accept(() -> {
            dest.clear();
            dest.addAll(Utility.mapList(src, func));
        });
        src.addListener(new ListChangeListener<SRC2>(){

            public void onChanged(ListChangeListener.Change<? extends SRC2> changes) {
                changeWrapper.accept(() -> {
                    while (changes.next()) {
                        int i;
                        if (changes.wasPermutated() || changes.wasUpdated()) {
                            for (i = changes.getFrom(); i < changes.getTo(); ++i) {
                                dest.set(i, func.apply(src.get(i)));
                            }
                            continue;
                        }
                        for (i = 0; i < changes.getRemovedSize(); ++i) {
                            dest.remove(changes.getFrom());
                        }
                        for (i = 0; i < changes.getAddedSubList().size(); ++i) {
                            dest.add(i + changes.getFrom(), func.apply(changes.getAddedSubList().get(i)));
                        }
                    }
                });
            }
        });
    }

    public static <T> ObservableList<T> listBool(BooleanExpression putInList, List<T> items) {
        ObservableList r = FXCollections.observableArrayList();
        if (putInList.get()) {
            r.setAll(items);
        }
        putInList.addListener((a, b, newVal) -> {
            if (newVal.booleanValue()) {
                r.setAll((Collection)items);
            } else {
                r.clear();
            }
        });
        return r;
    }

    public static <T> ObservableList<T> listBool(BooleanExpression putInList, T item) {
        return JavaFXUtil.listBool(putInList, List.of(item));
    }

    public static <T> FXRunnable addSelfRemovingListener(final ObservableValue<T> prop, final FXConsumer<T> callback) {
        ChangeListener l = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                callback.accept(newValue);
                prop.removeListener((ChangeListener)this);
            }
        };
        prop.addListener(l);
        return () -> JavaFXUtil.lambda$addSelfRemovingListener$21(prop, (ChangeListener)l);
    }

    @OnThread(value=Tag.FXPlatform)
    public static <T> FXPlatformRunnable listenOnce(final ObservableValue<T> prop, final FXPlatformConsumer<T> callback) {
        ChangeListener l = new ChangeListener<T>(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                callback.accept(newValue);
                prop.removeListener((ChangeListener)this);
            }
        };
        prop.addListener(l);
        return () -> JavaFXUtil.lambda$listenOnce$22(prop, (ChangeListener)l);
    }

    public static <T> FXRunnable bindList(ObservableList<? super T> dest, ObservableList<T> src) {
        ListChangeListener obs = c -> dest.setAll((Collection)src);
        src.addListener(obs);
        dest.setAll(src);
        return () -> src.removeListener(obs);
    }

    public static <T> FXRunnable addChangeListener(ObservableValue<T> property, FXConsumer<? super T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> listener.accept(newVal);
        property.addListener(wrapped);
        return () -> property.removeListener(wrapped);
    }

    public static <T> FXRunnable addChangeListenerAndCallNow(ObservableValue<T> property, FXConsumer<? super T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> listener.accept(newVal);
        property.addListener(wrapped);
        listener.accept(property.getValue());
        return () -> property.removeListener(wrapped);
    }

    @OnThread(value=Tag.FX)
    public static <T> FXPlatformRunnable addChangeListenerPlatform(ObservableValue<T> property, FXPlatformConsumer<T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> listener.accept(newVal);
        property.addListener(wrapped);
        return () -> property.removeListener(wrapped);
    }

    @OnThread(value=Tag.FXPlatform)
    public static <T> FXPlatformRunnable addChangeListenerPlatformAndCallNow(ObservableValue<T> property, FXPlatformConsumer<T> listener) {
        ChangeListener wrapped = (a, b, newVal) -> listener.accept(newVal);
        property.addListener(wrapped);
        listener.accept(property.getValue());
        return () -> property.removeListener(wrapped);
    }

    public static FXRunnable sequence(FXRunnable ... actions) {
        return () -> Arrays.stream(actions).forEach(FXRunnable::run);
    }

    @OnThread(value=Tag.FXPlatform)
    public static FXPlatformRunnable runAfter(Duration delay, FXPlatformRunnable task) {
        if (delay.lessThanOrEqualTo(Duration.ZERO)) {
            task.run();
            return () -> {};
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(delay, arg_0 -> JavaFXUtil.lambda$runAfter$35((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(1);
        timeline.play();
        return () -> JavaFXUtil.lambda$runAfter$36((BooleanProperty)okToRun, timeline);
    }

    public static FXRunnable runRegular(Duration interval, FXPlatformRunnable task) {
        if (interval.lessThanOrEqualTo(Duration.ZERO)) {
            throw new IllegalArgumentException("Cannot run at a regular interval of zero or less");
        }
        SimpleBooleanProperty okToRun = new SimpleBooleanProperty(true);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(interval, arg_0 -> JavaFXUtil.lambda$runRegular$37((BooleanProperty)okToRun, task, arg_0), new KeyValue[0])});
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(false);
        timeline.play();
        return () -> JavaFXUtil.lambda$runRegular$38((BooleanProperty)okToRun, timeline);
    }

    public static DragType getDragModifiers(javafx.scene.input.MouseEvent event) {
        boolean forceCopy = Config.isMacOS() ? event.isAltDown() : event.isShortcutDown();
        boolean forceMove = event.isShiftDown();
        if (forceCopy) {
            return DragType.FORCE_COPYING;
        }
        if (forceMove) {
            return DragType.FORCE_MOVING;
        }
        return DragType.DEFAULT;
    }

    public static void bindPseudoclasses(Node to, ObservableSet<PseudoClass> from) {
        from.addListener(c -> {
            if (c.wasAdded()) {
                to.pseudoClassStateChanged((PseudoClass)c.getElementAdded(), true);
            }
            if (c.wasRemoved()) {
                to.pseudoClassStateChanged((PseudoClass)c.getElementRemoved(), false);
            }
        });
        from.forEach(c -> to.pseudoClassStateChanged(c, true));
    }

    @OnThread(value=Tag.Swing)
    public static FXPlatformSupplier<MenuBar> swingMenuBarToFX(JMenuBar swingMenu, Object eventSource) {
        ArrayList<FXPlatformSupplier<Menu>> menus = new ArrayList<FXPlatformSupplier<Menu>>();
        for (int i = 0; i < swingMenu.getMenuCount(); ++i) {
            JMenu menu = swingMenu.getMenu(i);
            menus.add(JavaFXUtil.swingMenuToFX(menu, eventSource, (a, b) -> {}));
        }
        return () -> {
            MenuBar menuBar = new MenuBar();
            for (FXPlatformSupplier menuFXSupplier : menus) {
                menuBar.getMenus().add((Object)((Menu)menuFXSupplier.get()));
            }
            return menuBar;
        };
    }

    @OnThread(value=Tag.Swing)
    private static FXPlatformSupplier<Menu> swingMenuToFX(JMenu swingMenu, Object source, FXBiConsumer<JMenuItem, MenuItem> extraConvert) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (int i = 0; i < swingMenu.getItemCount(); ++i) {
            items.add(swingMenu.getItem(i));
        }
        String swingMenuTitle = swingMenu.getText();
        return JavaFXUtil.swingMenuToFX(items, source, () -> new Menu(swingMenuTitle), extraConvert);
    }

    @OnThread(value=Tag.Swing)
    public static FXPlatformSupplier<Menu> swingMenuToFX(List<JMenuItem> swingMenuItems, Object source, FXPlatformSupplier<Menu> createMenu, FXBiConsumer<JMenuItem, MenuItem> extraConvert) {
        ArrayList<FXPlatformSupplier<Object>> items = new ArrayList<FXPlatformSupplier<Object>>();
        ArrayList onShow = new ArrayList();
        for (JMenuItem item : swingMenuItems) {
            if (item == null) {
                items.add(JavaFXUtil.createMenuSeparator());
                continue;
            }
            if (item instanceof JMenu) {
                items.add(JavaFXUtil.swingMenuToFX((JMenu)item, source, extraConvert));
                continue;
            }
            FXPlatformSupplier<MenuItemAndShow> menuItemAndShowFXSupplier = JavaFXUtil.swingMenuItemToFX(item, source);
            FXPlatformSupplier<MenuItem> menuItemFXSupplier = () -> {
                MenuItemAndShow itemAndShow = (MenuItemAndShow)menuItemAndShowFXSupplier.get();
                if (itemAndShow.onShow != null) {
                    onShow.add(itemAndShow.onShow);
                }
                extraConvert.accept(item, itemAndShow.menuItem);
                return itemAndShow.menuItem;
            };
            items.add(menuItemFXSupplier);
        }
        return () -> {
            Menu menu = (Menu)createMenu.get();
            for (FXPlatformSupplier menuItemFXSupplier : items) {
                menu.getItems().add((Object)((MenuItem)menuItemFXSupplier.get()));
            }
            menu.setOnShowing(e -> onShow.forEach(FXPlatformRunnable::run));
            return menu;
        };
    }

    @OnThread(value=Tag.Any)
    private static FXPlatformSupplier<? extends MenuItem> createMenuSeparator() {
        return () -> new SeparatorMenuItem();
    }

    @OnThread(value=Tag.Swing)
    private static FXPlatformSupplier<MenuItemAndShow> swingMenuItemToFX(JMenuItem swingItem, Object source) {
        String menuText = swingItem.getText();
        KeyStroke shortcut = swingItem.getAccelerator();
        if (swingItem instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem checkBoxMenuItem = (JCheckBoxMenuItem)swingItem;
            boolean selected = checkBoxMenuItem.isSelected();
            return () -> {
                CheckMenuItem item = new CheckMenuItem(menuText);
                item.setSelected(selected);
                item.setOnAction(e -> {
                    int x = (int)item.getParentPopup().getX();
                    int y = (int)item.getParentPopup().getY();
                    SwingUtilities.invokeLater(() -> {
                        checkBoxMenuItem.setSelected(!checkBoxMenuItem.isSelected());
                        JavaFXUtil.fireSwingMenuItemAction(swingItem, source, x, y);
                    });
                });
                item.setAccelerator(JavaFXUtil.swingKeyStrokeToFX(shortcut));
                FXRunnable getStatus = () -> SwingUtilities.invokeLater(() -> {
                    boolean curSelected = checkBoxMenuItem.isSelected();
                    Platform.runLater(() -> item.setSelected(curSelected));
                });
                SwingUtilities.invokeLater(() -> swingItem.addPropertyChangeListener("enabled", e2 -> {
                    boolean enabled = swingItem.isEnabled();
                    Platform.runLater(() -> item.setDisable(!enabled));
                }));
                return new MenuItemAndShow((MenuItem)item, getStatus);
            };
        }
        if (swingItem instanceof JRadioButtonMenuItem) {
            throw new UnsupportedOperationException();
        }
        boolean startsEnabled = swingItem.isEnabled();
        MenuItem item = ((BiFunction<String, Boolean, MenuItem>)JavaFXUtil::makeFXMenuItem).apply(menuText, startsEnabled);
        swingItem.addPropertyChangeListener("enabled", e2 -> {
            boolean enabled = swingItem.isEnabled();
            Platform.runLater(() -> item.setDisable(!enabled));
        });
        swingItem.addPropertyChangeListener("action", e2 -> {
            boolean enabled = swingItem.isEnabled();
            String label = swingItem.getText();
            Platform.runLater(() -> {
                item.setDisable(!enabled);
                item.setText(label);
            });
        });
        return () -> {
            item.setOnAction(e -> {
                ContextMenu menu = item.getParentPopup();
                int x = menu != null ? (int)menu.getX() : 0;
                int y = menu != null ? (int)menu.getY() : 0;
                SwingUtilities.invokeLater(() -> JavaFXUtil.fireSwingMenuItemAction(swingItem, source, x, y));
            });
            item.setAccelerator(JavaFXUtil.swingKeyStrokeToFX(shortcut));
            return new MenuItemAndShow(item);
        };
    }

    @OnThread(value=Tag.Swing)
    private static void fireSwingMenuItemAction(JMenuItem swingItem, Object source, final int x, final int y) {
        String menuText = swingItem.getText();
        for (MouseListener mouseListener : swingItem.getMouseListeners()) {
            mouseListener.mousePressed(new MouseEvent(new Component(){

                @Override
                public Point getLocationOnScreen() {
                    return new Point(x, y);
                }
            }, 0, 0L, 0, 0, 0, 1, false));
        }
        Action action = swingItem.getAction();
        if (action != null) {
            action.actionPerformed(new ActionEvent(source, 0, menuText));
        } else {
            Arrays.stream(swingItem.getActionListeners()).forEach(a -> a.actionPerformed(new ActionEvent(source, 0, menuText)));
        }
    }

    private static MenuItem makeFXMenuItem(String menuText, boolean startsEnabled) {
        MenuItem item = new MenuItem(menuText);
        item.setDisable(!startsEnabled);
        return item;
    }

    private static KeyCombination swingKeyStrokeToFX(AWTKeyStroke shortcut) {
        KeyCode code;
        if (shortcut == null) {
            return null;
        }
        int modifiers = shortcut.getModifiers();
        ArrayList<KeyCombination.Modifier> fxModifiers = new ArrayList<KeyCombination.Modifier>();
        if ((modifiers & 0x40) != 0) {
            fxModifiers.add(KeyCombination.SHIFT_DOWN);
        }
        if ((modifiers & 0x80) != 0) {
            fxModifiers.add(KeyCombination.CONTROL_DOWN);
        }
        if ((modifiers & 0x100) != 0) {
            fxModifiers.add(KeyCombination.META_DOWN);
        }
        if ((code = JavaFXUtil.awtKeyCodeToFX(shortcut.getKeyCode())) != null) {
            return new KeyCodeCombination(code, fxModifiers.toArray(new KeyCombination.Modifier[0]));
        }
        return null;
    }

    public static KeyCode awtKeyCodeToFX(int code) {
        switch (code) {
            case 65: {
                return KeyCode.A;
            }
            case 66: {
                return KeyCode.B;
            }
            case 67: {
                return KeyCode.C;
            }
            case 68: {
                return KeyCode.D;
            }
            case 69: {
                return KeyCode.E;
            }
            case 70: {
                return KeyCode.F;
            }
            case 71: {
                return KeyCode.G;
            }
            case 72: {
                return KeyCode.H;
            }
            case 73: {
                return KeyCode.I;
            }
            case 74: {
                return KeyCode.J;
            }
            case 75: {
                return KeyCode.K;
            }
            case 76: {
                return KeyCode.L;
            }
            case 77: {
                return KeyCode.M;
            }
            case 78: {
                return KeyCode.N;
            }
            case 79: {
                return KeyCode.O;
            }
            case 80: {
                return KeyCode.P;
            }
            case 81: {
                return KeyCode.Q;
            }
            case 82: {
                return KeyCode.R;
            }
            case 83: {
                return KeyCode.S;
            }
            case 84: {
                return KeyCode.T;
            }
            case 85: {
                return KeyCode.U;
            }
            case 86: {
                return KeyCode.V;
            }
            case 87: {
                return KeyCode.W;
            }
            case 88: {
                return KeyCode.X;
            }
            case 89: {
                return KeyCode.Y;
            }
            case 90: {
                return KeyCode.Z;
            }
            case 48: {
                return KeyCode.DIGIT0;
            }
            case 49: {
                return KeyCode.DIGIT1;
            }
            case 50: {
                return KeyCode.DIGIT2;
            }
            case 51: {
                return KeyCode.DIGIT3;
            }
            case 52: {
                return KeyCode.DIGIT4;
            }
            case 53: {
                return KeyCode.DIGIT5;
            }
            case 54: {
                return KeyCode.DIGIT6;
            }
            case 55: {
                return KeyCode.DIGIT7;
            }
            case 56: {
                return KeyCode.DIGIT8;
            }
            case 57: {
                return KeyCode.DIGIT9;
            }
            case 96: {
                return KeyCode.NUMPAD0;
            }
            case 97: {
                return KeyCode.NUMPAD1;
            }
            case 98: {
                return KeyCode.NUMPAD2;
            }
            case 99: {
                return KeyCode.NUMPAD3;
            }
            case 100: {
                return KeyCode.NUMPAD4;
            }
            case 101: {
                return KeyCode.NUMPAD5;
            }
            case 102: {
                return KeyCode.NUMPAD6;
            }
            case 103: {
                return KeyCode.NUMPAD7;
            }
            case 104: {
                return KeyCode.NUMPAD8;
            }
            case 105: {
                return KeyCode.NUMPAD9;
            }
            case 112: {
                return KeyCode.F1;
            }
            case 113: {
                return KeyCode.F2;
            }
            case 114: {
                return KeyCode.F3;
            }
            case 115: {
                return KeyCode.F4;
            }
            case 116: {
                return KeyCode.F5;
            }
            case 117: {
                return KeyCode.F6;
            }
            case 118: {
                return KeyCode.F7;
            }
            case 119: {
                return KeyCode.F8;
            }
            case 120: {
                return KeyCode.F9;
            }
            case 121: {
                return KeyCode.F10;
            }
            case 122: {
                return KeyCode.F11;
            }
            case 123: {
                return KeyCode.F12;
            }
            case 61440: {
                return KeyCode.F13;
            }
            case 61441: {
                return KeyCode.F14;
            }
            case 61442: {
                return KeyCode.F15;
            }
            case 61443: {
                return KeyCode.F16;
            }
            case 61444: {
                return KeyCode.F17;
            }
            case 61445: {
                return KeyCode.F18;
            }
            case 61446: {
                return KeyCode.F19;
            }
            case 61447: {
                return KeyCode.F20;
            }
            case 61448: {
                return KeyCode.F21;
            }
            case 61449: {
                return KeyCode.F22;
            }
            case 61450: {
                return KeyCode.F23;
            }
            case 61451: {
                return KeyCode.F24;
            }
            case 30: {
                return KeyCode.ACCEPT;
            }
            case 107: {
                return KeyCode.ADD;
            }
            case 65481: {
                return KeyCode.AGAIN;
            }
            case 256: {
                return KeyCode.ALL_CANDIDATES;
            }
            case 240: {
                return KeyCode.ALPHANUMERIC;
            }
            case 150: {
                return KeyCode.AMPERSAND;
            }
            case 151: {
                return KeyCode.ASTERISK;
            }
            case 512: {
                return KeyCode.AT;
            }
            case 192: {
                return KeyCode.BACK_QUOTE;
            }
            case 92: {
                return KeyCode.BACK_SLASH;
            }
            case 8: {
                return KeyCode.BACK_SPACE;
            }
            case 65368: {
                return KeyCode.BEGIN;
            }
            case 161: {
                return KeyCode.BRACELEFT;
            }
            case 162: {
                return KeyCode.BRACERIGHT;
            }
            case 3: {
                return KeyCode.CANCEL;
            }
            case 20: {
                return KeyCode.CAPS;
            }
            case 514: {
                return KeyCode.CIRCUMFLEX;
            }
            case 12: {
                return KeyCode.CLEAR;
            }
            case 93: {
                return KeyCode.CLOSE_BRACKET;
            }
            case 258: {
                return KeyCode.CODE_INPUT;
            }
            case 513: {
                return KeyCode.COLON;
            }
            case 44: {
                return KeyCode.COMMA;
            }
            case 65485: {
                return KeyCode.COPY;
            }
            case 65489: {
                return KeyCode.CUT;
            }
            case 110: {
                return KeyCode.DECIMAL;
            }
            case 127: {
                return KeyCode.DELETE;
            }
            case 111: {
                return KeyCode.DIVIDE;
            }
            case 515: {
                return KeyCode.DOLLAR;
            }
            case 40: {
                return KeyCode.DOWN;
            }
            case 35: {
                return KeyCode.END;
            }
            case 10: {
                return KeyCode.ENTER;
            }
            case 61: {
                return KeyCode.EQUALS;
            }
            case 27: {
                return KeyCode.ESCAPE;
            }
            case 516: {
                return KeyCode.EURO_SIGN;
            }
            case 517: {
                return KeyCode.EXCLAMATION_MARK;
            }
            case 24: {
                return KeyCode.FINAL;
            }
            case 65488: {
                return KeyCode.FIND;
            }
            case 243: {
                return KeyCode.FULL_WIDTH;
            }
            case 160: {
                return KeyCode.GREATER;
            }
            case 244: {
                return KeyCode.HALF_WIDTH;
            }
            case 156: {
                return KeyCode.HELP;
            }
            case 242: {
                return KeyCode.HIRAGANA;
            }
            case 36: {
                return KeyCode.HOME;
            }
            case 155: {
                return KeyCode.INSERT;
            }
            case 263: {
                return KeyCode.INPUT_METHOD_ON_OFF;
            }
            case 518: {
                return KeyCode.INVERTED_EXCLAMATION_MARK;
            }
            case 260: {
                return KeyCode.JAPANESE_HIRAGANA;
            }
            case 259: {
                return KeyCode.JAPANESE_KATAKANA;
            }
            case 261: {
                return KeyCode.JAPANESE_ROMAN;
            }
            case 21: {
                return KeyCode.KANA;
            }
            case 262: {
                return KeyCode.KANA_LOCK;
            }
            case 25: {
                return KeyCode.KANJI;
            }
            case 241: {
                return KeyCode.KATAKANA;
            }
            case 225: {
                return KeyCode.KP_DOWN;
            }
            case 226: {
                return KeyCode.KP_LEFT;
            }
            case 227: {
                return KeyCode.KP_RIGHT;
            }
            case 224: {
                return KeyCode.KP_UP;
            }
            case 37: {
                return KeyCode.LEFT;
            }
            case 519: {
                return KeyCode.LEFT_PARENTHESIS;
            }
            case 153: {
                return KeyCode.LESS;
            }
            case 157: {
                return KeyCode.META;
            }
            case 45: {
                return KeyCode.MINUS;
            }
            case 31: {
                return KeyCode.MODECHANGE;
            }
            case 106: {
                return KeyCode.MULTIPLY;
            }
            case 29: {
                return KeyCode.NONCONVERT;
            }
            case 144: {
                return KeyCode.NUM_LOCK;
            }
            case 520: {
                return KeyCode.NUMBER_SIGN;
            }
            case 91: {
                return KeyCode.OPEN_BRACKET;
            }
            case 34: {
                return KeyCode.PAGE_DOWN;
            }
            case 33: {
                return KeyCode.PAGE_UP;
            }
            case 65487: {
                return KeyCode.PASTE;
            }
            case 19: {
                return KeyCode.PAUSE;
            }
            case 46: {
                return KeyCode.PERIOD;
            }
            case 521: {
                return KeyCode.PLUS;
            }
            case 257: {
                return KeyCode.PREVIOUS_CANDIDATE;
            }
            case 154: {
                return KeyCode.PRINTSCREEN;
            }
            case 65482: {
                return KeyCode.PROPS;
            }
            case 222: {
                return KeyCode.QUOTE;
            }
            case 152: {
                return KeyCode.QUOTEDBL;
            }
            case 39: {
                return KeyCode.RIGHT;
            }
            case 522: {
                return KeyCode.RIGHT_PARENTHESIS;
            }
            case 245: {
                return KeyCode.ROMAN_CHARACTERS;
            }
            case 145: {
                return KeyCode.SCROLL_LOCK;
            }
            case 59: {
                return KeyCode.SEMICOLON;
            }
            case 108: {
                return KeyCode.SEPARATOR;
            }
            case 47: {
                return KeyCode.SLASH;
            }
            case 32: {
                return KeyCode.SPACE;
            }
            case 65480: {
                return KeyCode.STOP;
            }
            case 109: {
                return KeyCode.SUBTRACT;
            }
            case 9: {
                return KeyCode.TAB;
            }
            case 523: {
                return KeyCode.UNDERSCORE;
            }
            case 65483: {
                return KeyCode.UNDO;
            }
            case 38: {
                return KeyCode.UP;
            }
        }
        Debug.message("Unknown key code: " + code);
        return null;
    }

    public static <T, R> ObjectBinding<R> of(ObservableValue<T> t, FXFunction<T, R> accessor) {
        return Bindings.createObjectBinding(() -> accessor.apply(t.getValue()), (Observable[])new Observable[]{t});
    }

    public static <T> DoubleBinding ofD(ObservableValue<T> t, FXFunction<T, Double> accessor) {
        return Bindings.createDoubleBinding(() -> (Double)accessor.apply(t.getValue()), (Observable[])new Observable[]{t});
    }

    @OnThread(value=Tag.FXPlatform)
    public static void runAfterCurrent(FXPlatformRunnable r) {
        ((FXPlatformConsumer<Runnable>)Platform::runLater).accept(r::run);
    }

    @OnThread(value=Tag.FX)
    public static void runPlatformLater(FXPlatformRunnable r) {
        Platform.runLater(r::run);
    }

    public static void stripeRect(GraphicsContext g, int x, int y, int width, int height, int separation, int thickness, boolean backslash, Color color) {
        Paint prev = g.getStroke();
        g.setStroke((Paint)color);
        g.setLineWidth((double)thickness);
        for (int offset = separation / 2; offset < width + height; offset += separation + thickness) {
            int y2;
            int x2;
            int y1;
            int x1;
            if (offset < height) {
                x1 = x;
                y1 = y + offset;
            } else {
                x1 = x + offset - height;
                y1 = y + height;
            }
            if (offset < width) {
                x2 = x + offset;
                y2 = y;
            } else {
                x2 = x + width;
                y2 = y + offset - width;
            }
            if (backslash) {
                x1 = width - x1;
                x2 = width - x2;
            }
            g.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
        }
        g.setStroke(prev);
    }

    public static Image createImage(int width, int height, FXConsumer<GraphicsContext> draw) {
        Canvas c = new Canvas((double)width, (double)height);
        Scene s = new Scene((Parent)new StackPane(new Node[]{c}));
        draw.accept(c.getGraphicsContext2D());
        WritableImage image = new WritableImage(width, height);
        SnapshotParameters p = new SnapshotParameters();
        p.setFill((Paint)Color.TRANSPARENT);
        c.snapshot(p, image);
        return image;
    }

    private static /* synthetic */ void lambda$runRegular$38(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runRegular$37(BooleanProperty okToRun, FXPlatformRunnable task, javafx.event.ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$runAfter$36(BooleanProperty okToRun, Timeline timeline) {
        okToRun.set(false);
        timeline.stop();
    }

    private static /* synthetic */ void lambda$runAfter$35(BooleanProperty okToRun, FXPlatformRunnable task, javafx.event.ActionEvent e) {
        if (okToRun.get()) {
            task.run();
        }
    }

    private static /* synthetic */ void lambda$listenOnce$22(ObservableValue prop, ChangeListener l) {
        prop.removeListener(l);
    }

    private static /* synthetic */ void lambda$addSelfRemovingListener$21(ObservableValue prop, ChangeListener l) {
        prop.removeListener(l);
    }

    private static /* synthetic */ void lambda$applyPlatform$4(ObjectProperty r, Object def, FXPlatformFunction property, Object value) {
        r.unbind();
        if (value == null) {
            r.setValue(def);
        } else {
            r.bind((ObservableValue)property.apply(value));
        }
    }

    private static class MenuItemAndShow {
        private final MenuItem menuItem;
        private final FXRunnable onShow;

        public MenuItemAndShow(MenuItem menuItem, FXRunnable onShow) {
            this.menuItem = menuItem;
            this.onShow = onShow;
        }

        public MenuItemAndShow(MenuItem menuItem) {
            this(menuItem, null);
        }
    }

    public static class FXOnlyMenu
    implements SwingOrFXMenu {
        private final Menu fxMenu;

        @OnThread(value=Tag.Any)
        public FXOnlyMenu(Menu fxMenu) {
            this.fxMenu = fxMenu;
        }

        @Override
        @OnThread(value=Tag.Swing)
        public FXPlatformSupplier<Menu> getFXMenu(Object eventSource) {
            return () -> this.fxMenu;
        }
    }

    public static class SwingMenu
    implements SwingOrFXMenu {
        private final JMenu swingMenu;

        @OnThread(value=Tag.Any)
        public SwingMenu(JMenu swingMenu) {
            this.swingMenu = swingMenu;
        }

        @Override
        @OnThread(value=Tag.Swing)
        public FXPlatformSupplier<Menu> getFXMenu(Object eventSource) {
            return JavaFXUtil.swingMenuToFX(this.swingMenu, eventSource, (a, b) -> {});
        }
    }

    public static interface SwingOrFXMenu {
        @OnThread(value=Tag.Swing)
        public FXPlatformSupplier<Menu> getFXMenu(Object var1);
    }

    public static enum DragType {
        FORCE_COPYING,
        FORCE_MOVING,
        DEFAULT;

    }

    @OnThread(value=Tag.FXPlatform)
    private static class TooltipListener
    implements EventHandler<InputEvent>,
    FXPlatformConsumer<Boolean> {
        private Label l;
        private final InteractionManager editor;
        private final Node parent;
        private final FXConsumer<FXConsumer<String>> requestTooltip;
        private FXPlatformRunnable cancelHoverShow = null;
        private boolean showing = false;
        private boolean mouseShown = false;

        @OnThread(value=Tag.FX)
        private TooltipListener(InteractionManager editor, Node parent, FXConsumer<FXConsumer<String>> requestTooltip) {
            this.editor = editor;
            this.parent = parent;
            this.requestTooltip = requestTooltip;
        }

        @OnThread(value=Tag.FXPlatform)
        public void handle(InputEvent original) {
            if (original instanceof KeyEvent) {
                KeyEvent event = (KeyEvent)original;
                if (event.getCode() == KeyCode.F1 && !this.showing) {
                    this.mouseShown = false;
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    this.show();
                    event.consume();
                }
                if (event.getCode() == KeyCode.ESCAPE && this.showing && !this.mouseShown) {
                    this.hide();
                }
            } else if (original instanceof javafx.scene.input.MouseEvent) {
                javafx.scene.input.MouseEvent event = (javafx.scene.input.MouseEvent)original;
                if (event.getEventType() == javafx.scene.input.MouseEvent.MOUSE_ENTERED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (!this.showing) {
                        this.cancelHoverShow = JavaFXUtil.runAfter(Duration.millis((double)1000.0), () -> {
                            this.mouseShown = true;
                            this.show();
                        });
                    }
                } else if (event.getEventType() == javafx.scene.input.MouseEvent.MOUSE_EXITED) {
                    if (this.cancelHoverShow != null) {
                        this.cancelHoverShow.run();
                        this.cancelHoverShow = null;
                    }
                    if (this.showing && this.mouseShown) {
                        this.hide();
                    }
                }
            }
        }

        @OnThread(value=Tag.FXPlatform)
        private void show() {
            if (this.showing) {
                this.hide();
            }
            this.l = new Label();
            this.l.visibleProperty().bind((ObservableValue)this.l.textProperty().isNotEmpty());
            this.l.setMouseTransparent(true);
            this.l.setWrapText(true);
            JavaFXUtil.addStyleClass((Styleable)this.l, "frame-tooltip");
            this.requestTooltip.accept(arg_0 -> ((Label)this.l).setText(arg_0));
            this.editor.getCodeOverlayPane().addOverlay((Node)this.l, this.parent, null, (DoubleExpression)this.l.heightProperty().negate().subtract(5.0), CodeOverlayPane.WidthLimit.LIMIT_WIDTH_AND_SLIDE_LEFT);
            this.showing = true;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void accept(Boolean newVal) {
            if (!newVal.booleanValue() && this.showing && !this.mouseShown) {
                this.hide();
            }
        }

        @OnThread(value=Tag.FXPlatform)
        private void hide() {
            if (this.showing) {
                this.editor.getCodeOverlayPane().removeOverlay((Node)this.l);
                this.l = null;
                this.showing = false;
            }
        }
    }

    public static class ListBuilder<T> {
        private ArrayList<T> list;

        private ListBuilder(List<T> list) {
            this.list = new ArrayList<T>(list);
        }

        public ListBuilder<T> add(T t) {
            this.list.add(t);
            return this;
        }

        public List<T> build() {
            return Collections.unmodifiableList(this.list);
        }
    }
}

