/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.util.Duration;

public class CircleCountdown
extends Canvas {
    private final SimpleDoubleProperty time = new SimpleDoubleProperty(1.0);
    private final Timeline timeline;

    public CircleCountdown(double size, Color strokeColor, Duration duration) {
        super(size, size);
        this.timeline = new Timeline(20.0, new KeyFrame[]{new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.time, (Object)0)})});
        FXConsumer<Number> update = t -> {
            GraphicsContext gc = this.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, size, size);
            gc.setStroke((Paint)strokeColor);
            gc.setLineWidth(3.0);
            gc.strokeArc(size * 0.5, size * 0.5, size * 0.5 - 4.0, size * 0.5 - 4.0, 90.0, t.doubleValue() * 360.0, ArcType.OPEN);
        };
        update.accept(1.0);
        JavaFXUtil.addChangeListener(this.time, update);
        this.timeline.play();
    }

    public void addOnFinished(FXRunnable action) {
        JavaFXUtil.addChangeListener(this.time, t -> {
            if (t.doubleValue() == 0.0) {
                action.run();
            }
        });
    }

    public void stop() {
        this.timeline.stop();
    }
}

