/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class FXWorker {
    private Object value;
    private ThreadVar threadVar;

    public FXWorker() {
        Runnable doConstruct = new Runnable(){

            @Override
            @OnThread(value=Tag.Worker, ignoreParent=true)
            public void run() {
                try {
                    FXWorker.this.setValue(FXWorker.this.construct());
                }
                finally {
                    FXWorker.this.threadVar.clear();
                }
                Platform.runLater(() -> FXWorker.this.finished());
            }
        };
        Thread t = new Thread(doConstruct, "FXWorker");
        this.threadVar = new ThreadVar(t);
    }

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    @OnThread(value=Tag.Worker)
    public abstract Object construct();

    @OnThread(value=Tag.FXPlatform)
    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract void abort();

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

