/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.utility.DBoxLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DBox
extends JPanel {
    private float defaultAlignment;
    private int axis;
    private boolean xAxisBounded;
    private boolean yAxisBounded;
    public static final int X_AXIS = DBoxLayout.X_AXIS;
    public static final int Y_AXIS = DBoxLayout.Y_AXIS;

    public DBox(int axis, float alignmentVal) {
        this.setLayout(new DBoxLayout(axis));
        this.defaultAlignment = alignmentVal;
        this.axis = axis;
    }

    public DBox(int axis, int minSpacing, int prefSpacing, float alignmentVal) {
        this.setLayout(new DBoxLayout(axis, minSpacing, prefSpacing));
        this.defaultAlignment = alignmentVal;
        this.axis = axis;
    }

    public void addAligned(JComponent c) {
        if (this.axis == Y_AXIS) {
            c.setAlignmentX(this.defaultAlignment);
        } else {
            c.setAlignmentY(this.defaultAlignment);
        }
        this.add(c);
    }

    public void setAxisBounded(int axis, boolean bounded) {
        if (axis == X_AXIS) {
            this.xAxisBounded = bounded;
        } else if (axis == Y_AXIS) {
            this.yAxisBounded = bounded;
        }
    }

    public Component addSpacer(int size) {
        Dimension d;
        JPanel spacer = new JPanel();
        spacer.setBorder(null);
        if (this.axis == X_AXIS) {
            d = new Dimension(size, 0);
            spacer.setMaximumSize(d);
            spacer.setPreferredSize(d);
        } else {
            d = new Dimension(0, size);
            spacer.setMaximumSize(d);
            spacer.setPreferredSize(d);
        }
        Dimension min = new Dimension(0, 0);
        spacer.setMinimumSize(min);
        this.add(spacer);
        return spacer;
    }

    @Override
    public Dimension getMaximumSize() {
        if (!this.xAxisBounded && !this.yAxisBounded) {
            return super.getMaximumSize();
        }
        if (this.xAxisBounded && this.yAxisBounded) {
            return this.getPreferredSize();
        }
        Dimension d = super.getMaximumSize();
        Dimension p = this.getPreferredSize();
        if (this.xAxisBounded) {
            d.width = p.width;
        } else {
            d.height = p.height;
        }
        return d;
    }
}

