/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerTerminal;
import bluej.debugmgr.ExecutionEvent;
import bluej.editor.Editor;
import bluej.editor.base.BaseEditorPane;
import bluej.editor.base.LineContainer;
import bluej.editor.base.LineDisplay;
import bluej.editor.base.TextLine;
import bluej.editor.flow.FlowEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.print.PrintProgressDialog;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.ExceptionSourceLocation;
import bluej.terminal.InputBuffer;
import bluej.terminal.TerminalTextPane;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class Terminal
implements BlueJEventListener,
DebuggerTerminal {
    private static final int MAX_BUFFER_LINES = 200;
    private static final List<String> STDOUT_OUTPUT = Collections.singletonList("terminal-output");
    private static final List<String> STDOUT_INPUT = Collections.singletonList("terminal-input");
    private static final List<String> STDOUT_METHOD_RECORDING = Collections.singletonList("terminal-method-record");
    private static final List<String> STDERR_NORMAL = Collections.singletonList("terminal-error");
    private static final List<String> STDERR_LINKED_STACK_TRACE = Collections.singletonList("terminal-stack-link");
    private static final List<String> STDERR_FOREIGN_STACK_TRACE = Collections.singletonList("terminal-stack-foreign");
    private static final String WINDOWTITLE = Config.getApplicationName() + ": " + Config.getString("terminal.title");
    private static final String RECORDMETHODCALLSPROPNAME = "bluej.terminal.recordcalls";
    private static final String CLEARONMETHODCALLSPROPNAME = "bluej.terminal.clearscreen";
    private static final String UNLIMITEDBUFFERINGCALLPROPNAME = "bluej.terminal.buffering";
    private final String title;
    private final Project project;
    private final TerminalTextPane text;
    private TerminalTextPane errorText;
    private final TextField input;
    private final SplitPane splitPane;
    private boolean isActive = false;
    private static BooleanProperty recordMethodCalls = Config.getPropBooleanProperty("bluej.terminal.recordcalls");
    private static BooleanProperty clearOnMethodCall = Config.getPropBooleanProperty("bluej.terminal.clearscreen");
    private static BooleanProperty unlimitedBufferingCall = Config.getPropBooleanProperty("bluej.terminal.buffering");
    private boolean newMethodCall = true;
    private boolean errorShown = false;
    private final InputBuffer buffer;
    private final BooleanProperty showingProperty = new SimpleBooleanProperty(false);
    private final @OnThread(value=Tag.Any) Reader in = new TerminalReader();
    private final @OnThread(value=Tag.Any) Writer out = new TerminalWriter(false);
    private final @OnThread(value=Tag.Any) Writer err = new TerminalWriter(true);
    private Stage window;

    public Terminal(Project project) {
        this.title = WINDOWTITLE + " - " + project.getProjectName();
        this.project = project;
        this.buffer = new InputBuffer(65536);
        this.text = new TerminalTextPane(){

            @Override
            public void focusPrevious() {
                if (Terminal.this.errorText != null) {
                    Terminal.this.errorText.requestFocusAndShowCaret();
                } else {
                    Terminal.this.input.requestFocus();
                }
            }

            @Override
            public void focusNext() {
                if (!Terminal.this.input.isDisable()) {
                    Terminal.this.input.requestFocus();
                } else if (Terminal.this.errorText != null) {
                    Terminal.this.errorText.requestFocusAndShowCaret();
                }
            }
        };
        this.text.getStyleClass().add((Object)"terminal-output");
        this.text.addSelectionListener((caret, anchor) -> {
            if (this.errorText != null && this.errorText.getCaretEditorPosition().getPosition() != this.errorText.getAnchorEditorPosition().getPosition()) {
                this.errorText.deselect();
            }
        });
        JavaFXUtil.addChangeListenerPlatform(unlimitedBufferingCall, unlimited -> {
            if (!unlimited.booleanValue()) {
                this.text.trimToMostRecentNLines(200);
            }
        });
        this.input = new TextField();
        this.input.getStyleClass().add((Object)"terminal-input-field");
        this.input.setOnAction(e -> {
            this.sendInput(false);
            e.consume();
        });
        this.input.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(true));
        this.input.setEditable(false);
        JavaFXUtil.addChangeListenerAndCallNow(this.input.editableProperty(), newVal -> {
            this.input.setDisable(newVal == false);
            this.input.setPromptText(newVal != false ? Config.getString("terminal.running") : Config.getString("terminal.notRunning"));
        });
        Nodes.addInputMap((Node)this.input, (InputMap)InputMap.sequence((InputMap[])new InputMap[]{InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.D, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), e -> {
            this.sendInput(true);
            e.consume();
        }), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), e -> {
            this.sendInput(true);
            e.consume();
        }), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> Utility.increaseFontSize(PrefMgr.getEditorFontSize())), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> Utility.decreaseFontSize(PrefMgr.getEditorFontSize())), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), e -> PrefMgr.getEditorFontSize().set(10)), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN})), e -> this.text.requestFocusAndShowCaret()), InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[0])), e -> (this.errorText != null ? this.errorText : this.text).requestFocusAndShowCaret())}));
        this.splitPane = new SplitPane(new Node[]{new BorderPane((Node)this.text, null, null, (Node)this.input, null)});
        JavaFXUtil.addStyleClass((Styleable)this.splitPane, "terminal-split");
        BorderPane mainPanel = new BorderPane();
        mainPanel.setCenter((Node)this.splitPane);
        mainPanel.setTop((Node)this.makeMenuBar());
        this.window = new Stage();
        this.window.setWidth(500.0);
        this.window.setHeight(500.0);
        BlueJTheme.setWindowIconFX(this.window);
        this.window.setTitle(this.title);
        Scene scene = new Scene((Parent)mainPanel);
        Config.addTerminalStylesheets(scene);
        this.window.setScene(scene);
        JavaFXUtil.addMacMinimiseShortcutHandler(this.window);
        scene.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (scene.getFocusOwner() == null && e.getCode() == KeyCode.TAB) {
                e.consume();
                if (e.isShiftDown() && this.errorText != null) {
                    this.errorText.requestFocusAndShowCaret();
                } else {
                    this.text.requestFocusAndShowCaret();
                }
            }
        });
        this.window.setOnCloseRequest(e -> {
            e.consume();
            if (project != null && project.getDebugger().getStatus() == 3) {
                return;
            }
            this.showHide(false);
        });
        this.window.setOnShown(e -> this.showingProperty.set(true));
        this.window.setOnHidden(e -> this.showingProperty.set(false));
        JavaFXUtil.addChangeListenerPlatform(this.showingProperty, this::showHide);
        Config.loadAndTrackPositionAndSize((Window)this.window, "bluej.terminal");
        BlueJEvent.addListener(this);
    }

    private void doCopy() {
        if (this.errorText != null && this.errorText.getCaretEditorPosition().getPosition() != this.errorText.getAnchorEditorPosition().getPosition()) {
            this.errorText.copy();
        } else if (this.text.getCaretEditorPosition().getPosition() != this.text.getAnchorEditorPosition().getPosition()) {
            this.text.copy();
        }
    }

    private void sendInput(boolean eof) {
        String inputString = this.input.getText() + (eof ? "" : "\n");
        this.buffer.putString(inputString);
        if (eof) {
            this.buffer.signalEOF();
        } else {
            this.buffer.notifyReaders();
        }
        this.input.clear();
        this.writeToPane(this.text, inputString, STDOUT_INPUT);
    }

    public void showHide(boolean show) {
        DataCollector.showHideTerminal(this.project, show);
        if (show) {
            this.window.show();
            this.input.requestFocus();
        } else {
            this.window.hide();
        }
    }

    public void dispose() {
        this.showHide(false);
        this.window = null;
    }

    public boolean isShown() {
        return this.window.isShowing();
    }

    public void activate(boolean active) {
        if (active != this.isActive) {
            this.input.setEditable(active);
            this.isActive = active;
        }
    }

    public void clear() {
        this.text.clear();
        if (this.errorText != null) {
            this.errorText.clear();
        }
        this.hideErrorPane();
    }

    public void save() {
        File fileName = FileUtility.getSaveFileFX((Window)this.window, Config.getString("terminal.save.title"), null, false);
        if (fileName != null) {
            if (fileName.exists() && DialogManager.askQuestionFX((Window)this.window, "error-file-exists") != 0) {
                return;
            }
            try {
                FileWriter writer = new FileWriter(fileName);
                String output = String.join((CharSequence)System.lineSeparator(), this.text.getLines());
                writer.write(output);
                writer.close();
            }
            catch (IOException ex) {
                DialogManager.showErrorFX((Window)this.window, "error-save-file");
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void print() {
        final PrinterJob job = JavaFXUtil.createPrinterJob();
        if (job == null) {
            DialogManager.showErrorFX((Window)this.window, "print-no-printers");
        } else if (job.showPrintDialog((Window)this.window)) {
            final List<List<TextLine.StyledSegment>> lines = this.text.getStyledLines();
            final BorderPane root = new BorderPane();
            Scene scene = new Scene((Parent)root);
            Config.addTerminalStylesheets(scene);
            double pixelWidth = job.getJobSettings().getPageLayout().getPrintableWidth();
            double pixelHeight = job.getJobSettings().getPageLayout().getPrintableHeight();
            root.resize(pixelWidth, pixelHeight);
            final LineDisplay lineDisplay = new LineDisplay((DoubleExpression)new ReadOnlyDoubleWrapper(0.0), (StringExpression)new ReadOnlyStringWrapper(""), false, (BaseEditorPane.BaseEditorPaneListener)new FlowEditor.OffScreenFlowEditorPaneListener());
            final LineContainer lineContainer = new LineContainer(lineDisplay, true);
            root.setCenter((Node)lineContainer);
            root.requestLayout();
            root.layout();
            root.applyCss();
            final PrintProgressDialog printProgressDialog = new PrintProgressDialog((Window)this.window, false);
            new Thread(new Runnable(){

                @Override
                @OnThread(value=Tag.FX, ignoreParent=true)
                public void run() {
                    FlowEditor.printPages((PrinterJob)job, (Node)root, n -> {}, (LineContainer)lineContainer, (LineDisplay)lineDisplay, (List)lines, (boolean)false, (Editor.PrintProgressUpdate)printProgressDialog.getWithinFileUpdater());
                    job.endJob();
                    printProgressDialog.finished();
                }
            }, "Print text").start();
            printProgressDialog.showAndWait();
        }
    }

    private void writeToPane(TerminalTextPane pane, String s, List<String> cssClasses) {
        int n;
        this.prepare();
        if (this.errorText != null && pane == this.errorText) {
            this.showErrorPane();
        }
        if ((n = s.lastIndexOf(12)) != -1) {
            this.clear();
            s = s.substring(n + 1);
        }
        pane.append(new TextLine.StyledSegment(cssClasses, s));
        if (this.errorText != null && pane != this.errorText && !unlimitedBufferingCall.get()) {
            pane.trimToMostRecentNLines(200);
        }
        pane.scrollToEnd();
    }

    private void prepare() {
        if (this.newMethodCall) {
            this.showHide(true);
            this.newMethodCall = false;
        } else if (Config.isGreenfoot() && !this.window.isShowing()) {
            this.showHide(true);
        }
    }

    private void methodCall(String callString) {
        this.newMethodCall = false;
        if (clearOnMethodCall.get()) {
            this.clear();
        }
        if (recordMethodCalls.get()) {
            this.text.append(new TextLine.StyledSegment(STDOUT_METHOD_RECORDING, callString + "\n"));
        }
        this.newMethodCall = true;
    }

    public boolean clearOnMethodCall() {
        return clearOnMethodCall.getValue();
    }

    private void constructorCall(InvokerRecord ir) {
        this.newMethodCall = false;
        if (clearOnMethodCall.get()) {
            this.clear();
        }
        if (recordMethodCalls.get()) {
            String callString = ir.getResultTypeString() + " " + ir.getResultName() + " = " + ir.toExpression() + ";";
            this.text.append(new TextLine.StyledSegment(STDOUT_METHOD_RECORDING, callString + "\n"));
        }
        this.newMethodCall = true;
    }

    private void methodResult(ExecutionEvent event) {
        if (recordMethodCalls.get()) {
            Object result = null;
            String resultType = event.getResult();
            if (resultType == "Normal exit") {
                DebuggerObject object = event.getResultObject();
                if (object != null) {
                    if (event.getClassName() != null && event.getMethodName() == null) {
                        return;
                    }
                    if (object.isNullObject()) {
                        return;
                    }
                    DebuggerField resultField = object.getField(0);
                    result = "    returned " + resultField.getType().toString(true) + " ";
                    result = (String)result + resultField.getValueString();
                }
            } else if (resultType == "An exception occurred") {
                result = "    Exception occurred.";
            } else if (resultType == "User terminated") {
                result = "    VM terminated.";
            }
            if (result != null) {
                this.text.append(new TextLine.StyledSegment(STDOUT_METHOD_RECORDING, (String)result + "\n"));
            }
        }
    }

    private void scanForStackTrace() {
        try {
            List<String> allLines = this.errorText.getLines();
            Pattern fileAndLine = Pattern.compile("at (\\S+)\\((\\S+)\\.java:(\\d+)\\)");
            Pattern noSource = Pattern.compile("at \\S+\\((Native Method|Unknown Source)\\)");
            for (int i = 0; i < allLines.size(); ++i) {
                String line = allLines.get(i);
                Matcher m = fileAndLine.matcher(line);
                while (m.find()) {
                    String fullyQualifiedMethodName = m.group(1);
                    String javaFile = m.group(2);
                    int lineNumber = Integer.parseInt(m.group(3));
                    String fullyQualifiedClassName = JavaNames.getPrefix(fullyQualifiedMethodName);
                    String packageName = JavaNames.getPrefix(fullyQualifiedClassName);
                    Package pkg = this.project.getPackage(packageName);
                    if (pkg != null && pkg.getAllClassnames().contains(javaFile)) {
                        this.errorText.setStyleForLineSegment(i, m.start(1), m.end(), STDERR_LINKED_STACK_TRACE, new ExceptionSourceLocation(m.start(1), m.end(), pkg, javaFile, lineNumber));
                        continue;
                    }
                    this.errorText.setStyleForLineSegment(i, m.start(), m.end(), STDERR_FOREIGN_STACK_TRACE, null);
                }
                m = noSource.matcher(line);
                while (m.find()) {
                    this.errorText.setStyleForLineSegment(i, m.start(), m.end(), STDERR_FOREIGN_STACK_TRACE, null);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.errorText.refreshDisplay();
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Reader getReader() {
        return this.in;
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Writer getWriter() {
        return this.out;
    }

    @Override
    @OnThread(value=Tag.Any)
    public void showOnInput() {
        Platform.runLater(() -> {
            if (!this.isShown()) {
                this.showHide(true);
            }
            if (this.isShown()) {
                Utility.bringToFrontFX((Window)this.window);
                this.input.requestFocus();
            }
        });
    }

    @Override
    @OnThread(value=Tag.Any, ignoreParent=true)
    public @OnThread(value=Tag.Any, ignoreParent=true) Writer getErrorWriter() {
        return this.err;
    }

    @Override
    public void blueJEvent(int eventId, Object arg, Project prj) {
        if (eventId == 3 && this.project == prj) {
            InvokerRecord ir = (InvokerRecord)arg;
            if (ir.getResultName() != null) {
                this.constructorCall(ir);
            } else {
                boolean isVoid = ir.hasVoidResult();
                if (isVoid) {
                    this.methodCall(ir.toStatement());
                } else {
                    this.methodCall(ir.toExpression());
                }
            }
        } else if (eventId == 5) {
            this.methodResult((ExecutionEvent)arg);
        }
    }

    private void showErrorPane() {
        if (this.errorShown) {
            return;
        }
        if (this.errorText == null) {
            this.errorText = new TerminalTextPane(){

                @Override
                public void focusPrevious() {
                    if (!Terminal.this.input.isDisable()) {
                        Terminal.this.input.requestFocus();
                    } else {
                        Terminal.this.text.requestFocusAndShowCaret();
                    }
                }

                @Override
                public void focusNext() {
                    Terminal.this.text.requestFocusAndShowCaret();
                }
            };
            this.errorText.getStyleClass().add((Object)"terminal-error");
            this.errorText.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(true));
            this.errorText.addSelectionListener((caret, anchor) -> {
                if (this.text != null && this.text.getCaretEditorPosition().getPosition() != this.text.getAnchorEditorPosition().getPosition()) {
                    this.text.deselect();
                }
            });
            this.errorText.addTextChangeListener(this::scanForStackTrace);
        }
        this.splitPane.getItems().add((Object)this.errorText);
        Config.rememberDividerPosition((Window)this.window, this.splitPane, "bluej.terminal.dividerpos");
        this.errorShown = true;
    }

    private void hideErrorPane() {
        if (!this.errorShown) {
            return;
        }
        this.splitPane.getItems().remove((Object)this.errorText);
        this.errorShown = false;
    }

    public BooleanProperty showingProperty() {
        return this.showingProperty;
    }

    private MenuBar makeMenuBar() {
        MenuBar menubar = new MenuBar();
        menubar.setUseSystemMenuBar(true);
        Menu menu = new Menu(Config.getString("terminal.options"));
        MenuItem clearItem = new MenuItem(Config.getString("terminal.clear"));
        clearItem.setOnAction(e -> this.clear());
        clearItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        MenuItem copyItem = new MenuItem(Config.getString("terminal.copy"));
        copyItem.setOnAction(e -> this.doCopy());
        copyItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        MenuItem saveItem = new MenuItem(Config.getString("terminal.save"));
        saveItem.setOnAction(e -> this.save());
        saveItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        MenuItem printItem = new MenuItem(Config.getString("terminal.print"));
        printItem.setOnAction(e -> this.print());
        printItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menu.getItems().addAll((Object[])new MenuItem[]{clearItem, copyItem, saveItem, printItem, new SeparatorMenuItem()});
        CheckMenuItem autoClear = new CheckMenuItem(Config.getString("terminal.clearScreen"));
        autoClear.selectedProperty().bindBidirectional((Property)clearOnMethodCall);
        CheckMenuItem recordCalls = new CheckMenuItem(Config.getString("terminal.recordCalls"));
        recordCalls.selectedProperty().bindBidirectional((Property)recordMethodCalls);
        CheckMenuItem unlimitedBuffering = new CheckMenuItem(Config.getString("terminal.buffering"));
        unlimitedBuffering.selectedProperty().bindBidirectional((Property)unlimitedBufferingCall);
        menu.getItems().addAll((Object[])new MenuItem[]{autoClear, recordCalls, unlimitedBuffering});
        MenuItem closeItem = new MenuItem(Config.getString("terminal.close"));
        closeItem.setOnAction(e -> this.showHide(false));
        closeItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), closeItem});
        menubar.getMenus().add((Object)menu);
        return menubar;
    }

    public Stage getWindow() {
        return this.window;
    }

    public void cleanup() {
        BlueJEvent.removeListener(this);
    }

    @OnThread(value=Tag.Any)
    private class TerminalWriter
    extends Writer {
        private boolean isErrorOut;

        TerminalWriter(boolean isError) {
            this.isErrorOut = isError;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            try {
                CompletableFuture written = new CompletableFuture();
                Platform.runLater(() -> {
                    try {
                        String s = new String(cbuf, off, len);
                        if (this.isErrorOut) {
                            Terminal.this.showErrorPane();
                            Terminal.this.writeToPane(Terminal.this.errorText, s, STDERR_NORMAL);
                        } else {
                            Terminal.this.writeToPane(Terminal.this.text, s, STDOUT_OUTPUT);
                        }
                    }
                    catch (Throwable t) {
                        Debug.reportError(t);
                    }
                    finally {
                        written.complete(true);
                    }
                });
                written.get(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ie) {
                Debug.reportError(ie);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    @OnThread(value=Tag.Any)
    private class TerminalReader
    extends Reader {
        private TerminalReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            int charsRead;
            for (charsRead = 0; charsRead < len; ++charsRead) {
                cbuf[off + charsRead] = Terminal.this.buffer.getChar();
                if (!Terminal.this.buffer.isEmpty()) continue;
                break;
            }
            return charsRead;
        }

        @Override
        public boolean ready() {
            return !Terminal.this.buffer.isEmpty();
        }

        @Override
        public void close() {
        }
    }
}

