/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.slots;

import bluej.editor.fixes.SuggestionList;
import bluej.parser.AssistContentThreadSafe;
import bluej.pkgmgr.target.role.Kind;
import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.StructuredCompletionCalculator;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TypeCompletionCalculator
implements StructuredCompletionCalculator {
    private final InteractionManager editor;
    private final Class<?> superType;
    private final Set<Kind> kinds = new HashSet<Kind>();
    private List<AssistContentThreadSafe> acs;
    private static final Map<String, List<String>> commonTypes = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> boxedTypes = new HashMap<String, List<String>>();

    public TypeCompletionCalculator(InteractionManager editor) {
        this(editor, (Class)null);
    }

    public TypeCompletionCalculator(InteractionManager editor, Class<?> superType) {
        this.editor = editor;
        this.superType = superType;
        if (superType == null) {
            this.kinds.addAll(Arrays.asList(Kind.values()));
        } else {
            this.kinds.addAll(Arrays.asList(Kind.CLASS_FINAL, Kind.INTERFACE, Kind.CLASS_NON_FINAL));
        }
    }

    public TypeCompletionCalculator(InteractionManager editor, Kind kind) {
        this.editor = editor;
        this.superType = null;
        this.kinds.add(kind);
    }

    public static SuggestionList.SuggestionShown getRarity(AssistContentThreadSafe ac, boolean boxedAsCommon) {
        switch (ac.getKind()) {
            case TYPE: {
                if (boxedAsCommon && boxedTypes.containsKey(ac.getPackage()) && boxedTypes.get(ac.getPackage()).contains(ac.getName())) {
                    return SuggestionList.SuggestionShown.COMMON;
                }
                if (commonTypes.containsKey(ac.getPackage())) {
                    return commonTypes.get(ac.getPackage()).contains(ac.getName()) ? SuggestionList.SuggestionShown.COMMON : SuggestionList.SuggestionShown.RARE;
                }
                return SuggestionList.SuggestionShown.COMMON;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void withCalculatedSuggestionList(JavaFragment.PosInSourceDoc pos, ExpressionSlot<?> completing, CodeElement codeEl, SuggestionList.SuggestionListListener listener, String targetType, boolean completingStartOfSlot, FXPlatformConsumer<SuggestionList> handler) {
        HashSet<Kind> curKinds = new HashSet<Kind>(this.kinds);
        if (!completingStartOfSlot) {
            curKinds.remove((Object)Kind.PRIMITIVE);
        }
        this.editor.withTypes(this.superType, true, curKinds, acs -> Platform.runLater(() -> {
            this.acs = new ArrayList(acs.values());
            this.acs.removeIf(ac -> !ac.accessibleFromPackage(""));
            this.acs.sort(Comparator.comparing(AssistContentThreadSafe::getName));
            List<SuggestionList.SuggestionDetailsWithHTMLDoc> suggestions = Utility.mapList(this.acs, ac -> new SuggestionList.SuggestionDetailsWithHTMLDoc(ac.getName(), TypeCompletionCalculator.getRarity(ac, !completingStartOfSlot), ac.getDocHTML()));
            SuggestionList suggestionDisplay = new SuggestionList((SuggestionList.SuggestionListParent)this.editor, suggestions, null, SuggestionList.SuggestionShown.COMMON, null, listener);
            handler.accept(suggestionDisplay);
        }));
    }

    @Override
    public String getName(int selected) {
        return this.acs.get(selected).getName();
    }

    @Override
    public List<String> getParams(int selected) {
        return null;
    }

    @Override
    public char getOpening(int selected) {
        return '<';
    }

    static {
        commonTypes.put(null, Arrays.asList("boolean", "char", "double", "int", "void"));
        commonTypes.put("greenfoot", Arrays.asList("Actor", "GreenfootImage", "GreenfootSound", "MouseInfo", "UserInfo", "World"));
        commonTypes.put("java.lang", Arrays.asList("Exception", "Object", "String"));
        commonTypes.put("java.util", Arrays.asList("ArrayList", "HashMap", "HashSet", "LinkedList", "List", "Map", "Set"));
        boxedTypes.put("java.lang", Arrays.asList("Boolean", "Character", "Double", "Float", "Integer"));
    }
}

