/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.generic;

import bluej.stride.framedjava.elements.LocatableElement;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.InteractionManager;
import bluej.stride.slots.CopyableHeaderItem;
import bluej.stride.slots.EditableSlot;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotParent;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.ErrorUnderlineCanvas;
import bluej.utility.javafx.HangingFlowPane;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import bluej.utility.javafx.binding.ConcatListBinding;
import bluej.utility.javafx.binding.ConcatMapListBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class FrameContentRow
implements FrameContentItem,
SlotParent<HeaderItem> {
    private final Frame parentFrame;
    private final HangingFlowPane headerRow = new HangingFlowPane();
    private final ErrorUnderlineCanvas headerOverlay;
    private final ObservableList<HeaderItem> headerRowComponents = FXCollections.observableArrayList();
    private final StackPane stackPane;
    private final BooleanProperty mouseHovering = new SimpleBooleanProperty(false);

    public FrameContentRow(Frame parentFrame, HeaderItem ... items) {
        this(parentFrame, "anon-");
        this.headerRowComponents.setAll((Object[])items);
    }

    public FrameContentRow(Frame parentFrame, String stylePrefix) {
        this.parentFrame = parentFrame;
        this.stackPane = new StackPane();
        this.headerOverlay = new ErrorUnderlineCanvas((Node)this.stackPane);
        this.stackPane.getChildren().addAll((Object[])new Node[]{this.headerRow, this.headerOverlay.getNode()});
        this.headerRow.setMinWidth(200.0);
        this.headerRow.getStyleClass().addAll((Object[])new String[]{"header-row", stylePrefix + "header-row"});
        this.headerRow.setAlignment(Pos.CENTER_LEFT);
        ConcatMapListBinding.bind(this.headerRow.getChildren(), this.headerRowComponents, HeaderItem::getComponents);
        StackPane.setMargin((Node)this.headerRow, (Insets)new Insets(0.0, 6.0, 0.0, 6.0));
        this.stackPane.addEventFilter(MouseEvent.MOUSE_ENTERED, e -> this.mouseHovering.set(true));
        this.stackPane.addEventFilter(MouseEvent.MOUSE_EXITED, e -> this.mouseHovering.set(false));
    }

    public void setMargin(Insets insets) {
        StackPane.setMargin((Node)this.headerRow, (Insets)insets);
    }

    @Override
    public Stream<HeaderItem> getHeaderItemsDeep() {
        return this.getHeaderItemsDirect();
    }

    @Override
    public Stream<HeaderItem> getHeaderItemsDirect() {
        return this.headerRowComponents.stream();
    }

    public Stream<EditableSlot> getSlotsDirect() {
        return this.getHeaderItemsDirect().map(HeaderItem::asEditable).filter(x -> x != null);
    }

    public ErrorUnderlineCanvas getOverlay() {
        return this.headerOverlay;
    }

    public void setHeaderItems(List<HeaderItem> headerItems) {
        this.headerRowComponents.setAll(headerItems);
    }

    public void bindContentsConcat(ObservableList<ObservableList<? extends HeaderItem>> src) {
        ConcatListBinding.bind(this.headerRowComponents, src);
    }

    @Override
    public Bounds getSceneBounds() {
        return this.stackPane.localToScene(this.stackPane.getBoundsInLocal());
    }

    @Override
    public void focusLeft(HeaderItem src) {
        int index = this.headerRowComponents.indexOf((Object)src);
        if (index < 0) {
            throw new IllegalStateException("Child slot not found in slot parent");
        }
        EditableSlot s = this.prevFocusableBefore(index);
        if (s != null) {
            s.requestFocus(Focus.RIGHT);
        } else {
            this.parentFrame.focusLeft(this);
        }
    }

    @Override
    public void focusRight(HeaderItem src) {
        int index = this.headerRowComponents.indexOf((Object)src);
        if (index < 0) {
            throw new IllegalStateException("Child slot not found in slot parent");
        }
        EditableSlot s = this.nextFocusableAfter(index);
        if (s != null) {
            s.requestFocus(Focus.LEFT);
        } else {
            this.parentFrame.focusRight(this);
        }
    }

    private EditableSlot nextFocusableAfter(int curSlot) {
        for (int i = curSlot + 1; i < this.headerRowComponents.size(); ++i) {
            EditableSlot s = ((HeaderItem)this.headerRowComponents.get(i)).asEditable();
            if (s == null || !s.isEditable()) continue;
            return s;
        }
        return null;
    }

    private EditableSlot prevFocusableBefore(int curSlot) {
        for (int i = curSlot - 1; i >= 0; --i) {
            EditableSlot s = ((HeaderItem)this.headerRowComponents.get(i)).asEditable();
            if (s == null || !s.isEditable()) continue;
            return s;
        }
        return null;
    }

    @Override
    public void focusEnter(HeaderItem src) {
        this.parentFrame.focusEnter(this);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void escape(HeaderItem src) {
        this.parentFrame.escape(this, src);
    }

    @Override
    public void focusDown(HeaderItem src) {
        this.parentFrame.focusDown(this);
    }

    @Override
    public void focusUp(HeaderItem src, boolean cursorToEnd) {
        this.parentFrame.focusUp(this, cursorToEnd);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean backspaceAtStart(HeaderItem src) {
        return this.parentFrame.backspaceAtStart(this, src);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean deleteAtEnd(HeaderItem src) {
        return this.parentFrame.deleteAtEnd(this, src);
    }

    @Override
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animation) {
        this.getHeaderItemsDirect().forEach(item -> item.setView(oldView, newView, animation));
        animation.addOnStopped(() -> JavaFXUtil.runAfter(Duration.millis((double)100.0), this.headerOverlay::redraw));
    }

    @Override
    public boolean focusBottomEndFromNext() {
        return this.focusLeftEndFromPrev();
    }

    @Override
    public boolean focusLeftEndFromPrev() {
        Optional<EditableSlot> last = this.getSlotsDirect().filter(EditableSlot::isEditable).findFirst();
        if (last.isPresent()) {
            last.get().requestFocus(Focus.LEFT);
            return true;
        }
        return false;
    }

    @Override
    public boolean focusRightEndFromNext() {
        Optional<EditableSlot> last = Utility.findLast(this.getSlotsDirect().filter(EditableSlot::isEditable));
        if (last.isPresent()) {
            last.get().requestFocus(Focus.RIGHT);
            return true;
        }
        return false;
    }

    @Override
    public boolean focusTopEndFromPrev() {
        return this.focusLeftEndFromPrev();
    }

    @Override
    public Optional<FrameCanvas> getCanvas() {
        return Optional.empty();
    }

    public final DoubleExpression flowPaneWidth() {
        return this.headerRow.widthProperty();
    }

    public Region getNode() {
        return this.stackPane;
    }

    public void setSnapToPixel(boolean b) {
        this.stackPane.setSnapToPixel(b);
        this.headerRow.setSnapToPixel(b);
    }

    public void addOverlay(Node item) {
        this.stackPane.getChildren().add((Object)item);
    }

    public double getLeftFirstItem() {
        Node n = (Node)this.headerRow.getChildren().stream().findFirst().get();
        return n.localToScene(n.getBoundsInLocal()).getMinX();
    }

    public DoubleExpression flowPaneHeight() {
        return this.headerRow.heightProperty();
    }

    public void applyCss() {
        this.headerRow.applyCss();
    }

    public StackPane makeDisplayClone(InteractionManager editor) {
        HangingFlowPane hfpCopy = new HangingFlowPane();
        hfpCopy.getChildren().setAll((Collection)this.headerRowComponents.stream().flatMap(c -> ((CopyableHeaderItem)((Object)c)).makeDisplayClone(editor)).collect(Collectors.toList()));
        hfpCopy.prefWidthProperty().bind((ObservableValue)this.headerRow.widthProperty());
        hfpCopy.alignmentProperty().bind(this.headerRow.alignmentProperty());
        hfpCopy.hangingIndentProperty().bind((ObservableValue)this.headerRow.hangingIndentProperty());
        JavaFXUtil.bindList(hfpCopy.getStyleClass(), this.headerRow.getStyleClass().filtered(c -> !c.equals("header-row")));
        StackPane.setMargin((Node)hfpCopy, (Insets)new Insets(0.0, 6.0, 0.0, 6.0));
        StackPane paneCopy = new StackPane(new Node[]{hfpCopy});
        return paneCopy;
    }

    public void setVisible(boolean visible) {
        this.stackPane.setVisible(visible);
        this.stackPane.setManaged(visible);
    }

    public ObservableBooleanValue mouseHoveringProperty() {
        return this.mouseHovering;
    }

    public final List<ExtensionDescription> getExtensions() {
        if (this.parentFrame.getHeaderRow() == this) {
            return this.parentFrame.getAvailableExtensions(null, null);
        }
        return Collections.emptyList();
    }

    @OnThread(value=Tag.FXPlatform)
    public void notifyModifiedPress(KeyCode c) {
        List possibles = this.getExtensions().stream().filter(ext -> ext.validFor(ExtensionDescription.ExtensionSource.MODIFIER) && ("" + ext.getShortcutKey()).equals(c.getName().toLowerCase())).collect(Collectors.toList());
        if (possibles.size() == 1) {
            ((ExtensionDescription)possibles.get(0)).activate();
        } else if (possibles.size() > 1) {
            Debug.message("Ambiguous alt keypress for " + this.parentFrame.getClass() + " for " + c);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void fontSizeChanged() {
        this.headerOverlay.redraw();
    }

    @Override
    public String getXPathForElementAt(double sceneX, double sceneY, LocatableElement.LocationMap locationMap, String xpathParent, int canvasesBefore, boolean includePseudoElements, boolean includeSubstringIndex) {
        return this.getHeaderItemsDeep().flatMap(x -> Stream.ofNullable(x.getXPathForElementAt(sceneX, sceneY, locationMap, xpathParent, includePseudoElements, includeSubstringIndex))).findFirst().orElse(null);
    }
}

