/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.slots.StructuredSlotField;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public class TextOverlayPosition {
    private final StructuredSlotField src;
    private final double x;
    private final double topY;
    private final double baselineY;
    private final double bottomY;

    private TextOverlayPosition(StructuredSlotField src, double x, double topY, double baselineY, double bottomY) {
        this.src = src;
        this.x = x;
        this.topY = topY;
        this.baselineY = baselineY;
        this.bottomY = bottomY;
    }

    private TextOverlayPosition(double x, double topY, double baselineY, double bottomY) {
        this(null, x, topY, baselineY, bottomY);
    }

    public double getSceneX() {
        return this.x;
    }

    public double getSceneTopY() {
        return this.topY;
    }

    public double getSceneBaselineY() {
        return this.baselineY;
    }

    public double getSceneBottomY() {
        return this.bottomY;
    }

    public String toString() {
        return "(" + this.x + ", " + this.topY + " -> " + this.bottomY + ")";
    }

    public static TextOverlayPosition nodeToOverlay(Node node, double x, double topY, double baselineY, double bottomY) {
        Point2D topLeft = node.localToScene(x, topY);
        Point2D baselineLeft = node.localToScene(x, baselineY);
        Point2D bottomLeft = node.localToScene(x, bottomY);
        return new TextOverlayPosition(topLeft.getX(), topLeft.getY(), baselineLeft.getY(), bottomLeft.getY());
    }

    public static LinkedList<Line> groupIntoLines(List<TextOverlayPosition> positions) {
        LinkedList<Line> r = new LinkedList<Line>();
        if (positions.size() == 0) {
            return r;
        }
        r.add(new Line());
        for (TextOverlayPosition p : positions) {
            if (r.getLast().add(p)) continue;
            r.add(new Line());
            r.getLast().add(p);
        }
        return r;
    }

    public static TextOverlayPosition fromScene(double x, double topY, double baselineY, double bottomY, StructuredSlotField expressionSlotField) {
        return new TextOverlayPosition(expressionSlotField, x, topY, baselineY, bottomY);
    }

    public StructuredSlotField getSource() {
        return this.src;
    }

    public static class Line {
        public final List<TextOverlayPosition> positions = new ArrayList<TextOverlayPosition>();
        public double startX;
        public double endX;
        public double topY;
        public double bottomY;

        public void transform(Function<Point2D, Point2D> trans) {
            Point2D topLeft = trans.apply(new Point2D(this.startX, this.topY));
            Point2D bottomRight = trans.apply(new Point2D(this.endX, this.bottomY));
            this.startX = topLeft.getX();
            this.endX = bottomRight.getX();
            this.topY = topLeft.getY();
            this.bottomY = bottomRight.getY();
        }

        public boolean add(TextOverlayPosition p) {
            if (this.positions.size() == 0) {
                this.topY = p.topY;
                this.bottomY = p.bottomY;
                this.startX = p.x;
                this.endX = p.x;
                this.positions.add(p);
                return true;
            }
            if (p.topY < this.bottomY) {
                this.topY = Math.min(this.topY, p.topY);
                this.bottomY = Math.max(this.bottomY, p.bottomY);
                this.endX = p.x;
                this.positions.add(p);
                return true;
            }
            return false;
        }

        public TextOverlayPosition getStart() {
            return this.positions.get(0);
        }

        public TextOverlayPosition getEnd() {
            return this.positions.get(this.positions.size() - 1);
        }
    }
}

