/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.elements.CommentElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.VarFrame;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.DocumentationTextArea;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.RecallableFocus;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.slots.EditableSlot;
import bluej.utility.Debug;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import java.util.Arrays;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.KeyEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CommentFrame
extends SingleLineFrame
implements CodeFrame<CommentElement> {
    private static final String COMMENT_STYLE_PREFIX = "comment-";
    private DocumentationTextArea comment;
    private CommentElement element;
    private Canvas diagonalLinesCanvas;

    private CommentFrame(InteractionManager editor) {
        super(editor, null, COMMENT_STYLE_PREFIX);
        this.comment = new DocumentationTextArea(editor, this, this.getHeaderRow(), COMMENT_STYLE_PREFIX, () -> this.focusEnter(this.getHeaderRow()));
        this.comment.setDocComment(false);
        this.comment.setPromptText("Comment...");
        this.comment.bindPrefMaxWidth(this.getHeaderRow().flowPaneWidth().subtract(1.0));
        this.setHeaderRow(this.comment);
        JavaFXUtil.onceInScene(this.comment.getNode(), this.comment::hackFixSizing);
        this.comment.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case BACK_SPACE: {
                    this.backspaceAtStart(this.getHeaderRow(), this.comment);
                    break;
                }
                case DELETE: {
                    this.backspaceAtStart(this.getHeaderRow(), this.comment);
                    break;
                }
                case ESCAPE: {
                    this.escape(null, null);
                }
            }
        });
        this.getDiagonalLineCanvas();
        this.frameName = "comment";
    }

    public CommentFrame(InteractionManager editor, String comment) {
        this(editor);
        this.comment.setText(comment);
    }

    public static FrameFactory<CommentFrame> getFactory() {
        return new FrameFactory<CommentFrame>(){

            @Override
            public CommentFrame createBlock(InteractionManager editor) {
                return new CommentFrame(editor);
            }

            @Override
            public Class<CommentFrame> getBlockClass() {
                return CommentFrame.class;
            }
        };
    }

    @Override
    public String getScreenReaderText() {
        String commentString = this.comment.getText().equals("") ? "blank" : this.comment.getText();
        return "comment. " + commentString;
    }

    @Override
    public String getScreenReaderHelp() {
        return "you are " + this.getParentCanvas().getParentLocationDescription();
    }

    private Canvas getDiagonalLineCanvas() {
        if (this.diagonalLinesCanvas == null) {
            this.diagonalLinesCanvas = new Canvas(16.0, 16.0);
            this.diagonalLinesCanvas.setManaged(false);
            GraphicsContext gc = this.diagonalLinesCanvas.getGraphicsContext2D();
            gc.setStroke((Paint)Color.rgb((int)180, (int)180, (int)180));
            gc.strokeLine(6.0, 0.0, 0.0, 10.0);
            gc.strokeLine(9.0, 0.0, 0.0, 15.0);
            this.header.addOverlay((Node)this.diagonalLinesCanvas);
        }
        return this.diagonalLinesCanvas;
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        if (parentCanvas == null) {
            return;
        }
        JavaFXUtil.setPseudoclass("bj-fields", !this.isField(parentCanvas), this.getNode());
        JavaFXUtil.setPseudoclass("bj-before-local-var", !this.isField(parentCanvas) && this.isBeforeVarFrame(parentCanvas), this.getNode());
        if (Arrays.asList(CanvasParent.CanvasKind.FIELDS, CanvasParent.CanvasKind.CONSTRUCTORS, CanvasParent.CanvasKind.METHODS).contains((Object)parentCanvas.getParent().getChildKind(parentCanvas))) {
            this.addStyleClass(this.isInInterface(parentCanvas) ? "interface-comment-frame" : "class-comment-frame");
        } else {
            this.removeStyleClass(this.isInInterface(parentCanvas) ? "interface-comment-frame" : "class-comment-frame");
        }
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            this.comment.setScreenReaderHelpSlots("You are in a comment slot in the " + this.frameName + " frame " + this.getParentCanvas().getParentLocationDescription());
        }
    }

    private boolean isField(FrameCanvas parentCanvas) {
        if (parentCanvas == null) {
            Debug.printCallStack("parentCanvas shouldn't be null");
            return false;
        }
        return parentCanvas.getParent().getChildKind(parentCanvas) == CanvasParent.CanvasKind.FIELDS;
    }

    private boolean isBeforeVarFrame(FrameCanvas parentCanvas) {
        Frame frameAfter = parentCanvas.getFrameAfter(this.getCursorAfter());
        for (int counter = 0; frameAfter != null && !frameAfter.isEffectiveFrame() && counter < 2; ++counter) {
            frameAfter = parentCanvas.getFrameAfter(frameAfter.getCursorAfter());
        }
        return frameAfter instanceof VarFrame;
    }

    @Override
    public void setElementEnabled(boolean enabled) {
    }

    @Override
    public boolean canHaveEnabledState(boolean enabled) {
        return enabled;
    }

    public String getComment() {
        return this.comment.getText();
    }

    @Override
    public void regenerateCode() {
        this.element = new CommentElement(this);
    }

    @Override
    public CommentElement getCode() {
        return this.element;
    }

    public RecallableFocus getFocusable() {
        return this.comment;
    }

    @Override
    public EditableSlot getErrorShowRedirect() {
        return null;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animation) {
        super.setView(oldView, newView, animation);
        if (newView == Frame.View.JAVA_PREVIEW) {
            this.getDiagonalLineCanvas().opacityProperty().bind((ObservableValue)animation.getOppositeProgress());
            animation.addOnStopped(() -> ((DoubleProperty)this.getDiagonalLineCanvas().opacityProperty()).unbind());
        } else {
            this.getDiagonalLineCanvas().opacityProperty().bind((ObservableValue)animation.getProgress());
            animation.addOnStopped(() -> ((DoubleProperty)this.getDiagonalLineCanvas().opacityProperty()).unbind());
        }
        if (newView == Frame.View.BIRDSEYE_NODOC) {
            this.getDiagonalLineCanvas().setVisible(false);
            this.comment.getNode().setManaged(false);
        } else {
            this.getDiagonalLineCanvas().setVisible(true);
            this.comment.getNode().setManaged(true);
        }
    }

    @Override
    public boolean isEffectiveFrame() {
        return false;
    }
}

