/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.CallExpressionSlotFragment;
import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.frames.AssignFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.slots.CallExpressionSlot;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.slots.HeaderItem;
import bluej.utility.javafx.JavaFXUtil;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CallFrame
extends SingleLineFrame
implements CodeFrame<CallElement>,
DebuggableFrame {
    private final ExpressionSlot<CallExpressionSlotFragment> content;
    private CallElement element;

    private CallFrame(InteractionManager editor) {
        super(editor, null, "do-");
        this.content = new CallExpressionSlot(editor, this, this, this.getHeaderRow(), "do-method-name-", CallExpressionSlot.CALL_HINTS);
        this.content.setText("()");
        this.content.setMethodCallPromptText("method-name");
        this.setHeaderRow(this.content, this.previewSemi);
        this.content.onTextPropertyChange(s -> this.checkForTopLevelEquals());
        this.content.addFocusListener(this);
        this.frameName = "method call";
        this.content.setSlotName("method name");
    }

    @OnThread(value=Tag.FXPlatform)
    public CallFrame(InteractionManager editor, String beforeCursor, String afterCursor) {
        this(editor);
        this.content.setSplitText(beforeCursor, afterCursor);
    }

    public CallFrame(InteractionManager editor, ExpressionSlotFragment e, boolean enabled) {
        this(editor);
        this.content.setText(e);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public String getScreenReaderText() {
        String contentString = this.content.getText().trim().equals("()") ? "blank" : this.content.getScreenreaderText();
        return this.frameName + contentString;
    }

    @Override
    public String getScreenReaderHelp() {
        return "you are " + this.getParentCanvas().getParentLocationDescription();
    }

    @Override
    public void regenerateCode() {
        this.element = new CallElement(this, (CallExpressionSlotFragment)this.content.getSlotElement(), this.frameEnabledProperty.get());
    }

    @Override
    public CallElement getCode() {
        return this.element;
    }

    public static FrameFactory<CallFrame> getFactory() {
        return new FrameFactory<CallFrame>(){

            @Override
            public CallFrame createBlock(InteractionManager editor) {
                return new CallFrame(editor);
            }

            @Override
            public Class<CallFrame> getBlockClass() {
                return CallFrame.class;
            }
        };
    }

    private void checkForTopLevelEquals() {
        StructuredSlot.SplitInfo info = this.content.trySplitOnEquals();
        if (info != null && this.getParentCanvas() != null) {
            this.getParentCanvas().replaceBlock(this, new AssignFrame(this.getEditor(), info.lhs, info.rhs));
        }
    }

    @Override
    public void setParentCanvas(FrameCanvas parentCanvas) {
        super.setParentCanvas(parentCanvas);
        this.checkForTopLevelEquals();
    }

    @Override
    public boolean deleteAtEnd(FrameContentItem row, HeaderItem src) {
        if (this.contents.size() > 0 && (src == this.contents.get(0) || row == this.contents.get(0)) && this.isAlmostBlank()) {
            this.deleteOurselves();
            return true;
        }
        return false;
    }

    @Override
    public void checkForEmptySlot() {
        if (this.content.isEmpty()) {
            this.deleteOurselves();
        }
    }

    private void deleteOurselves() {
        FrameCanvas parentCanvas = this.getParentCanvas();
        FrameCursor cursorBefore = this.getCursorBefore();
        parentCanvas.removeBlock(this);
        cursorBefore.requestFocus();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void insertedWithCtrl() {
        JavaFXUtil.runAfter(Duration.millis((double)100.0), this.content::showSuggestion);
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            this.content.setAccessibilityHelpSlots();
        }
    }
}

