/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.frames;

import bluej.stride.framedjava.ast.ExpressionSlotFragment;
import bluej.stride.framedjava.ast.FilledExpressionSlotFragment;
import bluej.stride.framedjava.elements.AssignElement;
import bluej.stride.framedjava.frames.CallFrame;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.DebuggableFrame;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.FilledExpressionSlot;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCanvas;
import bluej.stride.generic.FrameContentItem;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.stride.generic.SingleLineFrame;
import bluej.stride.slots.Focus;
import bluej.stride.slots.HeaderItem;
import bluej.stride.slots.SlotLabel;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.SharedTransition;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class AssignFrame
extends SingleLineFrame
implements CodeFrame<AssignElement>,
DebuggableFrame {
    public static final String ASSIGN_SYMBOL = "\u21d0";
    private final ExpressionSlot<FilledExpressionSlotFragment> slotLHS;
    private final ExpressionSlot<FilledExpressionSlotFragment> slotRHS;
    private AssignElement element;
    private SlotLabel assignLabel;

    private AssignFrame(InteractionManager editor) {
        super(editor, null, "set-");
        this.slotRHS = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), "", FilledExpressionSlot.SRC_HINTS);
        this.slotRHS.setSimplePromptText("new-value");
        this.slotLHS = new FilledExpressionSlot(editor, this, this, this.getHeaderRow(), "assign-lhs-");
        this.slotLHS.setSimplePromptText("variable");
        this.assignLabel = new SlotLabel(ASSIGN_SYMBOL, new String[0]);
        this.setHeaderRow(this.slotLHS, this.assignLabel, this.slotRHS, this.previewSemi);
        this.slotLHS.addClosingChar('=');
        this.slotLHS.addClosingChar(' ');
        this.frameName = "assignment frame ";
        this.slotLHS.setSlotName("assigned variable name");
        this.slotRHS.setSlotName("assigned value expression");
    }

    AssignFrame(InteractionManager editor, String lhs, String rhs) {
        this(editor);
        this.slotLHS.setText(lhs);
        this.slotRHS.setText(rhs);
        if (Platform.isFxApplicationThread()) {
            JavaFXUtil.runPlatformLater(() -> this.slotRHS.requestFocus(Focus.LEFT));
        }
    }

    public AssignFrame(InteractionManager editor, FilledExpressionSlotFragment lhs, FilledExpressionSlotFragment rhs, boolean enabled) {
        this(editor);
        this.slotLHS.setText(lhs);
        this.slotRHS.setText(rhs);
        this.frameEnabledProperty.set(enabled);
    }

    @Override
    public void regenerateCode() {
        this.element = new AssignElement(this, (FilledExpressionSlotFragment)this.slotLHS.getSlotElement(), (FilledExpressionSlotFragment)this.slotRHS.getSlotElement(), this.frameEnabledProperty.get());
    }

    @Override
    public AssignElement getCode() {
        return this.element;
    }

    public static FrameFactory<AssignFrame> getFactory() {
        return new FrameFactory<AssignFrame>(){

            @Override
            public AssignFrame createBlock(InteractionManager editor) {
                return new AssignFrame(editor);
            }

            @Override
            public Class<AssignFrame> getBlockClass() {
                return AssignFrame.class;
            }
        };
    }

    @Override
    public String getScreenReaderText() {
        String lhs = this.slotLHS.getText().trim().isEmpty() ? "blank" : this.slotLHS.getScreenreaderText();
        String rhs = this.slotRHS.getText().trim().isEmpty() ? "blank" : this.slotRHS.getScreenreaderText();
        String text = "assign " + lhs + " with " + rhs;
        return text;
    }

    @Override
    public String getScreenReaderHelp() {
        return "you are " + this.getParentCanvas().getParentLocationDescription();
    }

    public ExpressionSlot<? extends ExpressionSlotFragment> getLHS() {
        return this.slotLHS;
    }

    public ExpressionSlot<? extends ExpressionSlotFragment> getRHS() {
        return this.slotRHS;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean backspaceAtStart(FrameContentItem row, HeaderItem src) {
        if (src == this.slotRHS) {
            this.collapseIntoMethodCall();
            return true;
        }
        return super.backspaceAtStart(row, src);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean deleteAtEnd(FrameContentItem row, HeaderItem src) {
        if (src == this.slotLHS) {
            this.collapseIntoMethodCall();
            return true;
        }
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    private void collapseIntoMethodCall() {
        this.getParentCanvas().replaceBlock(this, new CallFrame(this.getEditor(), this.slotLHS.getText(), this.slotRHS.getText()));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void setView(Frame.View oldView, Frame.View newView, SharedTransition animation) {
        super.setView(oldView, newView, animation);
        this.assignLabel.setText(newView == Frame.View.JAVA_PREVIEW ? "=" : ASSIGN_SYMBOL);
    }

    @Override
    public void updateAppearance(FrameCanvas parentCanvas) {
        super.updateAppearance(parentCanvas);
        if (this.getParentCanvas() != null && this.getParentCanvas().getParent() != null) {
            this.slotLHS.setAccessibilityHelpSlots();
            this.slotRHS.setAccessibilityHelpSlots();
        }
    }
}

