/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.errors;

import bluej.Config;
import bluej.compiler.Diagnostic;
import bluej.editor.fixes.Correction;
import bluej.editor.fixes.FixSuggestion;
import bluej.stride.framedjava.ast.StringSlotFragment;
import bluej.stride.framedjava.errors.DirectSlotError;
import bluej.stride.framedjava.slots.ExpressionSlot;
import java.util.ArrayList;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UndeclaredMethodInExpressionError
extends DirectSlotError {
    private final String methodName;
    private final int startPosInSlot;
    private final int endPosInSlot;
    private List<FixSuggestion> corrections = new ArrayList<FixSuggestion>();

    @OnThread(value=Tag.FXPlatform)
    public UndeclaredMethodInExpressionError(StringSlotFragment slotFragment, String methodName, int startPosInSlot, int endPosInSlot, ExpressionSlot slot, List<String> possibleCorrections) {
        super(slotFragment, Diagnostic.DiagnosticOrigin.STRIDE_LATE);
        this.methodName = methodName;
        this.startPosInSlot = startPosInSlot;
        this.endPosInSlot = endPosInSlot;
        this.corrections.addAll(Correction.winnowAndCreateCorrections((String)methodName, possibleCorrections.stream().distinct().map(Correction.SimpleCorrectionInfo::new), correctionElements -> slot.replace(startPosInSlot, endPosInSlot, this.isJavaPos(), correctionElements.getPrimaryElement())));
        slot.updateError(this);
    }

    @Override
    public int getStartPosition() {
        return this.startPosInSlot;
    }

    @Override
    public int getEndPosition() {
        return this.endPosInSlot;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getMessage() {
        return Config.getString("editor.quickfix.undeclaredMethod.errorMsg") + this.methodName + "(...)";
    }

    @Override
    public List<? extends FixSuggestion> getFixSuggestions() {
        return this.corrections;
    }

    @Override
    public boolean isJavaPos() {
        return true;
    }
}

