/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.ast.links;

import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.slots.UnderlineContainer;
import java.util.List;
import java.util.stream.Collectors;

public class PossibleKnownMethodLink
extends PossibleLink {
    private final String qualClassName;
    private final String methodName;
    private final List<String> qualParamTypes;

    public PossibleKnownMethodLink(String qualClassName, String methodName, List<String> qualParamTypes, int startPosition, int endPosition, UnderlineContainer slot) {
        super(startPosition, endPosition, slot);
        this.methodName = methodName;
        this.qualParamTypes = qualParamTypes;
        this.qualClassName = qualClassName;
    }

    public String getQualClassName() {
        return this.qualClassName;
    }

    public String getURLMethodSuffix() {
        return PossibleKnownMethodLink.encodeSuffix(this.methodName, this.qualParamTypes);
    }

    public static String encodeSuffix(String methodName, List<String> qualParamTypes) {
        return "#" + methodName + "-" + qualParamTypes.stream().map(PossibleKnownMethodLink::chopAtOpenAngle).collect(Collectors.joining("-")) + "-";
    }

    private static String chopAtOpenAngle(String s) {
        int i = s.indexOf(60);
        if (i < 0) {
            return s;
        }
        return s.substring(0, i);
    }

    public String getDisplayName() {
        return this.methodName + "(" + this.qualParamTypes.stream().collect(Collectors.joining(", ")) + ")";
    }
}

