/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.editor.flow.FlowEditor;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.NonCodeEditableTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.actions.EditAction;
import bluej.pkgmgr.target.actions.RemoveEditableTargetAction;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TextFileTarget
extends NonCodeEditableTarget {
    private final File file;

    public TextFileTarget(Package aPackage, File file) {
        super(aPackage, file.getName(), "");
        this.file = file;
        JavaFXUtil.addStyleClass((Styleable)this.pane, "text-target");
        JavaFXUtil.addStyleClass((Styleable)this.pane, "text-target-id-" + file.getName().replace(".", "-"));
        Label name = new Label(file.getName());
        BorderPane.setAlignment((Node)name, (Pos)Pos.CENTER);
        this.pane.setTop((Node)name);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doubleClick(boolean openInNewWindow) {
        Editor editor = this.getEditor();
        if (editor == null) {
            this.getPackage().showError("error-open-source");
        } else {
            editor.setEditorVisible(true, openInNewWindow);
        }
    }

    @Override
    public List<? extends AbstractOperation<Target>> getContextOperations() {
        return List.of(new EditAction(), new RemoveEditableTargetAction());
    }

    @Override
    public void remove() {
        this.getPackage().removeTarget(this);
        this.file.delete();
    }

    @Override
    protected File getSourceFile() {
        return this.file;
    }

    @Override
    public Editor getEditor() {
        if (this.editor == null) {
            FlowEditor flowEditor = new FlowEditor(newWindow -> {
                if (newWindow) {
                    return this.getPackage().getProject().createNewFXTabbedEditor();
                }
                return this.getPackage().getProject().getDefaultFXTabbedEditor();
            }, this.getSourceFile().getName(), (EditorWatcher)this, null, null, () -> {}, (BooleanExpression)new ReadOnlyBooleanWrapper(false), false);
            flowEditor.showFile(this.file.getAbsolutePath(), StandardCharsets.UTF_8, false, null);
            this.editor = flowEditor;
        }
        return this.editor;
    }

    @Override
    @OnThread(value=Tag.FX)
    public boolean isResizable() {
        return true;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        props.put(prefix + ".type", "TextTarget");
    }
}

