/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorWatcher;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.Target;
import bluej.prefmgr.PrefMgrDialog;
import java.io.File;
import java.io.IOException;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class EditableTarget
extends Target
implements EditorWatcher {
    public static final String MENU_STYLE_INBUILT = "class-action-inbuilt";
    public static final String editStr = Config.getString("pkgmgr.classmenu.edit");
    public static final String removeStr = Config.getString("pkgmgr.classmenu.remove");
    protected Editor editor;

    protected EditableTarget(Package pkg, String name, String accessibleTargetType) {
        super(pkg, name, accessibleTargetType);
    }

    protected abstract File getSourceFile();

    public abstract Editor getEditor();

    public void ensureSaved() throws IOException {
        if (this.editor != null && this.editor.isModified()) {
            this.editor.save();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void open() {
        Editor editor = this.getEditor();
        if (editor == null) {
            this.getPackage().showError("error-open-source");
        } else {
            editor.setEditorVisible(true, false);
        }
    }

    protected void close() {
        this.getEditor().close();
    }

    public boolean editorOpen() {
        return this.editor != null;
    }

    public void modificationEvent(Editor editor) {
    }

    public void saveEvent(Editor editor) {
    }

    public void closeEvent(Editor editor) {
    }

    public boolean breakpointToggleEvent(int lineNo, boolean set) {
        return false;
    }

    public void clearAllBreakpoints() {
    }

    public void showPreferences(int paneIndex) {
        PrefMgrDialog.showDialog(this.getPackage().getProject(), paneIndex);
    }
}

