/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeEntity;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public class ProjectEntityResolver
implements EntityResolver {
    private Project project;

    public ProjectEntityResolver(Project project) {
        this.project = project;
    }

    @Override
    public JavaEntity getValueEntity(String name, Reflective querySource) {
        return this.resolvePackageOrClass(name, querySource);
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        Class<?> cl = this.project.loadClass("java.lang." + name);
        if (cl != null) {
            return new TypeEntity(cl);
        }
        return new PackageEntity(name, this);
    }

    @Override
    public TypeEntity resolveQualifiedClass(String name) {
        ClassTarget ct;
        Reflective ref;
        Target target;
        int lastDot = name.lastIndexOf(46);
        String pkgName = lastDot != -1 ? name.substring(0, lastDot) : "";
        String baseName = name.substring(lastDot + 1);
        Package pkg = this.project.getPackage(pkgName);
        if (pkg != null && (target = pkg.getTarget(baseName)) instanceof ClassTarget && (ref = (ct = (ClassTarget)target).getTypeReflective()) != null) {
            return new TypeEntity(ref);
        }
        Class<?> cl = this.project.loadClass(name);
        if (cl != null) {
            return new TypeEntity(cl);
        }
        return null;
    }
}

