/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.classmgr.ClassMgrPrefPanel;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.UnfocusableScrollPane;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
class ExportDialog
extends Dialog<ExportInfo> {
    private static final String dialogTitle = Config.getString("pkgmgr.export.title");
    private static final String helpLine1 = Config.getString("pkgmgr.export.helpLine1");
    private static final String helpLine2 = Config.getString("pkgmgr.export.helpLine2");
    private static final String classLabelText = Config.getString("pkgmgr.export.classLabel");
    private static final String libsLabel = Config.getString("pkgmgr.export.includeLibs");
    private static final String sourceLabel = Config.getString("pkgmgr.export.sourceLabel");
    private static final String pkgFilesLabel = Config.getString("pkgmgr.export.pkgFilesLabel");
    private static final String noClassText = Config.getString("pkgmgr.export.noClassText");
    private final ComboBox<String> classSelect;
    private final CheckBox sourceBox;
    private final CheckBox pkgFilesBox;
    private final List<UserLibInfo> userLibs = new ArrayList<UserLibInfo>();
    private GridPane userLibPanel;

    public ExportDialog(Window parent, ProjectInfo projectInfo) {
        this.setTitle(dialogTitle);
        this.initOwner(parent);
        this.initModality(Modality.WINDOW_MODAL);
        Config.addDialogStylesheets((Pane)this.getDialogPane());
        this.setResultConverter(this::calculateResult);
        VBox mainPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPanel, "export-dialog-content");
        Label helpText = new Label(helpLine1 + " " + helpLine2);
        helpText.setWrapText(true);
        helpText.setMaxWidth(400.0);
        helpText.setMinHeight(Double.NEGATIVE_INFINITY);
        mainPanel.getChildren().add((Object)helpText);
        mainPanel.getChildren().add((Object)new Separator());
        HBox mainClassPanel = new HBox();
        JavaFXUtil.addStyleClass((Styleable)mainClassPanel, "export-dialog-main-row");
        mainClassPanel.setAlignment(Pos.CENTER);
        Label classLabel = new Label(classLabelText);
        mainClassPanel.getChildren().add((Object)classLabel);
        this.classSelect = new ComboBox();
        this.fillClassPopup(projectInfo.classNames);
        this.classSelect.getSelectionModel().select((Object)noClassText);
        mainClassPanel.getChildren().add(this.classSelect);
        mainPanel.getChildren().add((Object)mainClassPanel);
        this.userLibPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)this.userLibPanel, "export-dialog-userlibs");
        this.userLibPanel.setAlignment(Pos.CENTER);
        UnfocusableScrollPane userLibPanelScrollPane = new UnfocusableScrollPane((Node)this.userLibPanel);
        JavaFXUtil.expandScrollPaneContent(userLibPanelScrollPane);
        userLibPanelScrollPane.setMaxHeight(150.0);
        this.fillUserLibPanel(projectInfo, Collections.emptyList());
        mainPanel.getChildren().add((Object)new Label(libsLabel));
        mainPanel.getChildren().add((Object)userLibPanelScrollPane);
        this.sourceBox = new CheckBox(sourceLabel);
        this.sourceBox.setSelected(true);
        mainPanel.getChildren().add((Object)this.sourceBox);
        this.pkgFilesBox = new CheckBox(pkgFilesLabel);
        this.pkgFilesBox.setSelected(true);
        mainPanel.getChildren().add((Object)this.pkgFilesBox);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        ((Button)this.getDialogPane().lookupButton(ButtonType.OK)).setText(BlueJTheme.getContinueLabel());
        this.getDialogPane().setContent((Node)mainPanel);
    }

    private ExportInfo calculateResult(ButtonType buttonType) {
        if (buttonType == ButtonType.OK) {
            String mainClassName = (String)this.classSelect.getSelectionModel().getSelectedItem();
            if (mainClassName.equals(noClassText)) {
                mainClassName = "";
            }
            List<File> selected = this.getSelectedLibs();
            return new ExportInfo(mainClassName, selected, this.sourceBox.isSelected(), this.pkgFilesBox.isSelected());
        }
        return null;
    }

    private List<File> getSelectedLibs() {
        return this.userLibs.stream().filter(UserLibInfo::isSelected).map(UserLibInfo::getFile).collect(Collectors.toList());
    }

    public void updateDialog(ProjectInfo projectInfo) {
        String prevSelected = (String)this.classSelect.getSelectionModel().getSelectedItem();
        this.fillClassPopup(projectInfo.classNames);
        if (this.classSelect.getItems().contains((Object)prevSelected)) {
            this.classSelect.getSelectionModel().select((Object)prevSelected);
        } else {
            this.classSelect.getSelectionModel().select((Object)noClassText);
        }
        this.fillUserLibPanel(projectInfo, this.getSelectedLibs());
    }

    private void fillClassPopup(List<String> classNames) {
        this.classSelect.getItems().clear();
        this.classSelect.getItems().add((Object)noClassText);
        this.classSelect.getItems().addAll(classNames);
    }

    private void fillUserLibPanel(ProjectInfo projectInfo, List<File> startChecked) {
        this.userLibPanel.getChildren().clear();
        List<UserLibInfo> userlibList = Utility.mapList(projectInfo.jarFiles, file -> new UserLibInfo((File)file, startChecked.contains(file)));
        if (userlibList.size() < 1) {
            this.userLibPanel.setVisible(false);
        } else {
            this.userLibPanel.setVisible(true);
            this.userLibs.clear();
            this.userLibs.addAll(userlibList);
            for (int i = 0; i < this.userLibs.size(); ++i) {
                this.userLibPanel.add((Node)this.userLibs.get(i).getCheckBox(), i % 2, i / 2);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private static class UserLibInfo {
        private final File sourceFile;
        private final CheckBox checkBox;

        public UserLibInfo(File source, boolean selected) {
            this.sourceFile = source;
            this.checkBox = new CheckBox(this.sourceFile.getName());
            this.checkBox.setSelected(selected);
        }

        public CheckBox getCheckBox() {
            return this.checkBox;
        }

        public File getFile() {
            return this.sourceFile;
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }
    }

    public static class ProjectInfo {
        public final List<String> classNames;
        public final List<File> jarFiles;

        @OnThread(value=Tag.FXPlatform)
        public ProjectInfo(Project project) {
            this.classNames = project.getPackageNames().stream().sorted().flatMap(pkgName -> project.getPackage((String)pkgName).getAllClassnames().stream().sorted().map(className -> pkgName.isEmpty() ? className : pkgName + "." + className)).collect(Collectors.toList());
            List<URL> libList = ClassMgrPrefPanel.getUserConfigContent();
            libList.addAll(Project.getUserlibContent());
            this.jarFiles = Utility.mapList(libList, url -> {
                try {
                    return new File(new URI(url.toString()));
                }
                catch (URISyntaxException use) {
                    Debug.reportError("ExportDialog.createUserLibPanel(Project) invalid url=" + url.getPath());
                    return null;
                }
            });
        }
    }

    @OnThread(value=Tag.Any)
    public static class ExportInfo {
        public final String mainClassName;
        public final List<File> selectedFiles;
        public final boolean includeSource;
        public final boolean includePkgFiles;

        private ExportInfo(String mainClassName, List<File> selectedFiles, boolean includeSource, boolean includePkgFiles) {
            this.includePkgFiles = includePkgFiles;
            this.mainClassName = mainClassName;
            this.selectedFiles = selectedFiles;
            this.includeSource = includeSource;
        }
    }
}

