/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.SourceLocation;
import bluej.parser.SourceSpan;

public class Selection {
    private SourceSpan sspan;

    public Selection(int line, int column) {
        SourceLocation sl = new SourceLocation(line, column);
        this.sspan = new SourceSpan(sl, sl);
    }

    public Selection(SourceSpan ss) {
        this.sspan = ss;
    }

    public Selection(int line, int column, int length) {
        SourceLocation start = new SourceLocation(line, column);
        SourceLocation end = new SourceLocation(line, column + length);
        this.sspan = new SourceSpan(start, end);
    }

    public void combineWith(Selection other) {
        int otherstartl = other.getLine();
        int otherstartc = other.getColumn();
        int mystartl = this.getLine();
        int mystartc = this.getColumn();
        SourceLocation newStart = null;
        SourceLocation newEnd = null;
        if (otherstartl < mystartl || otherstartl == mystartl && otherstartc < mystartc) {
            newStart = other.getStartLocation();
        }
        int otherendl = other.getEndLine();
        int otherendc = other.getEndColumn();
        int myendl = this.getEndLine();
        int myendc = this.getEndColumn();
        if (otherendl > myendl || otherendl == myendl && otherendc > myendc) {
            newEnd = other.getEndLocation();
        }
        if (newStart != null || newEnd != null) {
            if (newStart == null) {
                newStart = this.getStartLocation();
            }
            if (newEnd == null) {
                newEnd = this.getEndLocation();
            }
            this.sspan = new SourceSpan(newStart, newEnd);
        }
    }

    public void extendEnd(int line, int column) {
        int mycol;
        int myline = this.getEndLine();
        if (line >= myline && (column >= (mycol = this.getEndColumn()) || line > myline)) {
            SourceLocation newEnd = new SourceLocation(line, column);
            SourceLocation newStart = this.getStartLocation();
            this.sspan = new SourceSpan(newStart, newEnd);
        }
    }

    public void extendEnd(SourceLocation sl) {
        this.extendEnd(sl.getLine(), sl.getColumn());
    }

    public int getLine() {
        return this.sspan.getStartLine();
    }

    public int getColumn() {
        return this.sspan.getStartColumn();
    }

    public SourceLocation getStartLocation() {
        return this.sspan.getStartLocation();
    }

    public int getEndLine() {
        return this.sspan.getEndLine();
    }

    public int getEndColumn() {
        return this.sspan.getEndColumn();
    }

    public SourceLocation getEndLocation() {
        return this.sspan.getEndLocation();
    }

    public String getLocation() {
        return "[" + this.sspan.toString() + "]";
    }

    public String toString() {
        return "Selection " + this.getLocation();
    }
}

