/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.parser.ExpressionTypeInfo;
import bluej.parser.Token;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.ReparseableDocument;
import java.io.Reader;

public class CommentNode
extends ParsedNode {
    private Type type;

    public CommentNode(ParsedNode parentNode, LocatableToken token) {
        super(parentNode);
        this.type = CommentNode.getCommentType(token);
    }

    private static Type getCommentType(LocatableToken token) {
        String text = token.getText();
        if (token.getType() == 61) {
            if (text.startsWith("/*#")) {
                return Type.ML_SPECIAL;
            }
            if (text.startsWith("/**#")) {
                return Type.ML_SPECIAL;
            }
            if (text.startsWith("/**")) {
                return Type.ML_JAVADOC;
            }
            return Type.ML_NORMAL;
        }
        if (text.startsWith("//#")) {
            return Type.SL_SPECIAL;
        }
        return Type.SL_NORMAL;
    }

    public boolean isJavadocComment() {
        return this.type == Type.ML_JAVADOC;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    @Override
    public Token getMarkTokensFor(int pos, int length, int nodePos, ReparseableDocument document) {
        Token tok = new Token(length, this.type.tokenType);
        tok.next = new Token(0, Token.TokenType.END);
        return tok;
    }

    @Override
    protected boolean marksOwnEnd() {
        return true;
    }

    @Override
    public int textInserted(ReparseableDocument document, int nodePos, int insPos, int length, NodeStructureListener listener) {
        int newSize = this.getSize() + length;
        this.resize(newSize);
        document.scheduleReparse(insPos, length);
        return 0;
    }

    @Override
    public int textRemoved(ReparseableDocument document, int nodePos, int delPos, int length, NodeStructureListener listener) {
        int newSize = this.getSize() - length;
        this.resize(newSize);
        document.scheduleReparse(delPos, 0);
        return 0;
    }

    @Override
    protected int reparseNode(ReparseableDocument document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        int pline = document.getDefaultRootElement().getElementIndex(nodePos) + 1;
        int pcol = nodePos - document.getDefaultRootElement().getElement(pline - 1).getStartOffset() + 1;
        Reader r = document.makeReader(nodePos, nodePos + this.getSize());
        JavaLexer lexer = new JavaLexer(r, pline, pcol, nodePos);
        LocatableToken commentToken = lexer.nextToken();
        if (commentToken.getType() != 166 && commentToken.getType() != 61) {
            return 3;
        }
        Type newType = CommentNode.getCommentType(commentToken);
        if (this.type.singleLine && !newType.singleLine) {
            return 3;
        }
        if (!this.type.singleLine && newType.singleLine && this.getOffsetFromParent() == 0 && this.getParentNode().isCommentAttached()) {
            return 3;
        }
        this.type = newType;
        int newEnd = CommentNode.lineColToPos(document, commentToken.getEndLine(), commentToken.getEndColumn());
        int newSize = newEnd - nodePos;
        document.markSectionParsed(nodePos, newSize);
        if (this.getSize() != newSize) {
            this.setSize(newSize);
            return 2;
        }
        return 0;
    }

    private static int lineColToPos(ReparseableDocument document, int line, int col) {
        ReparseableDocument.Element map = document.getDefaultRootElement();
        ReparseableDocument.Element lineEl = map.getElement(line - 1);
        return lineEl.getStartOffset() + col - 1;
    }

    @Override
    public ExpressionTypeInfo getExpressionType(int pos, ReparseableDocument document) {
        return null;
    }

    private static enum Type {
        SL_NORMAL(true, Token.TokenType.COMMENT_NORMAL),
        SL_SPECIAL(true, Token.TokenType.COMMENT_SPECIAL),
        ML_NORMAL(false, Token.TokenType.COMMENT_NORMAL),
        ML_JAVADOC(false, Token.TokenType.COMMENT_JAVADOC),
        ML_SPECIAL(false, Token.TokenType.COMMENT_SPECIAL);

        private final boolean singleLine;
        private final Token.TokenType tokenType;

        private Type(boolean singleLine, Token.TokenType tokenType) {
            this.singleLine = singleLine;
            this.tokenType = tokenType;
        }
    }
}

