/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.parser.EditorParser;
import bluej.parser.ParseUtils;
import bluej.parser.SourceLocation;
import bluej.parser.entity.ClassLoaderResolver;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageResolver;
import bluej.parser.entity.PositionedResolver;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.UnresolvedArray;
import bluej.parser.entity.UnresolvedEntity;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.MethodNode;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Selection;
import bluej.pkgmgr.Package;
import bluej.utility.JavaNames;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class InfoParser
extends EditorParser {
    protected String targetPkg;
    protected ClassInfo info;
    private int classLevel = 0;
    private boolean isPublic;
    private boolean isAbstract;
    private String comment;
    private int lastTdType;
    private boolean storeCurrentClassInfo;
    private int arrayCount = 0;
    private boolean methodTypeParams = false;
    private List<LocatableToken> lastTypespecToks;
    private boolean modPublic = false;
    private boolean modAbstract = false;
    private List<MethodDesc> methodDescs = new LinkedList<MethodDesc>();
    private MethodDesc currentMethod;
    private JavaEntity superclassEntity;
    private List<JavaEntity> interfaceEntities;
    private List<JavaEntity> typeReferences = new LinkedList<JavaEntity>();
    private List<UnresolvedVal> valueReferences = new LinkedList<UnresolvedVal>();
    private UnresolvedVal currentUnresolvedVal;
    private boolean gotExtends;
    private boolean gotImplements;
    private List<Selection> interfaceSelections;
    private Selection lastCommaSelection;
    protected boolean hadError;
    private LocatableToken pkgLiteralToken;
    private List<LocatableToken> packageTokens;
    private LocatableToken pkgSemiToken;

    public InfoParser(Reader r, EntityResolver resolver) {
        super(r, resolver);
    }

    public static ClassInfo parse(File f) throws FileNotFoundException {
        return InfoParser.parse(f, new ClassLoaderResolver(InfoParser.class.getClassLoader()));
    }

    public static ClassInfo parse(File f, EntityResolver resolver) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(f);
        ClassInfo info = InfoParser.parse(new BufferedReader(new InputStreamReader(fis)), resolver, null);
        try {
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    @OnThread(value=Tag.FXPlatform)
    public static ClassInfo parseWithPkg(File f, Package pkg) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(f);
        PackageResolver resolver = new PackageResolver(pkg.getProject().getEntityResolver(), pkg.getQualifiedName());
        Reader reader = new InputStreamReader((InputStream)fis, pkg.getProject().getProjectCharset());
        reader = new BufferedReader(reader);
        ClassInfo info = InfoParser.parse(reader, resolver, pkg.getQualifiedName());
        try {
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return info;
    }

    @OnThread(value=Tag.FXPlatform)
    public static ClassInfo parse(Reader r, EntityResolver resolver, String targetPkg) {
        InfoParser infoParser = null;
        infoParser = new InfoParser(r, resolver);
        infoParser.targetPkg = targetPkg;
        infoParser.parseCU();
        if (infoParser.info != null) {
            infoParser.info.setParseError(infoParser.hadError);
            infoParser.resolveComments();
            return infoParser.info;
        }
        return null;
    }

    @OnThread(value=Tag.FXPlatform)
    protected void resolveMethodTypes() {
        block0: for (MethodDesc md : this.methodDescs) {
            String methodSig;
            if (md.returnType != null) {
                md.returnType = md.returnType.resolveAsType();
                if (md.returnType == null) continue;
                methodSig = this.getTypeString(md.returnType) + " " + md.name + "(";
            } else {
                methodSig = md.name + "(";
            }
            Iterator<JavaEntity> i = md.paramTypes.iterator();
            while (i.hasNext()) {
                TypeEntity paramType;
                JavaEntity paramEnt = i.next();
                if (paramEnt == null || (paramType = paramEnt.resolveAsType()) == null) continue block0;
                methodSig = methodSig + this.getTypeString(paramType);
                if (!i.hasNext()) continue;
                methodSig = methodSig + ", ";
            }
            methodSig = methodSig + ")";
            md.paramNames = md.paramNames.trim();
            this.info.addComment(methodSig, md.javadocText, md.paramNames);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void resolveComments() {
        this.resolveMethodTypes();
        for (JavaEntity entity : this.typeReferences) {
            JavaType etype;
            if ((entity = entity.resolveAsType()) == null || (etype = entity.getType()).isPrimitive()) continue;
            this.addTypeReference(etype);
        }
        block1: for (UnresolvedVal val : this.valueReferences) {
            TypeEntity typeEnt;
            Iterator<LocatableToken> i = val.components.iterator();
            String name = i.next().getText();
            JavaEntity entity = val.resolver.getValueEntity(name, val.accessSource, val.accessPosition);
            if (entity != null && entity.resolveAsValue() != null) continue;
            while (entity != null && i.hasNext()) {
                typeEnt = entity.resolveAsType();
                if (typeEnt != null && !typeEnt.getType().isPrimitive()) {
                    this.addTypeReference(entity.getType());
                }
                if ((entity = entity.getSubentity(i.next().getText(), val.accessSource)) == null || entity.resolveAsValue() == null) continue;
                continue block1;
            }
            if (i.hasNext() || entity == null || (typeEnt = entity.resolveAsType()) == null || typeEnt.getType().isPrimitive()) continue;
            this.addTypeReference(entity.getType());
        }
        if (this.superclassEntity != null) {
            JavaType sceType;
            GenTypeClass scecType;
            this.superclassEntity = this.superclassEntity.resolveAsType();
            if (this.superclassEntity != null && (scecType = (sceType = this.superclassEntity.getType()).asClass()) != null) {
                this.info.setSuperclass(scecType.getReflective().getName());
            }
        }
        if (this.interfaceEntities != null && !this.interfaceEntities.isEmpty()) {
            for (JavaEntity ifaceEnt : this.interfaceEntities) {
                GenTypeClass iType;
                TypeEntity iEnt = ifaceEnt.resolveAsType();
                if (iEnt != null && (iType = iEnt.getType().asClass()) != null) {
                    this.info.addImplements(iType.getReflective().getName());
                    continue;
                }
                this.info.addImplements("");
            }
        }
    }

    private void addTypeReference(JavaType type) {
        GenTypeClass ctype = type.asClass();
        if (ctype != null) {
            this.addTypeReference(ctype.getErasedType().toString());
            List<? extends GenTypeParameter> plist = ctype.getTypeParamList();
            for (GenTypeParameter genTypeParameter : plist) {
                GenTypeSolid sparam = genTypeParameter.asSolid();
                if (sparam != null) {
                    this.addTypeReference(sparam);
                    continue;
                }
                JavaType upperBound = genTypeParameter.getUpperBound();
                GenTypeSolid lowerBound = genTypeParameter.getLowerBound();
                if (upperBound != null) {
                    this.addTypeReference(upperBound);
                }
                if (lowerBound == null) continue;
                this.addTypeReference(lowerBound);
            }
        }
    }

    private void addTypeReference(String typeString) {
        String prefix = JavaNames.getPrefix(typeString);
        if (prefix.equals(this.targetPkg)) {
            String name = JavaNames.getBase(typeString);
            int dollar = name.indexOf(36);
            if (dollar != -1) {
                name = name.substring(0, dollar);
            }
            this.info.addUsed(name);
        }
    }

    private String getTypeString(JavaEntity entity) {
        String erasedType = entity.getType().getErasedType().toString();
        if (this.targetPkg != null && this.targetPkg.length() != 0 && erasedType.startsWith(this.targetPkg + ".")) {
            erasedType = erasedType.substring(this.targetPkg.length() + 1);
        }
        return erasedType.replace("$", ".");
    }

    @Override
    protected void error(String msg, int beginLine, int beginColumn, int endLine, int endColumn) {
        this.hadError = true;
    }

    @Override
    protected void beginTypeBody(LocatableToken token) {
        super.beginTypeBody(token);
        ++this.classLevel;
        this.gotExtends = false;
        this.gotImplements = false;
    }

    @Override
    protected void endTypeBody(LocatableToken token, boolean included) {
        super.endTypeBody(token, included);
        --this.classLevel;
    }

    @Override
    protected void gotTypeSpec(List<LocatableToken> tokens) {
        boolean isInterface;
        this.lastTypespecToks = tokens;
        super.gotTypeSpec(tokens);
        int tokpos = this.lineColToPosition(tokens.get(0).getLine(), tokens.get(0).getColumn());
        int topOffset = this.getTopNodeOffset();
        PositionedResolver resolver = new PositionedResolver((JavaParentNode)this.scopeStack.peek(), tokpos - topOffset);
        JavaEntity tentity = ParseUtils.getTypeEntity(resolver, this.currentQuerySource(), tokens);
        if (tentity != null && !this.gotExtends && !this.gotImplements) {
            this.typeReferences.add(tentity);
        }
        boolean isSuper = this.storeCurrentClassInfo && this.gotExtends && !this.info.isInterface();
        boolean bl = isInterface = this.storeCurrentClassInfo && (this.gotImplements || this.info.isInterface() && this.gotExtends);
        if (isSuper) {
            this.superclassEntity = ParseUtils.getTypeEntity((EntityResolver)this.scopeStack.get(0), null, tokens);
            this.info.setSuperclass("");
            Selection superClassSelection = this.getSelection(tokens);
            this.info.setSuperReplaceSelection(superClassSelection);
            this.info.setImplementsInsertSelection(new Selection(superClassSelection.getEndLine(), superClassSelection.getEndColumn()));
        } else if (isInterface) {
            Selection interfaceSel = this.getSelection(tokens);
            if (this.lastCommaSelection != null) {
                this.lastCommaSelection.extendEnd(interfaceSel.getLine(), interfaceSel.getColumn());
                this.interfaceSelections.add(this.lastCommaSelection);
                this.lastCommaSelection = null;
            }
            this.interfaceSelections.add(interfaceSel);
            JavaEntity interfaceEnt = ParseUtils.getTypeEntity((EntityResolver)this.scopeStack.get(0), null, tokens);
            if (interfaceEnt != null) {
                this.interfaceEntities.add(interfaceEnt);
            }
            if (this.tokenStream.LA(1).getType() == 74) {
                this.lastCommaSelection = this.getSelection(this.tokenStream.LA(1));
            } else {
                this.info.setInterfaceSelections(this.interfaceSelections);
                if (!this.info.isInterface()) {
                    this.info.setImplementsInsertSelection(new Selection(interfaceSel.getEndLine(), interfaceSel.getEndColumn()));
                } else {
                    this.info.setExtendsInsertSelection(new Selection(interfaceSel.getEndLine(), interfaceSel.getEndColumn()));
                }
            }
        }
    }

    @Override
    protected void gotMethodTypeParamsBegin() {
        super.gotMethodTypeParamsBegin();
        this.methodTypeParams = true;
    }

    @Override
    protected void gotTypeParam(LocatableToken idToken) {
        super.gotTypeParam(idToken);
        if (this.storeCurrentClassInfo && !this.methodTypeParams && this.classLevel == 0) {
            this.info.addTypeParameterText(idToken.getText());
            this.info.setTypeParametersSelection(this.getSelection(idToken));
        }
    }

    @Override
    protected void endMethodTypeParams() {
        super.endMethodTypeParams();
        this.methodTypeParams = false;
    }

    @Override
    protected void gotTypeParamBound(List<LocatableToken> tokens) {
        super.gotTypeParamBound(tokens);
        JavaEntity ent = ParseUtils.getTypeEntity((EntityResolver)this.scopeStack.peek(), this.currentQuerySource(), tokens);
        if (ent != null) {
            this.typeReferences.add(ent);
        }
    }

    @Override
    protected void gotIdentifier(LocatableToken token) {
        this.gotCompoundIdent(token);
        this.valueReferences.add(this.currentUnresolvedVal);
    }

    @Override
    protected void gotCompoundIdent(LocatableToken token) {
        this.currentUnresolvedVal = new UnresolvedVal();
        this.currentUnresolvedVal.components = new LinkedList<LocatableToken>();
        this.currentUnresolvedVal.components.add(token);
        this.currentUnresolvedVal.resolver = (JavaParentNode)this.scopeStack.peek();
        this.currentUnresolvedVal.accessSource = this.currentQuerySource();
        int tokenPosition = this.lineColToPosition(token.getLine(), token.getColumn());
        this.currentUnresolvedVal.accessPosition = tokenPosition - this.getTopNodeOffset();
    }

    @Override
    protected void gotCompoundComponent(LocatableToken token) {
        super.gotCompoundComponent(token);
        this.currentUnresolvedVal.components.add(token);
    }

    @Override
    protected void completeCompoundValue(LocatableToken token) {
        super.completeCompoundValue(token);
        this.currentUnresolvedVal.components.add(token);
        this.valueReferences.add(this.currentUnresolvedVal);
    }

    @Override
    protected void completeCompoundClass(LocatableToken token) {
        JavaEntity entity;
        super.completeCompoundClass(token);
        List<LocatableToken> components = this.currentUnresolvedVal.components;
        components.add(token);
        Iterator<LocatableToken> i = components.iterator();
        int tokpos = this.lineColToPosition(token.getLine(), token.getColumn());
        int offset = tokpos - this.getTopNodeOffset();
        for (entity = UnresolvedEntity.getEntity(new PositionedResolver((JavaParentNode)this.scopeStack.peek(), offset), i.next().getText(), this.currentQuerySource()); entity != null && i.hasNext(); entity = entity.getSubentity(i.next().getText(), this.currentQuerySource())) {
        }
        if (entity != null) {
            this.typeReferences.add(entity);
        }
    }

    @Override
    protected void gotMethodDeclaration(LocatableToken token, LocatableToken hiddenToken) {
        super.gotMethodDeclaration(token, hiddenToken);
        String lastComment = hiddenToken != null ? hiddenToken.getText() : null;
        this.currentMethod = new MethodDesc();
        this.currentMethod.returnType = ((MethodNode)this.scopeStack.peek()).getReturnType();
        this.currentMethod.name = token.getText();
        this.currentMethod.paramNames = "";
        this.currentMethod.paramTypes = new LinkedList<JavaEntity>();
        this.currentMethod.javadocText = lastComment;
        this.arrayCount = 0;
    }

    @Override
    protected void gotConstructorDecl(LocatableToken token, LocatableToken hiddenToken) {
        super.gotConstructorDecl(token, hiddenToken);
        String lastComment = hiddenToken != null ? hiddenToken.getText() : null;
        this.currentMethod = new MethodDesc();
        this.currentMethod.name = token.getText();
        this.currentMethod.paramNames = "";
        this.currentMethod.paramTypes = new LinkedList<JavaEntity>();
        this.currentMethod.javadocText = lastComment;
        this.arrayCount = 0;
    }

    @Override
    protected void gotMethodParameter(LocatableToken token, LocatableToken ellipsisToken) {
        super.gotMethodParameter(token, ellipsisToken);
        if (this.currentMethod != null && this.lastTypespecToks != null) {
            this.currentMethod.paramNames = this.currentMethod.paramNames + token.getText() + " ";
            JavaEntity ptype = ParseUtils.getTypeEntity((EntityResolver)this.scopeStack.peek(), this.currentQuerySource(), this.lastTypespecToks);
            while (this.arrayCount > 0) {
                ptype = new UnresolvedArray(ptype);
                --this.arrayCount;
            }
            if (ellipsisToken != null) {
                ptype = new UnresolvedArray(ptype);
            }
            this.currentMethod.paramTypes.add(ptype);
        }
    }

    @Override
    protected void gotArrayDeclarator() {
        super.gotArrayDeclarator();
        ++this.arrayCount;
    }

    @Override
    protected void gotAllMethodParameters() {
        super.gotAllMethodParameters();
        if (this.storeCurrentClassInfo && this.classLevel == 1) {
            this.methodDescs.add(this.currentMethod);
            this.currentMethod = null;
        }
    }

    @Override
    protected void gotTypeDef(LocatableToken firstToken, int tdType) {
        this.isPublic = this.modPublic;
        this.isAbstract = this.modAbstract;
        this.comment = firstToken.getHiddenBefore() == null ? "" : firstToken.getHiddenBefore().getText();
        super.gotTypeDef(firstToken, tdType);
        this.lastTdType = tdType;
    }

    @Override
    protected void gotTypeDefName(LocatableToken nameToken) {
        super.gotTypeDefName(nameToken);
        this.gotExtends = false;
        this.gotImplements = false;
        if (this.classLevel == 0) {
            if (this.info == null || this.isPublic && !this.info.foundPublicClass()) {
                this.info = new ClassInfo();
                this.info.setName(nameToken.getText(), this.isPublic);
                this.info.setEnum(this.lastTdType == 2);
                this.info.setInterface(this.lastTdType == 1);
                this.info.setAbstract(this.isAbstract);
                this.info.addComment(this.info.getName(), this.comment, null);
                Selection insertSelection = new Selection(nameToken.getLine(), nameToken.getEndColumn());
                this.info.setExtendsInsertSelection(insertSelection);
                this.info.setImplementsInsertSelection(insertSelection);
                if (this.pkgSemiToken != null) {
                    this.info.setPackageSelections(this.getSelection(this.pkgLiteralToken), this.getSelection(this.packageTokens), InfoParser.joinTokens(this.packageTokens), this.getSelection(this.pkgSemiToken));
                }
                this.storeCurrentClassInfo = true;
            } else {
                this.storeCurrentClassInfo = false;
            }
        }
    }

    @Override
    protected void beginTypeDefExtends(LocatableToken extendsToken) {
        super.beginTypeDefExtends(extendsToken);
        if (this.classLevel == 0 && this.storeCurrentClassInfo) {
            this.gotExtends = true;
            SourceLocation extendsStart = this.info.getExtendsInsertSelection().getStartLocation();
            int extendsEndCol = this.tokenStream.LA(1).getColumn();
            int extendsEndLine = this.tokenStream.LA(1).getLine();
            if (extendsStart.getLine() == extendsEndLine) {
                this.info.setExtendsReplaceSelection(new Selection(extendsEndLine, extendsStart.getColumn(), extendsEndCol - extendsStart.getColumn()));
            } else {
                this.info.setExtendsReplaceSelection(new Selection(extendsEndLine, extendsStart.getColumn(), extendsToken.getEndColumn() - extendsStart.getColumn()));
            }
            this.info.setExtendsInsertSelection(null);
            if (this.info.isInterface()) {
                this.interfaceSelections = new LinkedList<Selection>();
                this.interfaceSelections.add(this.getSelection(extendsToken));
                this.interfaceEntities = new LinkedList<JavaEntity>();
            }
        }
    }

    @Override
    protected void beginTypeDefImplements(LocatableToken implementsToken) {
        super.beginTypeDefImplements(implementsToken);
        if (this.classLevel == 0 && this.storeCurrentClassInfo) {
            this.gotExtends = false;
            this.gotImplements = true;
            this.interfaceSelections = new LinkedList<Selection>();
            this.interfaceSelections.add(this.getSelection(implementsToken));
            this.interfaceEntities = new LinkedList<JavaEntity>();
        }
    }

    @Override
    protected void beginPackageStatement(LocatableToken token) {
        super.beginPackageStatement(token);
        this.pkgLiteralToken = token;
    }

    @Override
    protected void gotPackage(List<LocatableToken> pkgTokens) {
        super.gotPackage(pkgTokens);
        this.packageTokens = pkgTokens;
    }

    @Override
    protected void gotPackageSemi(LocatableToken token) {
        super.gotPackageSemi(token);
        this.pkgSemiToken = token;
    }

    @Override
    protected void gotModifier(LocatableToken token) {
        super.gotModifier(token);
        if (token.getType() == 89) {
            this.modPublic = true;
        } else if (token.getType() == 40) {
            this.modAbstract = true;
        }
    }

    @Override
    protected void modifiersConsumed() {
        this.modPublic = false;
        this.modAbstract = false;
    }

    private Selection getSelection(LocatableToken token) {
        if (token.getLine() <= 0 || token.getColumn() <= 0) {
            System.out.println("" + token);
        }
        if (token.getLength() < 0) {
            System.out.println("Bad length: " + token.getLength());
            System.out.println("" + token);
        }
        return new Selection(token.getLine(), token.getColumn(), token.getLength());
    }

    private Selection getSelection(List<LocatableToken> tokens) {
        Iterator<LocatableToken> i = tokens.iterator();
        Selection s = this.getSelection(i.next());
        if (i.hasNext()) {
            LocatableToken last = i.next();
            while (i.hasNext()) {
                last = i.next();
            }
            s.combineWith(this.getSelection(last));
        }
        return s;
    }

    class UnresolvedVal {
        List<LocatableToken> components;
        JavaParentNode resolver;
        Reflective accessSource;
        int accessPosition;

        UnresolvedVal() {
        }
    }

    class MethodDesc {
        String name;
        JavaEntity returnType;
        List<JavaEntity> paramTypes;
        String paramNames;
        String javadocText;

        MethodDesc() {
        }
    }
}

