/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;

public class GitShareCommand
extends GitCommand {
    public GitShareCommand(GitRepository repository) {
        super(repository);
    }

    @Override
    public TeamworkCommandResult getResult() {
        try {
            if (!this.isRemoteRepoEmpty()) {
                return new TeamworkCommandError("Remote Git repository already has a project.", "Remote Git repository already has a project.");
            }
            Git.init().setDirectory(this.getRepository().getProjectPath()).call();
            Git repo = Git.open((File)this.getRepository().getProjectPath());
            StoredConfig config = repo.getRepository().getConfig();
            config.setString("remote", "origin", "url", this.getRepository().getReposUrl());
            config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
            config.setString("branch", "master", "remote", "origin");
            config.setString("branch", "master", "merge", "refs/heads/master");
            config.save();
            repo.close();
        }
        catch (IOException | GitAPIException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        return new TeamworkCommandResult();
    }

    private boolean isRemoteRepoEmpty() throws GitAPIException {
        String gitUrl = this.getRepository().getReposUrl();
        LsRemoteCommand lsRemoteCommand = Git.lsRemoteRepository();
        lsRemoteCommand.setRemote(gitUrl);
        lsRemoteCommand.setCredentialsProvider((CredentialsProvider)this.getRepository().getCredentialsProvider());
        this.disableFingerprintCheck((TransportCommand)lsRemoteCommand);
        lsRemoteCommand.setTags(false);
        lsRemoteCommand.setHeads(false);
        Collection ref = lsRemoteCommand.call();
        return ref.isEmpty();
    }
}

