/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.git.GitCloneCommand;
import bluej.groupwork.git.GitCommitAllCommand;
import bluej.groupwork.git.GitHistoryCommand;
import bluej.groupwork.git.GitPushChangesCommand;
import bluej.groupwork.git.GitShareCommand;
import bluej.groupwork.git.GitStatusCommand;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitRepository
implements Repository {
    private final File projectPath;
    private final String protocol;
    private String reposUrl;
    private final String userName;
    private String password;
    private final String yourName;
    private final String yourEmail;
    private final String branch;

    public GitRepository(File projectPath, String protocol, String reposUrl, String branch, String userName, String password, String yourName, String yourEmail) {
        this.projectPath = projectPath;
        this.protocol = protocol;
        this.reposUrl = reposUrl;
        this.branch = branch;
        this.userName = userName;
        this.password = password;
        this.yourName = yourName;
        this.yourEmail = yourEmail;
    }

    public String getReposUrl() {
        return this.reposUrl;
    }

    @Override
    public void setPassword(TeamSettings newSettings) {
        this.password = newSettings.getPassword();
    }

    @Override
    public boolean versionsDirectories() {
        return true;
    }

    @Override
    public TeamworkCommand checkout(File projectPath) {
        return new GitCloneCommand(this, projectPath);
    }

    @Override
    public TeamworkCommand commitAll(Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, String commitComment) {
        newFiles.addAll(binaryNewFiles);
        return new GitCommitAllCommand(this, newFiles, deletedFiles, files, commitComment);
    }

    @Override
    public TeamworkCommand shareProject() {
        return new GitShareCommand(this);
    }

    @Override
    public TeamworkCommand pushChanges() {
        return new GitPushChangesCommand(this);
    }

    @Override
    public TeamworkCommand getStatus(StatusListener listener, FileFilter filter, boolean includeRemote) {
        return new GitStatusCommand(this, listener, filter, includeRemote);
    }

    @Override
    public TeamworkCommand getModules(List<String> modules) {
        return null;
    }

    @Override
    public TeamworkCommand getLogHistory(LogHistoryListener listener) {
        return new GitHistoryCommand(this, listener);
    }

    @Override
    public boolean prepareDeleteDir(File dir) {
        return true;
    }

    @Override
    public void prepareCreateDir(File dir) {
    }

    @Override
    public FileFilter getMetadataFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().equals(".git");
            }
        };
    }

    @Override
    public void getAllLocallyDeletedFiles(Set<File> files) {
        try (Git repo = Git.open((File)this.getProjectPath());){
            Status s = repo.status().call();
            Set filesStr = s.getMissing();
            filesStr.stream().forEach(fileName -> files.add(new File((String)fileName)));
        }
        catch (IOException | GitAPIException | NoWorkTreeException ex) {
            Debug.reportError("Git get all locally deleted command exception", ex);
        }
    }

    @Override
    public String getVCSType() {
        return "Git";
    }

    @Override
    public String getVCSProtocol() {
        return this.protocol;
    }

    public UsernamePasswordCredentialsProvider getCredentialsProvider() {
        UsernamePasswordCredentialsProvider cp = new UsernamePasswordCredentialsProvider(this.userName, this.password == null ? "" : this.password);
        return cp;
    }

    public String getYourName() {
        return this.yourName;
    }

    public String getYourEmail() {
        return this.yourEmail;
    }

    protected File getProjectPath() {
        return this.projectPath;
    }

    public String getBranch() {
        return this.branch;
    }
}

