/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.actions.TeamAction;
import bluej.groupwork.ui.ConflictsDialog;
import bluej.groupwork.ui.UpdateFilesFrame;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.JavaNames;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.stage.Stage;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class UpdateAction
extends TeamAction {
    private boolean includeLayout = true;
    private UpdateFilesFrame updateFrame;
    private UpdateWorker worker;
    private Set<File> filesToUpdate;
    private Set<File> filesToForceUpdate;
    private StatusHandle statusHandle;
    private List<String> removedPackages;

    public UpdateAction(UpdateFilesFrame updateFrame) {
        super(Config.getString("team.update"), false);
        this.setShortDescription(Config.getString("tooltip.update"));
        this.updateFrame = updateFrame;
    }

    public void setFilesToUpdate(Set<File> files) {
        this.filesToUpdate = files;
    }

    public void setFilesToForceUpdate(Set<File> files) {
        this.filesToForceUpdate = files;
    }

    public void setStatusHandle(StatusHandle statusHandle) {
        this.statusHandle = statusHandle;
    }

    @Override
    protected void actionPerformed(Project project) {
        this.updateFrame.startProgress();
        PkgMgrFrame.displayMessage(project, Config.getString("team.update.statusMessage"));
        this.worker = new UpdateWorker(project, this.statusHandle, this.filesToUpdate, this.filesToForceUpdate);
        this.worker.start();
        this.updateFrame.disableLayoutCheck();
    }

    public void cancel() {
        if (this.worker != null) {
            this.worker.abort();
        }
        this.setEnabled(true);
    }

    private String filenameToTargetIdentifier(String filename) {
        int lastDot = filename.lastIndexOf(46);
        return filename.substring(0, lastDot);
    }

    @OnThread(value=Tag.Any)
    private static String makeRelativePath(File parent, File file) {
        String parentStr = parent.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(parentStr)) {
            filePath = filePath.substring(parentStr.length() + 1);
        }
        return filePath;
    }

    private class UpdateWorker
    extends FXWorker
    implements UpdateListener {
        private Project project;
        private TeamworkCommand command;
        private TeamworkCommandResult result;
        private boolean aborted;

        public UpdateWorker(Project project, StatusHandle statusHandle, Set<File> filesToUpdate, Set<File> filesToForceUpdate) {
            this.project = project;
            this.command = statusHandle.updateTo(this, filesToUpdate, filesToForceUpdate);
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            UpdateAction.this.removedPackages = new ArrayList<String>();
            this.result = this.command.getResult();
            return this.result;
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void fileModified(File f) {
            String fileName = f.getName();
            boolean isPkgFile = BlueJPackageFile.isPackageFileName(fileName);
            if (!(fileName.endsWith(".java") || fileName.endsWith(".class") || isPkgFile)) {
                return;
            }
            String packageName = this.project.getPackageForFile(f);
            if (packageName == null) {
                return;
            }
            if (isPkgFile) {
                Package filePackage;
                String parentPackageName;
                Package parentPackage;
                if (packageName.length() > 0 && (parentPackage = this.project.getCachedPackage(parentPackageName = JavaNames.getPrefix(packageName))) != null) {
                    PackageTarget t = parentPackage.addPackage(JavaNames.getBase(packageName));
                    parentPackage.positionNewTarget(t);
                }
                if ((filePackage = this.project.getCachedPackage(packageName)) != null && UpdateAction.this.includeLayout) {
                    try {
                        filePackage.reReadGraphLayout();
                    }
                    catch (IOException ioe) {
                        Debug.reportError("Error re-reading package file (team update)", ioe);
                    }
                }
            } else {
                int n = fileName.lastIndexOf(".");
                String name = fileName.substring(0, n);
                if (!JavaNames.isIdentifier(name)) {
                    return;
                }
                Package pkg = this.project.getCachedPackage(packageName);
                if (pkg == null) {
                    return;
                }
                Target t = pkg.getTarget(name);
                if (t == null) {
                    ClassTarget ct = pkg.addClass(name);
                    pkg.positionNewTarget(ct);
                    DataCollector.addClass(pkg, ct);
                    return;
                }
                if (t instanceof ClassTarget) {
                    ((ClassTarget)t).reload();
                }
            }
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void fileRemoved(File f) {
            String fileName = f.getName();
            if (!(fileName.endsWith(".java") || fileName.endsWith(".class") || BlueJPackageFile.isPackageFileName(fileName))) {
                return;
            }
            String packageName = this.project.getPackageForFile(f);
            if (packageName == null) {
                return;
            }
            if (BlueJPackageFile.isPackageFileName(fileName)) {
                UpdateAction.this.removedPackages.add(packageName);
            } else {
                int n = fileName.lastIndexOf(".");
                String name = fileName.substring(0, n);
                Package pkg = this.project.getCachedPackage(packageName);
                if (pkg == null) {
                    return;
                }
                Target t = pkg.getTarget(name);
                if (!(t instanceof ClassTarget)) {
                    return;
                }
                ClassTarget ct = (ClassTarget)t;
                if (ct.hasSourceCode() && !fileName.endsWith(".java")) {
                    ct.markModified();
                } else {
                    ct.remove();
                }
            }
        }

        @Override
        @OnThread(value=Tag.FXPlatform)
        public void handleConflicts(UpdateResults updateServerResponse) {
            if (updateServerResponse.getConflicts().isEmpty() && updateServerResponse.getBinaryConflicts().isEmpty()) {
                return;
            }
            HashSet<File> filesToOverride = new HashSet<File>();
            for (File f : updateServerResponse.getBinaryConflicts()) {
                if (BlueJPackageFile.isPackageFileName(f.getName())) {
                    filesToOverride.add(f);
                    continue;
                }
                int answer = DialogManager.askQuestionFX(null, "team-binary-conflict", new String[]{f.getName()});
                if (answer == 0) continue;
                filesToOverride.add(f);
            }
            updateServerResponse.overrideFiles(filesToOverride);
            LinkedList<String> blueJconflicts = new LinkedList<String>();
            LinkedList<String> nonBlueJConflicts = new LinkedList<String>();
            LinkedList<Target> targets = new LinkedList<Target>();
            for (File file : updateServerResponse.getConflicts()) {
                String targetId;
                String pkg;
                String baseName = file.getName();
                if (BlueJPackageFile.isPackageFileName(baseName)) continue;
                Target target = null;
                if (baseName.endsWith(".java") || baseName.endsWith(".class")) {
                    pkg = this.project.getPackageForFile(file);
                    if (pkg != null) {
                        targetId = UpdateAction.this.filenameToTargetIdentifier(baseName);
                        targetId = JavaNames.combineNames(pkg, targetId);
                        target = this.project.getTarget(targetId);
                    }
                } else if (baseName.equals("README.TXT") && (pkg = this.project.getPackageForFile(file)) != null) {
                    targetId = "@README";
                    targetId = JavaNames.combineNames(pkg, targetId);
                    target = this.project.getTarget(targetId);
                }
                String fileName = UpdateAction.makeRelativePath(this.project.getProjectDir(), file);
                if (target == null) {
                    nonBlueJConflicts.add(fileName);
                    continue;
                }
                blueJconflicts.add(fileName);
                targets.add(target);
                if (target.getPackage().getUI() != null) continue;
                PkgMgrFrame.createFrame(target.getPackage(), PkgMgrFrame.getMostRecent());
            }
            if (!blueJconflicts.isEmpty() || !nonBlueJConflicts.isEmpty()) {
                this.project.clearAllSelections();
                this.project.selectTargetsInGraphs(targets);
                Stage stage = targets.isEmpty() ? null : ((Target)targets.get(0)).getPackage().getUI().getStage();
                ConflictsDialog conflictsDialog = new ConflictsDialog(this.project, (Window)stage, blueJconflicts, nonBlueJConflicts);
                conflictsDialog.show();
            } else if (updateServerResponse.mergeCommitNeeded()) {
                DialogManager.showMessageFX(null, "team-merge-commit-needed", new String[0]);
            }
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            this.handleRemovedPkgs();
            UpdateAction.this.updateFrame.stopProgress();
            if (!this.result.isError() && !this.aborted) {
                HashSet<File> files = new HashSet<File>();
                files.addAll(UpdateAction.this.filesToUpdate);
                files.addAll(UpdateAction.this.filesToForceUpdate);
                DataCollector.teamUpdateProject(this.project, UpdateAction.this.statusHandle.getRepository(), files);
                PkgMgrFrame.displayMessage(this.project, Config.getString("team.update.statusDone"));
            } else {
                PkgMgrFrame.displayMessage(this.project, "");
                TeamUtils.handleServerResponseFX(this.result, UpdateAction.this.updateFrame.asWindow());
            }
            if (!this.aborted) {
                UpdateAction.this.updateFrame.setVisible(false);
                UpdateAction.this.updateFrame.close();
                UpdateAction.this.setEnabled(true);
            }
        }

        @OnThread(value=Tag.FXPlatform)
        private void handleRemovedPkgs() {
            for (String packageName : UpdateAction.this.removedPackages) {
                Target target;
                String parentPackage = JavaNames.getPrefix(packageName);
                String baseName = JavaNames.getBase(packageName);
                File packageDir = JavaNames.convertQualifiedNameToFile(packageName, this.project.getProjectDir());
                if (packageDir.exists()) continue;
                Package pkg = this.project.getCachedPackage(packageName);
                if (pkg != null) {
                    pkg.closeAllEditors();
                    PkgMgrFrame frame = PkgMgrFrame.findFrame(pkg);
                    if (frame != null) {
                        frame.doClose(true, false);
                    }
                    this.project.removePackage(packageName);
                }
                if ((pkg = this.project.getCachedPackage(parentPackage)) == null || !((target = pkg.getTarget(baseName)) instanceof PackageTarget)) continue;
                pkg.removeTarget(target);
            }
        }
    }
}

